/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import water.DKV;
import water.H2O;
import water.Iced;
import water.Key;
import water.Keyed;
import water.Value;
import water.api.Route;
import water.api.Schema;
import water.exceptions.H2OIllegalArgumentException;
import water.exceptions.H2OKeyNotFoundArgumentException;
import water.exceptions.H2OKeyWrongTypeArgumentException;
import water.util.Log;
import water.util.ReflectionUtils;

public class Handler
extends H2O.H2OCountedCompleter<Handler> {
    public static Class<? extends Schema> getHandlerMethodInputSchema(Method method) {
        return ReflectionUtils.findMethodParameterClass(method, 1);
    }

    public static Class<? extends Schema> getHandlerMethodOutputSchema(Method method) {
        return ReflectionUtils.findMethodOutputClass(method);
    }

    public Schema handle(int version, Route route, Properties parms, String post_body) throws Exception {
        boolean has_body;
        Class<? extends Schema> handler_schema_class = Handler.getHandlerMethodInputSchema(route._handler_method);
        Schema schema = Schema.newInstance(handler_schema_class);
        Class iced_class = schema.getImplClass();
        if (iced_class != Iced.class) {
            Object defaults = schema.createImpl();
            schema.fillFromImpl(defaults);
        }
        if ((schema = schema.fillFromParms(parms, !(has_body = null != post_body))) == null) {
            throw H2O.fail("fillFromParms returned a null schema for version: " + version + " in: " + this.getClass() + " with params: " + parms);
        }
        if (has_body) {
            schema = schema.fillFromBody(post_body);
        }
        Schema result = null;
        try {
            route._handler_method.setAccessible(true);
            result = (Schema)route._handler_method.invoke((Object)this, version, schema);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getCause();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new RuntimeException(t);
        }
        return result;
    }

    protected StringBuffer markdown(Handler handler, int version, StringBuffer docs, String filename) {
        StringBuffer sb = new StringBuffer();
        Path path = Paths.get(filename, new String[0]);
        try {
            sb.append(Files.readAllBytes(path));
        }
        catch (IOException e) {
            Log.warn("Caught IOException trying to read doc file: ", path);
        }
        if (docs != null) {
            docs.append(sb);
        }
        return sb;
    }

    public static <T extends Keyed> T getFromDKV(String param_name, String key, Class<T> klazz) {
        return Handler.getFromDKV(param_name, Key.make(key), klazz);
    }

    public static <T extends Keyed> T getFromDKV(String param_name, Key key, Class<T> klazz) {
        if (key == null) {
            throw new H2OIllegalArgumentException(param_name, "Handler.getFromDKV()", "null");
        }
        Value v = DKV.get(key);
        if (v == null) {
            throw new H2OKeyNotFoundArgumentException(param_name, key.toString());
        }
        try {
            return (T)((Keyed)klazz.cast(v.get()));
        }
        catch (ClassCastException e) {
            throw new H2OKeyWrongTypeArgumentException(param_name, key.toString(), klazz, v.get().getClass());
        }
    }
}

