/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import water.H2O;
import water.init.NodePersistentStorage;
import water.server.ServletUtils;
import water.util.FileUtils;
import water.util.Log;

public class NpsBinServlet
extends HttpServlet {
    private static final Pattern URL_PATTERN = Pattern.compile(".*/NodePersistentStorage.bin/([^/]+)/([^/]+)");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        String uri = ServletUtils.getDecodedUri(request);
        try {
            String[] params = ServletUtils.parseUriParams(uri, response, URL_PATTERN, 2);
            if (params == null) {
                return;
            }
            String categoryName = params[0];
            String keyName = params[1];
            NodePersistentStorage nps = H2O.getNPS();
            AtomicLong length = new AtomicLong();
            InputStream is = nps.get(categoryName, keyName, length);
            if (length.get() > Integer.MAX_VALUE) {
                throw new Exception("NPS value size exceeds Integer.MAX_VALUE");
            }
            response.setContentType("application/octet-stream");
            response.setContentLength((int)length.get());
            response.addHeader("Content-Disposition", "attachment; filename=" + keyName + ".flow");
            ServletUtils.setResponseStatus(response, 200);
            ServletOutputStream os = null;
            try {
                os = response.getOutputStream();
                FileUtils.copyStream(is, os, 2048);
                if (os == null) return;
            }
            catch (Throwable throwable) {
                if (os == null) throw throwable;
                try {
                    os.close();
                    throw throwable;
                }
                catch (Exception e) {
                    Log.err(e);
                }
                throw throwable;
            }
            try {
                os.close();
                return;
            }
            catch (Exception e) {
                Log.err(e);
            }
            return;
        }
        catch (Exception e) {
            ServletUtils.sendErrorResponse(response, e, uri);
            return;
        }
        finally {
            ServletUtils.logRequest("GET", request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        String uri = ServletUtils.getDecodedUri(request);
        try {
            String[] params = ServletUtils.parseUriParams(uri, response, URL_PATTERN, 2);
            if (params == null) {
                return;
            }
            String categoryName = params[0];
            String keyName = params[1];
            InputStream is = ServletUtils.extractPartInputStream(request, response);
            if (is == null) {
                return;
            }
            H2O.getNPS().put(categoryName, keyName, is);
            long length = H2O.getNPS().get_length(categoryName, keyName);
            String responsePayload = "{ \"category\" : \"" + categoryName + "\", \"name\" : \"" + keyName + "\", \"total_bytes\" : " + length + " }\n";
            response.setContentType("application/json");
            response.getWriter().write(responsePayload);
        }
        catch (Exception e) {
            ServletUtils.sendErrorResponse(response, e, uri);
        }
        finally {
            ServletUtils.logRequest("POST", request, response);
        }
    }
}

