/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import java.util.Arrays;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Key;
import water.Value;
import water.fvec.NewChunk;
import water.fvec.Vec;

public class AppendableVec
extends Vec {
    public long[] _tmp_espc;
    public final int _chunkOff;

    public AppendableVec(Key<Vec> key, byte type) {
        this(key, new long[4], type, 0);
    }

    public AppendableVec(Key<Vec> key, long[] tmp_espc, byte type, int chunkOff) {
        super(key, -1, null, type);
        this._tmp_espc = tmp_espc;
        this._chunkOff = chunkOff;
    }

    synchronized void closeChunk(int cidx, int len) {
        cidx -= this._chunkOff;
        while (cidx >= this._tmp_espc.length) {
            this._tmp_espc = Arrays.copyOf(this._tmp_espc, this._tmp_espc.length << 1);
        }
        this._tmp_espc[cidx] = len;
    }

    public static Vec[] closeAll(AppendableVec[] avs) {
        Futures fs = new Futures();
        Vec[] res = AppendableVec.closeAll(avs, fs);
        fs.blockForPending();
        return res;
    }

    public static Vec[] closeAll(AppendableVec[] avs, Futures fs) {
        Vec[] res = new Vec[avs.length];
        int rowLayout = avs[0].compute_rowLayout();
        for (int i = 0; i < avs.length; ++i) {
            res[i] = avs[i].close(rowLayout, fs);
        }
        return res;
    }

    public void reduce(AppendableVec nv) {
        if (this == nv) {
            return;
        }
        if (this._tmp_espc == nv._tmp_espc) {
            return;
        }
        long[] e1 = nv._tmp_espc;
        if (e1.length > this._tmp_espc.length) {
            e1 = this._tmp_espc;
            this._tmp_espc = nv._tmp_espc;
        }
        for (int i = 0; i < e1.length; ++i) {
            if (this._tmp_espc[i] != 0L || e1[i] == 0L) continue;
            this._tmp_espc[i] = e1[i];
        }
    }

    public Vec layout_and_close(Futures fs) {
        return this.close(this.compute_rowLayout(), fs);
    }

    public int compute_rowLayout() {
        int nchunk;
        for (nchunk = this._tmp_espc.length; nchunk > 1 && this._tmp_espc[nchunk - 1] == 0L; --nchunk) {
        }
        long[] espc = new long[nchunk + 1];
        long x = 0L;
        for (int i = 0; i < nchunk; ++i) {
            espc[i] = x;
            x += this._tmp_espc[i];
        }
        espc[nchunk] = x;
        return Vec.ESPC.rowLayout(this._key, espc);
    }

    public Vec close(int rowLayout, Futures fs) {
        int nchunk = this._tmp_espc.length;
        DKV.remove(this.chunkKey(nchunk), fs);
        while (nchunk > 1 && this._tmp_espc[nchunk - 1] == 0L) {
            DKV.remove(this.chunkKey(--nchunk), fs);
        }
        Vec vec = new Vec(this._key, rowLayout, this.domain(), this._type);
        DKV.put(this._key, vec, fs);
        return vec;
    }

    @Override
    protected boolean readable() {
        return false;
    }

    @Override
    protected boolean writable() {
        return true;
    }

    @Override
    public NewChunk chunkForChunkIdx(int cidx) {
        return new NewChunk(this, cidx);
    }

    @Override
    public Value chunkIdx(int cidx) {
        throw H2O.fail();
    }

    @Override
    public long length() {
        throw H2O.fail();
    }

    @Override
    public int nChunks() {
        throw H2O.fail();
    }

    @Override
    public int nonEmptyChunks() {
        throw H2O.fail();
    }

    @Override
    public int elem2ChunkIdx(long i) {
        throw H2O.fail();
    }

    @Override
    protected long chunk2StartElem(int cidx) {
        throw H2O.fail();
    }

    @Override
    public long byteSize() {
        return 0L;
    }

    @Override
    public String toString() {
        return "[AppendableVec, unknown size]";
    }
}

