/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.fvec.C1Chunk;
import water.fvec.C1NChunk;
import water.fvec.C1SChunk;
import water.fvec.C2Chunk;
import water.fvec.C2SChunk;
import water.fvec.C4Chunk;
import water.fvec.C4FChunk;
import water.fvec.C4SChunk;
import water.fvec.C8Chunk;
import water.fvec.C8DChunk;
import water.fvec.Chunk;
import water.fvec.RollupStats;

public class RollupStatsHelpers {
    private final RollupStats _rs;

    RollupStatsHelpers(RollupStats rs) {
        this._rs = rs;
    }

    public long numericChunkRollup(Chunk c, long start, long checksum) {
        long pinfs = 0L;
        long ninfs = 0L;
        long naCnt = 0L;
        long nzCnt = 0L;
        boolean isInt = this._rs._isInt;
        boolean hasNA = c.hasNA();
        boolean hasFloat = c.hasFloat();
        double dmin = this._rs._mins[this._rs._mins.length - 1];
        double dmax = this._rs._maxs[this._rs._maxs.length - 1];
        assert (this._rs._pinfs == 0L);
        assert (this._rs._ninfs == 0L);
        assert (this._rs._naCnt == 0L);
        assert (this._rs._nzCnt == 0L);
        assert (dmin == Double.MAX_VALUE);
        assert (dmax == -1.7976931348623157E308);
        long rows = 0L;
        double mean = 0.0;
        double M2 = 0.0;
        int i = c.nextNZ(-1);
        while (i < c._len) {
            if (hasNA && c.isNA(i)) {
                ++naCnt;
            } else {
                long l;
                double x = c.atd(i);
                long l2 = l = hasFloat ? Double.doubleToRawLongBits(x) : c.at8(i);
                if (l != 0L) {
                    checksum ^= 17L * (start + (long)i) ^ 23L * l;
                }
                if (x == Double.POSITIVE_INFINITY) {
                    ++pinfs;
                } else if (x == Double.NEGATIVE_INFINITY) {
                    ++ninfs;
                } else {
                    if (x != 0.0) {
                        ++nzCnt;
                    }
                    if (x < dmin) {
                        dmin = this._rs.min(x);
                    }
                    if (x > dmax) {
                        dmax = this._rs.max(x);
                    }
                    if (isInt) {
                        isInt = (double)((long)x) == x;
                    }
                    double delta = x - mean;
                    M2 += delta * (x - (mean += delta / (double)(++rows)));
                }
            }
            i = c.nextNZ(i);
        }
        this._rs._pinfs = pinfs;
        this._rs._ninfs = ninfs;
        this._rs._naCnt = naCnt;
        this._rs._nzCnt = nzCnt;
        this._rs._rows += rows;
        this._rs._isInt = isInt;
        this._rs._mean = mean;
        this._rs._sigma = M2;
        return checksum;
    }

    public long numericChunkRollup(C1Chunk c, long start, long checksum) {
        long pinfs = 0L;
        long ninfs = 0L;
        long naCnt = 0L;
        long nzCnt = 0L;
        boolean isInt = true;
        boolean hasNA = true;
        double dmin = this._rs._mins[this._rs._mins.length - 1];
        double dmax = this._rs._maxs[this._rs._maxs.length - 1];
        assert (this._rs._pinfs == 0L);
        assert (this._rs._ninfs == 0L);
        assert (this._rs._naCnt == 0L);
        assert (this._rs._nzCnt == 0L);
        assert (dmin == Double.MAX_VALUE);
        assert (dmax == -1.7976931348623157E308);
        long rows = 0L;
        double mean = 0.0;
        double M2 = 0.0;
        int len = c._len;
        for (int i = 0; i < len; ++i) {
            if (hasNA && c.isNA(i)) {
                ++naCnt;
                continue;
            }
            long l = c.at8(i);
            double x = l;
            if (l != 0L) {
                checksum ^= 17L * (start + (long)i) ^ 23L * l;
            }
            if (x != 0.0) {
                ++nzCnt;
            }
            if (x < dmin) {
                dmin = this._rs.min(x);
            }
            if (x > dmax) {
                dmax = this._rs.max(x);
            }
            double delta = x - mean;
            M2 += delta * (x - (mean += delta / (double)(++rows)));
        }
        this._rs._pinfs = pinfs;
        this._rs._ninfs = ninfs;
        this._rs._naCnt = naCnt;
        this._rs._nzCnt = nzCnt;
        this._rs._rows += rows;
        this._rs._isInt = isInt;
        this._rs._mean = mean;
        this._rs._sigma = M2;
        return checksum;
    }

    public long numericChunkRollup(C1NChunk c, long start, long checksum) {
        long pinfs = 0L;
        long ninfs = 0L;
        long naCnt = 0L;
        long nzCnt = 0L;
        boolean isInt = true;
        boolean hasNA = false;
        double dmin = this._rs._mins[this._rs._mins.length - 1];
        double dmax = this._rs._maxs[this._rs._maxs.length - 1];
        assert (this._rs._pinfs == 0L);
        assert (this._rs._ninfs == 0L);
        assert (this._rs._naCnt == 0L);
        assert (this._rs._nzCnt == 0L);
        assert (dmin == Double.MAX_VALUE);
        assert (dmax == -1.7976931348623157E308);
        long rows = 0L;
        double mean = 0.0;
        double M2 = 0.0;
        int len = c._len;
        for (int i = 0; i < len; ++i) {
            if (hasNA && c.isNA(i)) {
                ++naCnt;
                continue;
            }
            long l = c.at8(i);
            double x = l;
            if (l != 0L) {
                checksum ^= 17L * (start + (long)i) ^ 23L * l;
            }
            if (x != 0.0) {
                ++nzCnt;
            }
            if (x < dmin) {
                dmin = this._rs.min(x);
            }
            if (x > dmax) {
                dmax = this._rs.max(x);
            }
            double delta = x - mean;
            M2 += delta * (x - (mean += delta / (double)(++rows)));
        }
        this._rs._pinfs = pinfs;
        this._rs._ninfs = ninfs;
        this._rs._naCnt = naCnt;
        this._rs._nzCnt = nzCnt;
        this._rs._rows += rows;
        this._rs._isInt = isInt;
        this._rs._mean = mean;
        this._rs._sigma = M2;
        return checksum;
    }

    public long numericChunkRollup(C1SChunk c, long start, long checksum) {
        long pinfs = 0L;
        long ninfs = 0L;
        long naCnt = 0L;
        long nzCnt = 0L;
        boolean isInt = this._rs._isInt;
        boolean hasNA = c.hasNA();
        boolean hasFloat = c.hasFloat();
        double dmin = this._rs._mins[this._rs._mins.length - 1];
        double dmax = this._rs._maxs[this._rs._maxs.length - 1];
        assert (this._rs._pinfs == 0L);
        assert (this._rs._ninfs == 0L);
        assert (this._rs._naCnt == 0L);
        assert (this._rs._nzCnt == 0L);
        assert (dmin == Double.MAX_VALUE);
        assert (dmax == -1.7976931348623157E308);
        long rows = 0L;
        double mean = 0.0;
        double M2 = 0.0;
        int len = c._len;
        for (int i = 0; i < len; ++i) {
            long l;
            if (hasNA && c.isNA(i)) {
                ++naCnt;
                continue;
            }
            double x = c.atd(i);
            long l2 = l = hasFloat ? Double.doubleToRawLongBits(x) : c.at8(i);
            if (l != 0L) {
                checksum ^= 17L * (start + (long)i) ^ 23L * l;
            }
            if (x == Double.POSITIVE_INFINITY) {
                ++pinfs;
                continue;
            }
            if (x == Double.NEGATIVE_INFINITY) {
                ++ninfs;
                continue;
            }
            if (x != 0.0) {
                ++nzCnt;
            }
            if (x < dmin) {
                dmin = this._rs.min(x);
            }
            if (x > dmax) {
                dmax = this._rs.max(x);
            }
            if (isInt) {
                isInt = (double)((long)x) == x;
            }
            double delta = x - mean;
            M2 += delta * (x - (mean += delta / (double)(++rows)));
        }
        this._rs._pinfs = pinfs;
        this._rs._ninfs = ninfs;
        this._rs._naCnt = naCnt;
        this._rs._nzCnt = nzCnt;
        this._rs._rows += rows;
        this._rs._isInt = isInt;
        this._rs._mean = mean;
        this._rs._sigma = M2;
        return checksum;
    }

    public long numericChunkRollup(C2Chunk c, long start, long checksum) {
        long pinfs = 0L;
        long ninfs = 0L;
        long naCnt = 0L;
        long nzCnt = 0L;
        boolean isInt = true;
        boolean hasNA = true;
        double dmin = this._rs._mins[this._rs._mins.length - 1];
        double dmax = this._rs._maxs[this._rs._maxs.length - 1];
        assert (this._rs._pinfs == 0L);
        assert (this._rs._ninfs == 0L);
        assert (this._rs._naCnt == 0L);
        assert (this._rs._nzCnt == 0L);
        assert (dmin == Double.MAX_VALUE);
        assert (dmax == -1.7976931348623157E308);
        long rows = 0L;
        double mean = 0.0;
        double M2 = 0.0;
        int len = c._len;
        for (int i = 0; i < len; ++i) {
            if (hasNA && c.isNA(i)) {
                ++naCnt;
                continue;
            }
            long l = c.at8(i);
            double x = l;
            if (l != 0L) {
                checksum ^= 17L * (start + (long)i) ^ 23L * l;
            }
            if (x != 0.0) {
                ++nzCnt;
            }
            if (x < dmin) {
                dmin = this._rs.min(x);
            }
            if (x > dmax) {
                dmax = this._rs.max(x);
            }
            double delta = x - mean;
            M2 += delta * (x - (mean += delta / (double)(++rows)));
        }
        this._rs._pinfs = pinfs;
        this._rs._ninfs = ninfs;
        this._rs._naCnt = naCnt;
        this._rs._nzCnt = nzCnt;
        this._rs._rows += rows;
        this._rs._isInt = isInt;
        this._rs._mean = mean;
        this._rs._sigma = M2;
        return checksum;
    }

    public long numericChunkRollup(C2SChunk c, long start, long checksum) {
        long pinfs = 0L;
        long ninfs = 0L;
        long naCnt = 0L;
        long nzCnt = 0L;
        boolean isInt = this._rs._isInt;
        boolean hasNA = c.hasNA();
        boolean hasFloat = c.hasFloat();
        double dmin = this._rs._mins[this._rs._mins.length - 1];
        double dmax = this._rs._maxs[this._rs._maxs.length - 1];
        assert (this._rs._pinfs == 0L);
        assert (this._rs._ninfs == 0L);
        assert (this._rs._naCnt == 0L);
        assert (this._rs._nzCnt == 0L);
        assert (dmin == Double.MAX_VALUE);
        assert (dmax == -1.7976931348623157E308);
        long rows = 0L;
        double mean = 0.0;
        double M2 = 0.0;
        int len = c._len;
        for (int i = 0; i < len; ++i) {
            long l;
            if (hasNA && c.isNA(i)) {
                ++naCnt;
                continue;
            }
            double x = c.atd(i);
            long l2 = l = hasFloat ? Double.doubleToRawLongBits(x) : c.at8(i);
            if (l != 0L) {
                checksum ^= 17L * (start + (long)i) ^ 23L * l;
            }
            if (x == Double.POSITIVE_INFINITY) {
                ++pinfs;
                continue;
            }
            if (x == Double.NEGATIVE_INFINITY) {
                ++ninfs;
                continue;
            }
            if (x != 0.0) {
                ++nzCnt;
            }
            if (x < dmin) {
                dmin = this._rs.min(x);
            }
            if (x > dmax) {
                dmax = this._rs.max(x);
            }
            if (isInt) {
                isInt = (double)((long)x) == x;
            }
            double delta = x - mean;
            M2 += delta * (x - (mean += delta / (double)(++rows)));
        }
        this._rs._pinfs = pinfs;
        this._rs._ninfs = ninfs;
        this._rs._naCnt = naCnt;
        this._rs._nzCnt = nzCnt;
        this._rs._rows += rows;
        this._rs._isInt = isInt;
        this._rs._mean = mean;
        this._rs._sigma = M2;
        return checksum;
    }

    public long numericChunkRollup(C4Chunk c, long start, long checksum) {
        long pinfs = 0L;
        long ninfs = 0L;
        long naCnt = 0L;
        long nzCnt = 0L;
        boolean isInt = true;
        boolean hasNA = true;
        double dmin = this._rs._mins[this._rs._mins.length - 1];
        double dmax = this._rs._maxs[this._rs._maxs.length - 1];
        assert (this._rs._pinfs == 0L);
        assert (this._rs._ninfs == 0L);
        assert (this._rs._naCnt == 0L);
        assert (this._rs._nzCnt == 0L);
        assert (dmin == Double.MAX_VALUE);
        assert (dmax == -1.7976931348623157E308);
        long rows = 0L;
        double mean = 0.0;
        double M2 = 0.0;
        int len = c._len;
        for (int i = 0; i < len; ++i) {
            if (hasNA && c.isNA(i)) {
                ++naCnt;
                continue;
            }
            long l = c.at8(i);
            double x = l;
            if (l != 0L) {
                checksum ^= 17L * (start + (long)i) ^ 23L * l;
            }
            if (x != 0.0) {
                ++nzCnt;
            }
            if (x < dmin) {
                dmin = this._rs.min(x);
            }
            if (x > dmax) {
                dmax = this._rs.max(x);
            }
            double delta = x - mean;
            M2 += delta * (x - (mean += delta / (double)(++rows)));
        }
        this._rs._pinfs = pinfs;
        this._rs._ninfs = ninfs;
        this._rs._naCnt = naCnt;
        this._rs._nzCnt = nzCnt;
        this._rs._rows += rows;
        this._rs._isInt = isInt;
        this._rs._mean = mean;
        this._rs._sigma = M2;
        return checksum;
    }

    public long numericChunkRollup(C4FChunk c, long start, long checksum) {
        long pinfs = 0L;
        long ninfs = 0L;
        long naCnt = 0L;
        long nzCnt = 0L;
        boolean isInt = this._rs._isInt;
        boolean hasNA = c.hasNA();
        boolean hasFloat = c.hasFloat();
        double dmin = this._rs._mins[this._rs._mins.length - 1];
        double dmax = this._rs._maxs[this._rs._maxs.length - 1];
        assert (this._rs._pinfs == 0L);
        assert (this._rs._ninfs == 0L);
        assert (this._rs._naCnt == 0L);
        assert (this._rs._nzCnt == 0L);
        assert (dmin == Double.MAX_VALUE);
        assert (dmax == -1.7976931348623157E308);
        long rows = 0L;
        double mean = 0.0;
        double M2 = 0.0;
        int len = c._len;
        for (int i = 0; i < len; ++i) {
            long l;
            if (hasNA && c.isNA(i)) {
                ++naCnt;
                continue;
            }
            double x = c.atd(i);
            long l2 = l = hasFloat ? Double.doubleToRawLongBits(x) : c.at8(i);
            if (l != 0L) {
                checksum ^= 17L * (start + (long)i) ^ 23L * l;
            }
            if (x == Double.POSITIVE_INFINITY) {
                ++pinfs;
                continue;
            }
            if (x == Double.NEGATIVE_INFINITY) {
                ++ninfs;
                continue;
            }
            if (x != 0.0) {
                ++nzCnt;
            }
            if (x < dmin) {
                dmin = this._rs.min(x);
            }
            if (x > dmax) {
                dmax = this._rs.max(x);
            }
            if (isInt) {
                isInt = (double)((long)x) == x;
            }
            double delta = x - mean;
            M2 += delta * (x - (mean += delta / (double)(++rows)));
        }
        this._rs._pinfs = pinfs;
        this._rs._ninfs = ninfs;
        this._rs._naCnt = naCnt;
        this._rs._nzCnt = nzCnt;
        this._rs._rows += rows;
        this._rs._isInt = isInt;
        this._rs._mean = mean;
        this._rs._sigma = M2;
        return checksum;
    }

    public long numericChunkRollup(C4SChunk c, long start, long checksum) {
        long pinfs = 0L;
        long ninfs = 0L;
        long naCnt = 0L;
        long nzCnt = 0L;
        boolean isInt = this._rs._isInt;
        boolean hasNA = c.hasNA();
        boolean hasFloat = c.hasFloat();
        double dmin = this._rs._mins[this._rs._mins.length - 1];
        double dmax = this._rs._maxs[this._rs._maxs.length - 1];
        assert (this._rs._pinfs == 0L);
        assert (this._rs._ninfs == 0L);
        assert (this._rs._naCnt == 0L);
        assert (this._rs._nzCnt == 0L);
        assert (dmin == Double.MAX_VALUE);
        assert (dmax == -1.7976931348623157E308);
        long rows = 0L;
        double mean = 0.0;
        double M2 = 0.0;
        int len = c._len;
        for (int i = 0; i < len; ++i) {
            long l;
            if (hasNA && c.isNA(i)) {
                ++naCnt;
                continue;
            }
            double x = c.atd(i);
            long l2 = l = hasFloat ? Double.doubleToRawLongBits(x) : c.at8(i);
            if (l != 0L) {
                checksum ^= 17L * (start + (long)i) ^ 23L * l;
            }
            if (x == Double.POSITIVE_INFINITY) {
                ++pinfs;
                continue;
            }
            if (x == Double.NEGATIVE_INFINITY) {
                ++ninfs;
                continue;
            }
            if (x != 0.0) {
                ++nzCnt;
            }
            if (x < dmin) {
                dmin = this._rs.min(x);
            }
            if (x > dmax) {
                dmax = this._rs.max(x);
            }
            if (isInt) {
                isInt = (double)((long)x) == x;
            }
            double delta = x - mean;
            M2 += delta * (x - (mean += delta / (double)(++rows)));
        }
        this._rs._pinfs = pinfs;
        this._rs._ninfs = ninfs;
        this._rs._naCnt = naCnt;
        this._rs._nzCnt = nzCnt;
        this._rs._rows += rows;
        this._rs._isInt = isInt;
        this._rs._mean = mean;
        this._rs._sigma = M2;
        return checksum;
    }

    public long numericChunkRollup(C8Chunk c, long start, long checksum) {
        long pinfs = 0L;
        long ninfs = 0L;
        long naCnt = 0L;
        long nzCnt = 0L;
        boolean isInt = true;
        boolean hasNA = c.hasNA();
        boolean hasFloat = c.hasFloat();
        double dmin = this._rs._mins[this._rs._mins.length - 1];
        double dmax = this._rs._maxs[this._rs._maxs.length - 1];
        assert (this._rs._pinfs == 0L);
        assert (this._rs._ninfs == 0L);
        assert (this._rs._naCnt == 0L);
        assert (this._rs._nzCnt == 0L);
        assert (dmin == Double.MAX_VALUE);
        assert (dmax == -1.7976931348623157E308);
        long rows = 0L;
        double mean = 0.0;
        double M2 = 0.0;
        int len = c._len;
        for (int i = 0; i < len; ++i) {
            if (hasNA && c.isNA(i)) {
                ++naCnt;
                continue;
            }
            long l = c.at8(i);
            double x = l;
            if (l != 0L) {
                checksum ^= 17L * (start + (long)i) ^ 23L * l;
            }
            if (x != 0.0) {
                ++nzCnt;
            }
            if (x < dmin) {
                dmin = this._rs.min(x);
            }
            if (x > dmax) {
                dmax = this._rs.max(x);
            }
            double delta = x - mean;
            M2 += delta * (x - (mean += delta / (double)(++rows)));
        }
        this._rs._pinfs = pinfs;
        this._rs._ninfs = ninfs;
        this._rs._naCnt = naCnt;
        this._rs._nzCnt = nzCnt;
        this._rs._rows += rows;
        this._rs._isInt = isInt;
        this._rs._mean = mean;
        this._rs._sigma = M2;
        return checksum;
    }

    public long numericChunkRollup(C8DChunk c, long start, long checksum) {
        long pinfs = 0L;
        long ninfs = 0L;
        long naCnt = 0L;
        long nzCnt = 0L;
        boolean isInt = this._rs._isInt;
        boolean hasNA = c.hasNA();
        boolean hasFloat = true;
        double dmin = this._rs._mins[this._rs._mins.length - 1];
        double dmax = this._rs._maxs[this._rs._maxs.length - 1];
        assert (this._rs._pinfs == 0L);
        assert (this._rs._ninfs == 0L);
        assert (this._rs._naCnt == 0L);
        assert (this._rs._nzCnt == 0L);
        assert (dmin == Double.MAX_VALUE);
        assert (dmax == -1.7976931348623157E308);
        long rows = 0L;
        double mean = 0.0;
        double M2 = 0.0;
        int len = c._len;
        for (int i = 0; i < len; ++i) {
            long l;
            if (hasNA && c.isNA(i)) {
                ++naCnt;
                continue;
            }
            double x = c.atd(i);
            long l2 = l = hasFloat ? Double.doubleToRawLongBits(x) : c.at8(i);
            if (l != 0L) {
                checksum ^= 17L * (start + (long)i) ^ 23L * l;
            }
            if (x == Double.POSITIVE_INFINITY) {
                ++pinfs;
                continue;
            }
            if (x == Double.NEGATIVE_INFINITY) {
                ++ninfs;
                continue;
            }
            if (x != 0.0) {
                ++nzCnt;
            }
            if (x < dmin) {
                dmin = this._rs.min(x);
            }
            if (x > dmax) {
                dmax = this._rs.max(x);
            }
            if (isInt) {
                isInt = (double)((long)x) == x;
            }
            double delta = x - mean;
            M2 += delta * (x - (mean += delta / (double)(++rows)));
        }
        this._rs._pinfs = pinfs;
        this._rs._ninfs = ninfs;
        this._rs._naCnt = naCnt;
        this._rs._nzCnt = nzCnt;
        this._rs._rows += rows;
        this._rs._isInt = isInt;
        this._rs._mean = mean;
        this._rs._sigma = M2;
        return checksum;
    }
}

