/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.mungers;

import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.rapids.Val;
import water.rapids.ast.AstBuiltin;
import water.rapids.vals.ValFrame;
import water.util.VecUtils;

public class AstPivot
extends AstBuiltin<AstPivot> {
    @Override
    public String[] args() {
        return new String[]{"ary", "index", "column", "value"};
    }

    @Override
    public int nargs() {
        return 5;
    }

    @Override
    public String str() {
        return "pivot";
    }

    @Override
    public ValFrame exec(Val[] args) {
        Frame fr = args[1].getFrame();
        String index = args[2].getStr();
        String column = args[3].getStr();
        String value = args[4].getStr();
        int indexIdx = fr.find(index);
        int colIdx = fr.find(column);
        if (fr.vec(column).isConst()) {
            throw new IllegalArgumentException("Column: '" + column + "'is constant. Perhaps use transpose?");
        }
        if (fr.vec(index).naCnt() > 0L) {
            throw new IllegalArgumentException("Index column '" + index + "' has > 0 NAs");
        }
        Frame fr2 = fr.sort(new int[]{indexIdx});
        long[] classes = ((VecUtils.CollectIntegerDomain)new VecUtils.CollectIntegerDomain().doAll(fr.vec(colIdx))).domain();
        int nClass = fr.vec(colIdx).isNumeric() || fr.vec(colIdx).isTime() ? classes.length : fr.vec(colIdx).domain().length;
        String[] header = null;
        if (fr.vec(colIdx).isNumeric()) {
            header = (String[])ArrayUtils.addAll(new String[]{index}, Arrays.toString(classes).split("[\\[\\]]")[1].split(", "));
        } else if (fr.vec(colIdx).isTime()) {
            header = new String[nClass];
            for (int i = 0; i < nClass; ++i) {
                header[i] = new DateTime(classes[i], DateTimeZone.UTC).toString();
            }
        } else {
            header = (String[])ArrayUtils.addAll(new String[]{index}, fr.vec(colIdx).domain());
        }
        Frame initialPass = ((pivotTask)new pivotTask(fr2.find(index), fr2.find(column), fr2.find(value), classes).doAll(nClass + 1, (byte)3, fr2)).outputFrame(null, header, null);
        fr2.delete();
        Frame result = new Frame(initialPass.vec(0).makeCopy(fr.vec(indexIdx).domain(), fr.vec(indexIdx).get_type()));
        result._key = Key.make();
        result.setNames(new String[]{index});
        initialPass.remove(0);
        result.add(initialPass);
        return new ValFrame(result);
    }

    private class pivotTask
    extends MRTask<pivotTask> {
        int _indexColIdx;
        int _colColIdx;
        int _valColIdx;
        long[] _classes;

        pivotTask(int indexColIdx, int colColIdx, int valColIdx, long[] classes) {
            this._indexColIdx = indexColIdx;
            this._colColIdx = colColIdx;
            this._valColIdx = valColIdx;
            this._classes = classes;
        }

        @Override
        public void map(Chunk[] cs, NewChunk[] nc) {
            long firstIdx = cs[this._indexColIdx].at8(0);
            long globalIdx = cs[this._indexColIdx].start();
            if (globalIdx > 0L && cs[this._indexColIdx].vec().at8(globalIdx - 1L) == firstIdx) {
                for (int start = 0; start < cs[this._indexColIdx].len() && firstIdx == cs[this._indexColIdx].at8(start); ++start) {
                }
            }
            for (int i = start; i < cs[this._indexColIdx]._len; ++i) {
                long currentIdx = cs[this._indexColIdx].at8(i);
                double[] newRow = new double[nc.length - 1];
                Arrays.fill(newRow, Double.NaN);
                if (i == cs[this._indexColIdx]._len - 1 && (cs[this._indexColIdx].nextChunk() == null || cs[this._indexColIdx].nextChunk() != null && currentIdx != cs[this._indexColIdx].nextChunk().at8(0)) || i < cs[this._indexColIdx]._len - 1 && currentIdx != cs[this._indexColIdx].at8(i + 1)) {
                    newRow[ArrayUtils.indexOf((long[])this._classes, (long)cs[this._colColIdx].at8((int)i))] = cs[this._valColIdx].atd(i);
                    nc[0].addNum(cs[this._indexColIdx].at8(i));
                    for (int j = 1; j < nc.length; ++j) {
                        nc[j].addNum(newRow[j - 1]);
                    }
                    continue;
                }
                int count = 1;
                newRow[ArrayUtils.indexOf((long[])this._classes, (long)cs[this._colColIdx].at8((int)i))] = cs[this._valColIdx].atd(i);
                while (count + i < cs[this._indexColIdx]._len && currentIdx == cs[this._indexColIdx].at8(i + count)) {
                    if (Double.isNaN(newRow[ArrayUtils.indexOf(this._classes, cs[this._colColIdx].at8(i + count))])) {
                        newRow[ArrayUtils.indexOf((long[])this._classes, (long)cs[this._colColIdx].at8((int)(i + count)))] = cs[this._valColIdx].atd(i + count);
                    }
                    ++count;
                }
                if (i + count == cs[this._indexColIdx]._len && cs[this._indexColIdx].nextChunk() != null) {
                    Chunk indexNC = cs[this._indexColIdx].nextChunk();
                    Chunk colNC = cs[this._colColIdx].nextChunk();
                    Chunk valNC = cs[this._valColIdx].nextChunk();
                    int countNC = 0;
                    while (indexNC != null && countNC < indexNC._len && currentIdx == indexNC.at8(countNC)) {
                        if (!Double.isNaN(newRow[ArrayUtils.indexOf(this._classes, colNC.at8(countNC))])) continue;
                        newRow[(int)colNC.atd((int)countNC)] = valNC.atd(countNC);
                    }
                    if (++countNC == indexNC._len) {
                        indexNC = indexNC.nextChunk();
                        colNC = colNC.nextChunk();
                        valNC = valNC.nextChunk();
                        countNC = 0;
                    }
                }
                nc[0].addNum(currentIdx);
                for (int j = 1; j < nc.length; ++j) {
                    nc[j].addNum(newRow[j - 1]);
                }
                i += count - 1;
            }
        }
    }
}

