/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.string;

import java.util.HashMap;
import java.util.Iterator;
import water.MRTask;
import water.fvec.C0DChunk;
import water.fvec.CStrChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;

public class AstEntropy
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary"};
    }

    @Override
    public int nargs() {
        return 2;
    }

    @Override
    public String str() {
        return "entropy";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        for (Vec v : fr.vecs()) {
            if (v.isCategorical() || v.isString()) continue;
            throw new IllegalArgumentException("entropy() requires a string or categorical column. Received " + fr.anyVec().get_type_str() + ". Please convert column to a string or categorical first.");
        }
        Vec[] nvs = new Vec[fr.numCols()];
        int i = 0;
        for (Vec v : fr.vecs()) {
            nvs[i] = v.isCategorical() ? this.entropyCategoricalCol(v) : this.entropyStringCol(v);
            ++i;
        }
        return new ValFrame(new Frame(nvs));
    }

    private Vec entropyCategoricalCol(Vec vec) {
        Vec res = ((MRTask)new MRTask(){
            transient double[] catEntropies;

            @Override
            public void setupLocal() {
                String[] doms = this._fr.anyVec().domain();
                this.catEntropies = new double[doms.length];
                for (int i = 0; i < doms.length; ++i) {
                    this.catEntropies[i] = AstEntropy.this.calcEntropy(doms[i]);
                }
            }

            @Override
            public void map(Chunk chk, NewChunk newChk) {
                newChk.alloc_doubles(chk._len);
                for (int i = 0; i < chk._len; ++i) {
                    if (chk.isNA(i)) {
                        newChk.addNA();
                        continue;
                    }
                    newChk.addNum(this.catEntropies[(int)chk.atd(i)]);
                }
            }
        }.doAll(1, (byte)3, new Frame(vec))).outputFrame().anyVec();
        return res;
    }

    private Vec entropyStringCol(Vec vec) {
        return ((MRTask)new MRTask(){

            @Override
            public void map(Chunk chk, NewChunk newChk) {
                if (chk instanceof C0DChunk) {
                    newChk.addNAs(chk.len());
                } else if (((CStrChunk)chk)._isAllASCII) {
                    ((CStrChunk)chk).asciiEntropy(newChk);
                } else {
                    BufferedString tmpStr = new BufferedString();
                    for (int i = 0; i < chk._len; ++i) {
                        if (chk.isNA(i)) {
                            newChk.addNA();
                            continue;
                        }
                        String str = chk.atStr(tmpStr, i).toString();
                        newChk.addNum(AstEntropy.this.calcEntropy(str));
                    }
                }
            }
        }.doAll(new byte[]{3}, vec)).outputFrame().anyVec();
    }

    private double calcEntropy(String str) {
        HashMap<Character, Integer> freq = new HashMap<Character, Integer>();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            Integer count = (Integer)freq.get(Character.valueOf(c));
            if (count == null) {
                freq.put(Character.valueOf(c), 1);
                continue;
            }
            freq.put(Character.valueOf(c), count + 1);
        }
        double sume = 0.0;
        int N = str.length();
        Iterator iterator = freq.keySet().iterator();
        while (iterator.hasNext()) {
            char c = ((Character)iterator.next()).charValue();
            double n = ((Integer)freq.get(Character.valueOf(c))).intValue();
            sume += -n / (double)N * Math.log(n / (double)N) / Math.log(2.0);
        }
        return sume;
    }
}

