/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.time;

import org.joda.time.MutableDateTime;
import water.H2O;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.parser.ParseTime;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;
import water.rapids.vals.ValNum;

public abstract class AstTime
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"time"};
    }

    @Override
    public int nargs() {
        return 2;
    }

    protected String[][] factors() {
        return null;
    }

    public abstract long op(MutableDateTime var1);

    private double op(MutableDateTime dt, double d) {
        dt.setMillis((long)d);
        return this.op(dt);
    }

    @Override
    public Val apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Val val = asts[1].exec(env);
        switch (val.type()) {
            case 1: {
                double d = val.getNum();
                return new ValNum(Double.isNaN(d) ? d : this.op(new MutableDateTime(0L), d));
            }
            case 5: {
                Frame fr = stk.track(val).getFrame();
                if (fr.numCols() > 1) {
                    throw H2O.unimpl();
                }
                return new ValFrame(((MRTask)new MRTask(){

                    @Override
                    public void map(Chunk chk, NewChunk cres) {
                        MutableDateTime mdt = new MutableDateTime(0L, ParseTime.getTimezone());
                        for (int i = 0; i < chk._len; ++i) {
                            cres.addNum(chk.isNA(i) ? Double.NaN : AstTime.this.op(mdt, chk.at8(i)));
                        }
                    }
                }.doAll(1, (byte)3, fr)).outputFrame(fr._names, this.factors()));
            }
        }
        throw H2O.fail();
    }
}

