/*
 * Decompiled with CFR 0.152.
 */
package water.udf;

import water.Iced;
import water.udf.CFunc;
import water.udf.CFuncLoader;
import water.udf.CFuncLoaderService;
import water.udf.CFuncRef;
import water.udf.DkvClassLoader;

public abstract class CFuncObject<T extends CFunc>
extends Iced<CFuncObject> {
    protected final CFuncRef cFuncRef;
    protected transient T func;

    public CFuncObject(CFuncRef cFuncRef) {
        this.cFuncRef = cFuncRef;
    }

    protected void setupLocal() {
        if (this.cFuncRef != null && this.func == null) {
            ClassLoader localCl = this.getFuncClassLoader();
            CFuncLoader loader = CFuncLoaderService.INSTANCE.getByLang(this.cFuncRef.language);
            if (loader != null) {
                this.func = (CFunc)loader.load(this.cFuncRef.funcName, this.getFuncType(), localCl);
            }
        }
    }

    protected ClassLoader getFuncClassLoader() {
        return new DkvClassLoader(this.cFuncRef.getKey(), this.getParentClassloader());
    }

    protected ClassLoader getParentClassloader() {
        return Thread.currentThread().getContextClassLoader();
    }

    protected abstract Class<T> getFuncType();

    public T getFunc() {
        if (this.func == null) {
            this.setupLocal();
        }
        return this.func;
    }
}

