/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.zip.GZIPOutputStream;
import water.Iced;

public class CompressionFactory
extends Iced<CompressionFactory> {
    private final String _name;

    private CompressionFactory(String name) {
        this._name = name;
    }

    OutputStream wrapOutputStream(OutputStream os) throws IOException {
        String n;
        switch (n = this._name.toLowerCase()) {
            case "none": {
                return os;
            }
            case "gzip": {
                return new GZIPOutputStream(os);
            }
            case "bzip2": {
                return this.wrapDynamic("org.python.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream", os);
            }
            case "snappy": {
                return this.wrapDynamic("org.xerial.snappy.SnappyOutputStream", os);
            }
        }
        return this.wrapDynamic(this._name, os);
    }

    private OutputStream wrapDynamic(String className, OutputStream os) {
        try {
            Class<?> cls = Class.forName(className);
            Constructor<?> constructor = cls.getConstructor(OutputStream.class);
            return (OutputStream)constructor.newInstance(os);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("Cannot create a compressor using class " + className, e);
        }
    }

    private void checkAvailability() {
        try {
            this.wrapOutputStream(new ByteArrayOutputStream());
        }
        catch (IOException e) {
            throw new IllegalStateException("Initialization failed for compression method " + this._name, e);
        }
    }

    public static CompressionFactory make(String name) {
        CompressionFactory cf = new CompressionFactory(name);
        cf.checkAvailability();
        return cf;
    }

    public String getName() {
        return this._name;
    }
}

