/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.io.IOException;
import java.io.OutputStream;

public class LineLimitOutputStreamWrapper
extends OutputStream {
    private final OutputStream os;
    private final int lineLimit;
    private int linesCnt = 0;

    public LineLimitOutputStreamWrapper(OutputStream os, int lineLimit) {
        this.os = os;
        this.lineLimit = lineLimit;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.linesCnt < this.lineLimit) {
            this.os.write(b);
            if (b == 10) {
                ++this.linesCnt;
            }
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.linesCnt < this.lineLimit) {
            for (int i = 0; i < len; ++i) {
                if (b[off + i] == 10) {
                    ++this.linesCnt;
                }
                if (this.linesCnt != this.lineLimit) continue;
                len = off + i;
                break;
            }
            this.os.write(b, off, len);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.os.write(b);
    }

    @Override
    public void flush() throws IOException {
        this.os.flush();
    }

    @Override
    public void close() throws IOException {
        this.os.close();
    }
}

