/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.CustomMetric;
import hex.Model;
import hex.ModelMetrics;
import hex.ModelMetricsSupervised;
import java.util.Arrays;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.Frame;

public class ModelMetricsHGLM
extends ModelMetricsSupervised {
    public final double[] _sefe;
    public final double[] _sere;
    public final double[] _fixef;
    public final double[] _ranef;
    public final int[] _randc;
    public final double _varfix;
    public final double[] _varranef;
    public final boolean _converge;
    public final double _dfrefe;
    public final double[] _summvc1;
    public final double[][] _summvc2;
    public final double _hlik;
    public final double _pvh;
    public final double _pbvh;
    public final double _caic;
    public final long _bad;
    public final double _sumetadiffsquare;
    public final double _convergence;
    public final int _iterations;

    public ModelMetricsHGLM(Model model, Frame frame, long nobs, double mse, String[] domain, double sigma, CustomMetric customMetric, double[] sefe, double[] sere, double varfix, double[] varranef, boolean converge, double dfrefe, double[] summvc1, double[][] summvc2, double hlik, double pvh, double pbvh, double cAIC, long bad, double sumEtaDiffSq, double convergence, int[] randC, double[] fixef, double[] ranef, int iter2) {
        super(model, frame, nobs, mse, domain, sigma, customMetric);
        this._sefe = sefe;
        this._sere = sere;
        this._varfix = varfix;
        this._varranef = varranef;
        this._converge = converge;
        this._dfrefe = dfrefe;
        this._summvc1 = summvc1;
        this._summvc2 = summvc2;
        this._hlik = hlik;
        this._pvh = pvh;
        this._pbvh = pbvh;
        this._caic = cAIC;
        this._bad = bad;
        this._sumetadiffsquare = sumEtaDiffSq;
        this._convergence = convergence;
        this._randc = randC;
        this._fixef = fixef;
        this._ranef = ranef;
        this._iterations = iter2;
    }

    public static ModelMetricsHGLM getFromDKV(Model model, Frame frame) {
        ModelMetrics mm = ModelMetrics.getFromDKV(model, frame);
        if (!(mm instanceof ModelMetricsHGLM)) {
            throw new H2OIllegalArgumentException("Expected to find a HGLM ModelMetrics for model: " + model._key.toString() + " and frame: " + frame._key.toString(), "Expected to find a ModelMetricsHGLM for model: " + model._key.toString() + " and frame: " + frame._key.toString() + " but found a: " + (mm == null ? null : mm.getClass()));
        }
        return (ModelMetricsHGLM)mm;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(" standard error of fixed predictors effects: " + Arrays.toString(this._sefe));
        sb.append(" standard error of random effects: " + Arrays.toString(this._sere));
        sb.append(" dispersion parameter of the mean model (residual variance for LMM): " + this._varfix);
        sb.append(" dispersion parameter of the random effects (variance of random effects for GLMM): " + this._varranef);
        if (this._converge) {
            sb.append(" HGLM has converged.");
        } else {
            sb.append(" HGLM has failed to converge.");
        }
        sb.append(" deviance degrees of freedom for mean part of the model: " + this._dfrefe);
        sb.append(" estimates, standard errors of the linear predictor in the dispersion model: " + Arrays.toString(this._summvc1));
        sb.append(" estimates, standard errors of the linear predictor for dispersion parameter of random effects: " + Arrays.toString((Object[])this._summvc2));
        sb.append(" log h-likelihood: " + this._hlik);
        sb.append(" adjusted profile log-likelihood profiled over random effects: " + this._pvh);
        sb.append(" adjusted profile log-likelihood profiled over fixed and random effects: " + this._pbvh);
        sb.append(" conditional AIC: " + this._caic);
        sb.append(" index of the most influential observation: " + this._bad);
        sb.append(" sum(etai-eta0)^2: " + this._sumetadiffsquare);
        sb.append("convergence (sum(etai-eta0)^2/sum(etai)^2): " + this._convergence);
        return sb.toString();
    }

    public static class MetricBuilderHGLM<T extends MetricBuilderHGLM<T>>
    extends ModelMetricsSupervised.MetricBuilderSupervised<T> {
        public double[] _sefe;
        public double[] _sere;
        public double _varfix;
        public double[] _varranef;
        public boolean _converge;
        public double _dfrefe;
        public double[] _summvc1;
        public double[][] _summvc2;
        public double _hlik;
        public double _pvh;
        public double _pbvh;
        public double _caic;
        public long _bad;
        public double _sumetadiffsquare;
        public double _convergence;
        public double[] _fixef;
        public double[] _ranef;
        public int[] _randc;
        public int _iterations;
        public long _nobs;

        public MetricBuilderHGLM(String[] domain) {
            super(0, domain);
        }

        public void updateCoeffs(double[] fixedCoeffs, double[] randCoeffs) {
            int fixfLen = fixedCoeffs.length;
            if (this._fixef == null) {
                this._fixef = new double[fixfLen];
            }
            System.arraycopy(fixedCoeffs, 0, this._fixef, 0, fixfLen);
            int randLen = randCoeffs.length;
            if (this._ranef == null) {
                this._ranef = new double[randLen];
            }
            System.arraycopy(randCoeffs, 0, this._ranef, 0, randLen);
        }

        public void updateSummVC(double[] VC1, double[][] VC2, int[] randc) {
            if (this._summvc1 == null) {
                this._summvc1 = new double[2];
            }
            System.arraycopy(VC1, 0, this._summvc1, 0, 2);
            if (this._summvc2 == null) {
                this._randc = randc;
                this._summvc2 = new double[randc.length][2];
            }
            for (int index = 0; index < randc.length; ++index) {
                System.arraycopy(VC2[index], 0, this._summvc2[index], 0, 2);
            }
        }

        @Override
        public double[] perRow(double[] ds, float[] yact, Model m) {
            return new double[0];
        }

        @Override
        public ModelMetrics makeModelMetrics(Model m, Frame f, Frame adaptedFrame, Frame preds) {
            ModelMetricsHGLM mm = new ModelMetricsHGLM(m, f, this._nobs, 0.0, this._domain, 0.0, this._customMetric, this._sefe, this._sere, this._varfix, this._varranef, this._converge, this._dfrefe, this._summvc1, this._summvc2, this._hlik, this._pvh, this._pbvh, this._caic, this._bad, this._sumetadiffsquare, this._convergence, this._randc, this._fixef, this._ranef, this._iterations);
            if (m != null) {
                m.addModelMetrics(mm);
            }
            return mm;
        }
    }
}

