/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.FrameSplitter;
import hex.Transformer;
import water.Job;
import water.Key;
import water.Keyed;
import water.fvec.Frame;
import water.util.ArrayUtils;
import water.util.FrameUtils;

public class SplitFrame
extends Transformer<Frames> {
    public Frame _dataset;
    public double[] _ratios;
    public Key<Frame>[] _destination_frames;

    public SplitFrame(Frame dataset, double[] ratios, Key<Frame>[] destination_frames) {
        this();
        this._dataset = dataset;
        this._ratios = ratios;
        this._destination_frames = destination_frames;
    }

    public SplitFrame() {
        super(null, "hex.SplitFrame$Frames", "SplitFrame");
    }

    @Override
    public Job<Frames> execImpl() {
        double[] computedRatios;
        if (this._ratios.length < 0) {
            throw new IllegalArgumentException("No ratio specified!");
        }
        if (this._ratios.length > 100) {
            throw new IllegalArgumentException("Too many frame splits demanded!");
        }
        for (double r : this._ratios) {
            if (!(r <= 0.0)) continue;
            new IllegalArgumentException("Ratio must be > 0!");
        }
        if (this._ratios.length == 1 && (this._ratios[0] < 0.0 || this._ratios[0] > 1.0)) {
            throw new IllegalArgumentException("Ratio must be between 0 and 1!");
        }
        if (this._destination_frames != null && (this._ratios.length != 1 || this._destination_frames.length != 2) && this._ratios.length != this._destination_frames.length) {
            throw new IllegalArgumentException("Number of destination keys has to match to a number of split ratios!");
        }
        if (this._ratios.length > 1) {
            double sum = ArrayUtils.sum(this._ratios);
            if (sum <= 0.0) {
                throw new IllegalArgumentException("Ratios sum has to be > 0!");
            }
            if (sum < 1.0) {
                computedRatios = this._ratios;
            } else {
                computedRatios = new double[this._ratios.length - 1];
                for (int i = 0; i < this._ratios.length - 1; ++i) {
                    computedRatios[i] = this._ratios[i] / sum;
                }
            }
        } else {
            computedRatios = this._ratios;
        }
        if (this._destination_frames == null) {
            this._destination_frames = FrameUtils.generateNumKeys(this._dataset._key, computedRatios.length + 1);
        }
        FrameSplitter fs = new FrameSplitter(this._dataset, computedRatios, this._destination_frames, this._job._key);
        return this._job.start(fs, computedRatios.length + 1);
    }

    public static class Frames
    extends Keyed {
        public Key<Frame>[] _keys;
    }
}

