/*
 * Decompiled with CFR 0.152.
 */
package hex.coxph;

import hex.coxph.CoxPH;
import water.MrFun;

class EfronUpdateFun
extends MrFun<EfronUpdateFun> {
    transient CoxPH.CoxPHTask _coxMR;
    int _n_coef;
    double _logLik;
    double[] _gradient;
    double[][] _hessian;

    EfronUpdateFun(CoxPH.ComputationState cs, CoxPH.CoxPHTask coxMR) {
        this._coxMR = coxMR;
        this._n_coef = cs._n_coef;
        this._logLik = cs._logLik;
        this._gradient = cs._gradient;
        this._hessian = cs._hessian;
    }

    @Override
    protected void map(int t) {
        double sizeEvents_t = this._coxMR.sizeEvents[t];
        if (sizeEvents_t > 0.0) {
            long countEvents_t = this._coxMR.countEvents[t];
            double sumLogRiskEvents_t = this._coxMR.sumLogRiskEvents[t];
            double sumRiskEvents_t = this._coxMR.sumRiskEvents[t];
            double rcumsumRisk_t = this._coxMR.rcumsumRisk[t];
            double avgSize = sizeEvents_t / (double)countEvents_t;
            this._logLik += sumLogRiskEvents_t;
            for (long e = 0L; e < countEvents_t; ++e) {
                double frac = (double)e / (double)countEvents_t;
                double term = rcumsumRisk_t - frac * sumRiskEvents_t;
                this._logLik -= avgSize * Math.log(term);
                for (int j = 0; j < this._n_coef; ++j) {
                    double djTerm = this._coxMR.rcumsumXRisk[t][j] - frac * this._coxMR.sumXRiskEvents[t][j];
                    double djLogTerm = djTerm / term;
                    int n = j;
                    this._gradient[n] = this._gradient[n] - avgSize * djLogTerm;
                    int k = 0;
                    while (k < this._n_coef) {
                        double dkTerm = this._coxMR.rcumsumXRisk[t][k] - frac * this._coxMR.sumXRiskEvents[t][k];
                        double[] dArray = this._hessian[j];
                        int n2 = k++;
                        dArray[n2] = dArray[n2] + avgSize * (djLogTerm * (dkTerm / term));
                    }
                }
            }
        }
    }

    @Override
    protected void reduce(EfronUpdateFun o) {
        int i;
        this._logLik += o._logLik;
        for (i = 0; i < this._n_coef; ++i) {
            int n = i;
            this._gradient[n] = this._gradient[n] + o._gradient[i];
        }
        for (i = 0; i < this._n_coef; ++i) {
            for (int j = 0; j < this._n_coef; ++j) {
                double[] dArray = this._hessian[i];
                int n = j;
                dArray[n] = dArray[n] + o._hessian[i][j];
            }
        }
    }

    @Override
    protected MrFun<EfronUpdateFun> makeCopy() {
        return new EfronUpdateFun(new CoxPH.ComputationState(this._n_coef), this._coxMR);
    }

    CoxPH.ComputationState toComputationState(CoxPH.ComputationState cs) {
        cs._logLik = this._logLik;
        cs._gradient = this._gradient;
        cs._hessian = this._hessian;
        return cs;
    }
}

