/*
 * Decompiled with CFR 0.152.
 */
package hex.ensemble;

import hex.Distribution;
import hex.LinkFunction;
import hex.LinkFunctionFactory;
import hex.Model;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.ensemble.Metalearner;
import hex.ensemble.Metalearners;
import hex.ensemble.StackedEnsemble;
import hex.ensemble.StackedEnsembleMojoWriter;
import hex.genmodel.utils.DistributionFamily;
import hex.genmodel.utils.LinkFunctionType;
import hex.glm.GLMModel;
import hex.tree.drf.DRFModel;
import hex.util.DistributionUtils;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Stream;
import water.AutoBuffer;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Job;
import water.Key;
import water.Keyed;
import water.LocalMR;
import water.MRTask;
import water.MrFun;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.udf.CFuncRef;
import water.util.Log;
import water.util.MRUtils;
import water.util.ReflectionUtils;
import water.util.TwoDimTable;

public class StackedEnsembleModel
extends Model<StackedEnsembleModel, StackedEnsembleParameters, StackedEnsembleOutput> {
    public ModelCategory modelCategory;
    public long trainingFrameRows = -1L;
    public String responseColumn = null;

    public StackedEnsembleModel(Key selfKey, StackedEnsembleParameters parms, StackedEnsembleOutput output) {
        super(selfKey, parms, output);
    }

    @Override
    public void initActualParamValues() {
        super.initActualParamValues();
        if (((StackedEnsembleParameters)this._parms)._metalearner_fold_assignment == Model.Parameters.FoldAssignmentScheme.AUTO) {
            ((StackedEnsembleParameters)this._parms)._metalearner_fold_assignment = Model.Parameters.FoldAssignmentScheme.Random;
        }
    }

    @Override
    public boolean haveMojo() {
        return super.haveMojo() && Stream.of(((StackedEnsembleParameters)this._parms)._base_models).filter(this::isUsefulBaseModel).map(DKV::getGet).allMatch(Model::haveMojo);
    }

    @Override
    protected Model.PredictScoreResult predictScoreImpl(final Frame fr, Frame adaptFrm, String destination_key, final Job j, boolean computeMetrics, CFuncRef customMetricFunc) {
        StackedEnsembleParameters.MetalearnerTransform transform;
        if (((StackedEnsembleParameters)this._parms)._metalearner_transform != null && ((StackedEnsembleParameters)this._parms)._metalearner_transform != StackedEnsembleParameters.MetalearnerTransform.NONE) {
            if (!((StackedEnsembleOutput)this._output).isBinomialClassifier() && !((StackedEnsembleOutput)this._output).isMultinomialClassifier()) {
                throw new H2OIllegalArgumentException("Metalearner transform is supported only for classification!");
            }
            transform = ((StackedEnsembleParameters)this._parms)._metalearner_transform;
        } else {
            transform = null;
        }
        final String seKey = this._key.toString();
        Key<Frame> levelOneFrameKey = Key.make("preds_levelone_" + seKey + fr._key);
        Frame levelOneFrame = transform == null ? new Frame(levelOneFrameKey) : new Frame(new Vec[0]);
        final Model[] usefulBaseModels = (Model[])Stream.of(((StackedEnsembleParameters)this._parms)._base_models).filter(this::isUsefulBaseModel).map(Key::get).toArray(Model[]::new);
        if (usefulBaseModels.length > 0) {
            final Frame[] baseModelPredictions = new Frame[usefulBaseModels.length];
            H2O.submitTask(new LocalMR(new MrFun(){

                @Override
                protected void map(int id) {
                    baseModelPredictions[id] = usefulBaseModels[id].score(fr, "preds_base_" + seKey + usefulBaseModels[id]._key + fr._key, j, false);
                }
            }, usefulBaseModels.length)).join();
            for (int i = 0; i < usefulBaseModels.length; ++i) {
                StackedEnsemble.addModelPredictionsToLevelOneFrame(usefulBaseModels[i], baseModelPredictions[i], levelOneFrame);
                DKV.remove(baseModelPredictions[i]._key);
                Frame.deleteTempFrameAndItsNonSharedVecs(baseModelPredictions[i], levelOneFrame);
            }
        }
        if (transform != null) {
            Frame oldLOF = levelOneFrame;
            levelOneFrame = transform.transform(this, levelOneFrame, levelOneFrameKey);
            oldLOF.remove();
        }
        StackedEnsemble.addNonPredictorsToLevelOneFrame((StackedEnsembleParameters)this._parms, adaptFrm, levelOneFrame, false);
        Log.info("Finished creating \"level one\" frame for scoring: " + levelOneFrame.toString());
        Model metalearner = ((StackedEnsembleOutput)this._output)._metalearner;
        Frame predictFr = metalearner.score(levelOneFrame, destination_key, j, computeMetrics, CFuncRef.from(((StackedEnsembleParameters)this._parms)._custom_metric_func));
        ModelMetrics mmStackedEnsemble = null;
        if (computeMetrics) {
            Key<ModelMetrics>[] mms = ((Model.Output)metalearner._output).getModelMetrics();
            ModelMetrics lastComputedMetric = mms[mms.length - 1].get();
            mmStackedEnsemble = lastComputedMetric.deepCloneWithDifferentModelAndFrame(this, fr);
            this.addModelMetrics(mmStackedEnsemble);
            for (Key<ModelMetrics> mm : ((Model.Output)metalearner._output).clearModelMetrics(true)) {
                DKV.remove(mm);
            }
        }
        Frame.deleteTempFrameAndItsNonSharedVecs(levelOneFrame, adaptFrm);
        return new StackedEnsemblePredictScoreResult(predictFr, mmStackedEnsemble);
    }

    boolean isUsefulBaseModel(Key<Model> baseModelKey) {
        Model metalearner = ((StackedEnsembleOutput)this._output)._metalearner;
        assert (metalearner != null) : "can't use isUsefulBaseModel during training";
        if (this.modelCategory == ModelCategory.Multinomial) {
            for (String feature : ((Model.Output)metalearner._output)._names) {
                if (!feature.startsWith(baseModelKey.toString().concat("/")) || !metalearner.isFeatureUsedInPredict(feature)) continue;
                return true;
            }
            return false;
        }
        return metalearner.isFeatureUsedInPredict(baseModelKey.toString());
    }

    @Override
    protected double[] score0(double[] data, double[] preds) {
        throw new UnsupportedOperationException("StackedEnsembleModel.score0() should never be called: the code paths that normally go here should call predictScoreImpl().");
    }

    @Override
    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        throw new UnsupportedOperationException("StackedEnsembleModel.makeMetricBuilder should never be called!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelMetrics doScoreTrainingMetrics(Frame frame, Job job) {
        Frame scoredFrame = ((StackedEnsembleParameters)this._parms)._score_training_samples > 0L && ((StackedEnsembleParameters)this._parms)._score_training_samples < frame.numRows() ? MRUtils.sampleFrame(frame, ((StackedEnsembleParameters)this._parms)._score_training_samples, ((StackedEnsembleParameters)this._parms)._seed) : frame;
        try {
            Frame adaptedFrame = new Frame(scoredFrame);
            Model.PredictScoreResult result = this.predictScoreImpl(scoredFrame, adaptedFrame, null, job, true, CFuncRef.from(((StackedEnsembleParameters)this._parms)._custom_metric_func));
            result.getPredictions().delete();
            ModelMetrics modelMetrics = result.makeModelMetrics(scoredFrame, adaptedFrame);
            return modelMetrics;
        }
        finally {
            if (scoredFrame != frame) {
                scoredFrame.delete();
            }
        }
    }

    void doScoreOrCopyMetrics(Job job) {
        ((StackedEnsembleOutput)this._output)._training_metrics = this.doScoreTrainingMetrics(((StackedEnsembleParameters)this._parms).train(), null);
        ((StackedEnsembleOutput)this._output)._validation_metrics = ((Model.Output)((StackedEnsembleOutput)this._output)._metalearner._output)._validation_metrics;
        if (null != ((Model.Output)((StackedEnsembleOutput)this._output)._metalearner._output)._cross_validation_metrics) {
            ((StackedEnsembleOutput)this._output)._cross_validation_metrics = ((Model.Output)((StackedEnsembleOutput)this._output)._metalearner._output)._cross_validation_metrics.deepCloneWithDifferentModelAndFrame(this, ((Model.Parameters)((StackedEnsembleOutput)this._output)._metalearner._parms).train());
            ((StackedEnsembleOutput)this._output)._cross_validation_metrics_summary = (TwoDimTable)((Model.Output)((StackedEnsembleOutput)this._output)._metalearner._output)._cross_validation_metrics_summary.clone();
        }
    }

    private DistributionFamily distributionFamily(Model aModel) {
        if (aModel instanceof DRFModel) {
            if (((Model.Output)aModel._output).isBinomialClassifier()) {
                return DistributionFamily.bernoulli;
            }
            if (((Model.Output)aModel._output).isClassifier()) {
                return DistributionFamily.multinomial;
            }
            return DistributionFamily.gaussian;
        }
        if (aModel instanceof StackedEnsembleModel) {
            StackedEnsembleModel seModel = (StackedEnsembleModel)aModel;
            if (Metalearners.getActualMetalearnerAlgo(((StackedEnsembleParameters)seModel._parms)._metalearner_algorithm) == Metalearner.Algorithm.glm) {
                return DistributionUtils.familyToDistribution(((GLMModel.GLMParameters)((StackedEnsembleParameters)seModel._parms)._metalearner_parameters)._family);
            }
            if (((StackedEnsembleParameters)seModel._parms)._metalearner_parameters._distribution != DistributionFamily.AUTO) {
                return ((StackedEnsembleParameters)seModel._parms)._metalearner_parameters._distribution;
            }
        }
        try {
            Field distributionField;
            Field familyField = ReflectionUtils.findNamedField(aModel._parms, "_family");
            Field field = distributionField = familyField != null ? null : ReflectionUtils.findNamedField(aModel, "_dist");
            if (null != familyField) {
                GLMModel.GLMParameters.Family thisFamily = (GLMModel.GLMParameters.Family)((Object)familyField.get(aModel._parms));
                return DistributionUtils.familyToDistribution(thisFamily);
            }
            if (null != distributionField) {
                Distribution distribution = (Distribution)distributionField.get(aModel);
                DistributionFamily distributionFamily = null != distribution ? distribution._family : ((Model.Parameters)aModel._parms)._distribution;
                if (distributionFamily == DistributionFamily.AUTO) {
                    distributionFamily = ((Model.Output)aModel._output).isBinomialClassifier() ? DistributionFamily.bernoulli : (((Model.Output)aModel._output).isClassifier() ? DistributionFamily.multinomial : DistributionFamily.gaussian);
                }
                return distributionFamily;
            }
            throw new H2OIllegalArgumentException("Don't know how to stack models that have neither a distribution hyperparameter nor a family hyperparameter.");
        }
        catch (Exception e) {
            throw new H2OIllegalArgumentException(e.toString(), e.toString());
        }
    }

    private void inheritDistributionAndParms(Model.Parameters baseModelParms) {
        if (baseModelParms instanceof GLMModel.GLMParameters) {
            try {
                ((StackedEnsembleParameters)this._parms)._metalearner_parameters.setDistributionFamily(DistributionUtils.familyToDistribution(((GLMModel.GLMParameters)baseModelParms)._family));
            }
            catch (IllegalArgumentException e) {
                Log.warn("Stacked Ensemble is not able to inherit distribution from GLM's family " + (Object)((Object)((GLMModel.GLMParameters)baseModelParms)._family) + ".");
            }
        } else if (baseModelParms instanceof DRFModel.DRFParameters) {
            this.inferBasicDistribution();
        } else {
            ((StackedEnsembleParameters)this._parms)._metalearner_parameters.setDistributionFamily(baseModelParms._distribution);
        }
        switch (baseModelParms._distribution) {
            case custom: {
                ((StackedEnsembleParameters)this._parms)._metalearner_parameters._custom_distribution_func = baseModelParms._custom_distribution_func;
                break;
            }
            case huber: {
                ((StackedEnsembleParameters)this._parms)._metalearner_parameters._huber_alpha = baseModelParms._huber_alpha;
                break;
            }
            case tweedie: {
                ((StackedEnsembleParameters)this._parms)._metalearner_parameters._tweedie_power = baseModelParms._tweedie_power;
                break;
            }
            case quantile: {
                ((StackedEnsembleParameters)this._parms)._metalearner_parameters._quantile_alpha = baseModelParms._quantile_alpha;
            }
        }
    }

    private void inheritFamilyAndParms(Model.Parameters baseModelParms) {
        GLMModel.GLMParameters metaParams = (GLMModel.GLMParameters)((StackedEnsembleParameters)this._parms)._metalearner_parameters;
        if (baseModelParms instanceof GLMModel.GLMParameters) {
            GLMModel.GLMParameters glmParams = (GLMModel.GLMParameters)baseModelParms;
            metaParams._family = glmParams._family;
            metaParams._link = glmParams._link;
        } else if (baseModelParms instanceof DRFModel.DRFParameters) {
            this.inferBasicDistribution();
        } else {
            try {
                metaParams.setDistributionFamily(baseModelParms._distribution);
            }
            catch (H2OIllegalArgumentException e) {
                Log.warn("Stacked Ensemble is not able to inherit family from a distribution " + (Object)((Object)baseModelParms._distribution) + ".");
                this.inferBasicDistribution();
            }
        }
        if (metaParams._family == GLMModel.GLMParameters.Family.tweedie) {
            ((StackedEnsembleParameters)this._parms)._metalearner_parameters._tweedie_power = baseModelParms._tweedie_power;
        }
    }

    boolean inferDistributionOrFamily(Model aModel) {
        if (Metalearners.getActualMetalearnerAlgo(((StackedEnsembleParameters)this._parms)._metalearner_algorithm) == Metalearner.Algorithm.glm) {
            if (((GLMModel.GLMParameters)((StackedEnsembleParameters)this._parms)._metalearner_parameters)._family != GLMModel.GLMParameters.Family.AUTO) {
                return false;
            }
            this.inheritFamilyAndParms((Model.Parameters)aModel._parms);
        } else {
            if (((StackedEnsembleParameters)this._parms)._metalearner_parameters._distribution != DistributionFamily.AUTO) {
                return false;
            }
            this.inheritDistributionAndParms((Model.Parameters)aModel._parms);
        }
        return true;
    }

    void inferBasicDistribution() {
        if (((StackedEnsembleOutput)this._output).isBinomialClassifier()) {
            ((StackedEnsembleParameters)this._parms)._metalearner_parameters.setDistributionFamily(DistributionFamily.bernoulli);
        } else if (((StackedEnsembleOutput)this._output).isClassifier()) {
            ((StackedEnsembleParameters)this._parms)._metalearner_parameters.setDistributionFamily(DistributionFamily.multinomial);
        } else {
            ((StackedEnsembleParameters)this._parms)._metalearner_parameters.setDistributionFamily(DistributionFamily.gaussian);
        }
    }

    void checkAndInheritModelProperties() {
        if (null == ((StackedEnsembleParameters)this._parms)._base_models || 0 == ((StackedEnsembleParameters)this._parms)._base_models.length) {
            throw new H2OIllegalArgumentException("When creating a StackedEnsemble you must specify one or more models; found 0.");
        }
        if (null != ((StackedEnsembleParameters)this._parms)._metalearner_fold_column && 0 != ((StackedEnsembleParameters)this._parms)._metalearner_nfolds) {
            throw new H2OIllegalArgumentException("Cannot specify fold_column and nfolds at the same time.");
        }
        Model aModel = null;
        boolean retrievedFirstModelParams = false;
        boolean inferredDistributionFromFirstModel = false;
        GLMModel firstGLM = null;
        boolean blending_mode = ((StackedEnsembleParameters)this._parms)._blending != null;
        boolean cv_required_on_base_model = !blending_mode;
        boolean require_consistent_training_frames = !blending_mode && !((StackedEnsembleParameters)this._parms)._is_cv_model;
        int basemodel_nfolds = -1;
        Model.Parameters.FoldAssignmentScheme basemodel_fold_assignment = null;
        String basemodel_fold_column = null;
        long seed = -1L;
        if (((StackedEnsembleParameters)this._parms)._metalearner_parameters == null) {
            ((StackedEnsembleParameters)this._parms).initMetalearnerParams();
        }
        for (Key<Model> k : ((StackedEnsembleParameters)this._parms)._base_models) {
            aModel = (Model)DKV.getGet(k);
            if (null == aModel) {
                Log.warn("Failed to find base model; skipping: " + k);
                continue;
            }
            Log.debug("Checking properties for model " + k);
            if (!aModel.isSupervised()) {
                throw new H2OIllegalArgumentException("Base model is not supervised: " + aModel._key.toString());
            }
            if (retrievedFirstModelParams) {
                if (this.modelCategory != ((Model.Output)aModel._output).getModelCategory()) {
                    throw new H2OIllegalArgumentException("Base models are inconsistent: there is a mix of different categories of models among " + Arrays.toString(((StackedEnsembleParameters)this._parms)._base_models));
                }
                if (!this.responseColumn.equals(((Model.Parameters)aModel._parms)._response_column)) {
                    throw new H2OIllegalArgumentException("Base models are inconsistent: they use different response columns. Found: " + this.responseColumn + " (StackedEnsemble) and " + ((Model.Parameters)aModel._parms)._response_column + " (model " + k + ").");
                }
                if (require_consistent_training_frames) {
                    long numOfRowsUsedToTrain;
                    if (this.trainingFrameRows < 0L) {
                        this.trainingFrameRows = ((StackedEnsembleParameters)this._parms).train().numRows();
                    }
                    long l = numOfRowsUsedToTrain = ((Model.Parameters)aModel._parms).train() == null ? ((Model.Output)aModel._output)._cross_validation_holdout_predictions_frame_id.get().numRows() : ((Model.Parameters)aModel._parms).train().numRows();
                    if (this.trainingFrameRows != numOfRowsUsedToTrain) {
                        throw new H2OIllegalArgumentException("Base models are inconsistent: they use different size (number of rows) training frames. Found: " + this.trainingFrameRows + " (StackedEnsemble) and " + numOfRowsUsedToTrain + " (model " + k + ").");
                    }
                }
                if (cv_required_on_base_model) {
                    if (((Model.Parameters)aModel._parms)._fold_assignment != basemodel_fold_assignment && (((Model.Parameters)aModel._parms)._fold_assignment != Model.Parameters.FoldAssignmentScheme.AUTO || basemodel_fold_assignment != Model.Parameters.FoldAssignmentScheme.Random)) {
                        throw new H2OIllegalArgumentException("Base models are inconsistent: they use different fold_assignments.");
                    }
                    if (((Model.Parameters)aModel._parms)._fold_column == null) {
                        if (((Model.Parameters)aModel._parms)._nfolds < 2) {
                            throw new H2OIllegalArgumentException("Base model does not use cross-validation: " + ((Model.Parameters)aModel._parms)._nfolds);
                        }
                        if (basemodel_nfolds != ((Model.Parameters)aModel._parms)._nfolds) {
                            throw new H2OIllegalArgumentException("Base models are inconsistent: they use different values for nfolds.");
                        }
                        if (basemodel_fold_assignment == Model.Parameters.FoldAssignmentScheme.Random && ((Model.Parameters)aModel._parms)._seed != seed) {
                            throw new H2OIllegalArgumentException("Base models are inconsistent: they use random-seeded k-fold cross-validation but have different seeds.");
                        }
                    } else if (!((Model.Parameters)aModel._parms)._fold_column.equals(basemodel_fold_column)) {
                        throw new H2OIllegalArgumentException("Base models are inconsistent: they use different fold_columns.");
                    }
                    if (!((Model.Parameters)aModel._parms)._keep_cross_validation_predictions) {
                        throw new H2OIllegalArgumentException("Base model does not keep cross-validation predictions: " + ((Model.Parameters)aModel._parms)._nfolds);
                    }
                }
                if (!inferredDistributionFromFirstModel) continue;
                if (!(aModel instanceof DRFModel) && this.distributionFamily(aModel) == this.distributionFamily(this)) {
                    boolean sameParams = true;
                    switch (((StackedEnsembleParameters)this._parms)._metalearner_parameters._distribution) {
                        case custom: {
                            sameParams = ((StackedEnsembleParameters)this._parms)._metalearner_parameters._custom_distribution_func.equals(((Model.Parameters)aModel._parms)._custom_distribution_func);
                            break;
                        }
                        case huber: {
                            sameParams = ((StackedEnsembleParameters)this._parms)._metalearner_parameters._huber_alpha == ((Model.Parameters)aModel._parms)._huber_alpha;
                            break;
                        }
                        case tweedie: {
                            sameParams = ((StackedEnsembleParameters)this._parms)._metalearner_parameters._tweedie_power == ((Model.Parameters)aModel._parms)._tweedie_power;
                            break;
                        }
                        case quantile: {
                            boolean bl = sameParams = ((StackedEnsembleParameters)this._parms)._metalearner_parameters._quantile_alpha == ((Model.Parameters)aModel._parms)._quantile_alpha;
                        }
                    }
                    if (aModel instanceof GLMModel && Metalearners.getActualMetalearnerAlgo(((StackedEnsembleParameters)this._parms)._metalearner_algorithm) == Metalearner.Algorithm.glm) {
                        if (firstGLM == null) {
                            firstGLM = (GLMModel)aModel;
                            this.inheritFamilyAndParms(firstGLM._parms);
                        } else {
                            sameParams = ((GLMModel.GLMParameters)((StackedEnsembleParameters)this._parms)._metalearner_parameters)._link.equals((Object)((GLMModel.GLMParameters)((GLMModel)aModel)._parms)._link);
                        }
                    }
                    if (sameParams) continue;
                    Log.warn("Base models are inconsistent; they use same distribution but different parameters of the distribution. Reverting to default distribution.");
                    this.inferBasicDistribution();
                    inferredDistributionFromFirstModel = false;
                    continue;
                }
                if (this.distributionFamily(aModel) != this.distributionFamily(this)) {
                    Log.warn("Base models are inconsistent; they use different distributions: " + (Object)((Object)this.distributionFamily(this)) + " and: " + (Object)((Object)this.distributionFamily(aModel)) + ". Reverting to default distribution.");
                }
                this.inferBasicDistribution();
                inferredDistributionFromFirstModel = false;
                continue;
            }
            this.modelCategory = ((Model.Output)aModel._output).getModelCategory();
            inferredDistributionFromFirstModel = this.inferDistributionOrFamily(aModel);
            firstGLM = aModel instanceof GLMModel && inferredDistributionFromFirstModel ? (GLMModel)aModel : null;
            this.responseColumn = ((Model.Parameters)aModel._parms)._response_column;
            if (!((StackedEnsembleParameters)this._parms)._response_column.equals(this.responseColumn)) {
                throw new H2OIllegalArgumentException("StackedModel response_column must match the response_column of each base model. Found: " + ((StackedEnsembleParameters)this._parms)._response_column + "(StackedEnsemble) and: " + this.responseColumn + " (model " + k + ").");
            }
            basemodel_nfolds = ((Model.Parameters)aModel._parms)._nfolds;
            basemodel_fold_assignment = ((Model.Parameters)aModel._parms)._fold_assignment;
            if (basemodel_fold_assignment == Model.Parameters.FoldAssignmentScheme.AUTO) {
                basemodel_fold_assignment = Model.Parameters.FoldAssignmentScheme.Random;
            }
            basemodel_fold_column = ((Model.Parameters)aModel._parms)._fold_column;
            seed = ((Model.Parameters)aModel._parms)._seed;
            retrievedFirstModelParams = true;
        }
        if (null == aModel) {
            throw new H2OIllegalArgumentException("When creating a StackedEnsemble you must specify one or more models; " + ((StackedEnsembleParameters)this._parms)._base_models.length + " were specified but none of those were found: " + Arrays.toString(((StackedEnsembleParameters)this._parms)._base_models));
        }
    }

    public void deleteBaseModelPredictions() {
        if (((StackedEnsembleOutput)this._output)._base_model_predictions_keys != null) {
            for (Key<Frame> key : ((StackedEnsembleOutput)this._output)._base_model_predictions_keys) {
                if (((StackedEnsembleOutput)this._output)._levelone_frame_id != null && key.get() != null) {
                    Frame.deleteTempFrameAndItsNonSharedVecs(key.get(), ((StackedEnsembleOutput)this._output)._levelone_frame_id);
                    continue;
                }
                Keyed.remove(key);
            }
            ((StackedEnsembleOutput)this._output)._base_model_predictions_keys = null;
        }
    }

    @Override
    protected Futures remove_impl(Futures fs, boolean cascade) {
        this.deleteBaseModelPredictions();
        if (((StackedEnsembleOutput)this._output)._metalearner != null) {
            ((StackedEnsembleOutput)this._output)._metalearner.remove(fs);
        }
        if (((StackedEnsembleOutput)this._output)._levelone_frame_id != null) {
            ((StackedEnsembleOutput)this._output)._levelone_frame_id.remove(fs);
        }
        return super.remove_impl(fs, cascade);
    }

    @Override
    protected AutoBuffer writeAll_impl(AutoBuffer ab) {
        ab.putKey(((StackedEnsembleOutput)this._output)._metalearner._key);
        for (Key<Model> ks : ((StackedEnsembleParameters)this._parms)._base_models) {
            ab.putKey(ks);
        }
        return super.writeAll_impl(ab);
    }

    @Override
    protected Keyed readAll_impl(AutoBuffer ab, Futures fs) {
        ab.getKey(((StackedEnsembleOutput)this._output)._metalearner._key, fs);
        for (Key<Model> ks : ((StackedEnsembleParameters)this._parms)._base_models) {
            ab.getKey(ks, fs);
        }
        return super.readAll_impl(ab, fs);
    }

    @Override
    public StackedEnsembleMojoWriter getMojo() {
        return new StackedEnsembleMojoWriter(this);
    }

    @Override
    public void deleteCrossValidationModels() {
        if (((StackedEnsembleOutput)this._output)._metalearner != null) {
            ((StackedEnsembleOutput)this._output)._metalearner.deleteCrossValidationModels();
        }
    }

    @Override
    public void deleteCrossValidationPreds() {
        if (((StackedEnsembleOutput)this._output)._metalearner != null) {
            ((StackedEnsembleOutput)this._output)._metalearner.deleteCrossValidationPreds();
        }
    }

    @Override
    public void deleteCrossValidationFoldAssignment() {
        if (((StackedEnsembleOutput)this._output)._metalearner != null) {
            ((StackedEnsembleOutput)this._output)._metalearner.deleteCrossValidationFoldAssignment();
        }
    }

    private class StackedEnsemblePredictScoreResult
    extends Model.PredictScoreResult {
        private final ModelMetrics _modelMetrics;

        public StackedEnsemblePredictScoreResult(Frame preds, ModelMetrics modelMetrics) {
            super(StackedEnsembleModel.this, null, preds, preds);
            this._modelMetrics = modelMetrics;
        }

        @Override
        public ModelMetrics makeModelMetrics(Frame fr, Frame adaptFrm) {
            return this._modelMetrics;
        }

        @Override
        public ModelMetrics.MetricBuilder<?> getMetricBuilder() {
            throw new UnsupportedOperationException("Stacked Ensemble model doesn't implement MetricBuilder infrastructure code, retrieve your metrics by calling getOrMakeMetrics method.");
        }
    }

    public static class StackedEnsembleOutput
    extends Model.Output {
        public Model _metalearner;
        public Frame _levelone_frame_id;
        public StackingStrategy _stacking_strategy;
        public Key<Frame>[] _base_model_predictions_keys;

        public StackedEnsembleOutput() {
        }

        public StackedEnsembleOutput(StackedEnsemble b) {
            super(b);
        }

        public StackedEnsembleOutput(Job job) {
            this._job = job;
        }

        @Override
        public int nfeatures() {
            return super.nfeatures() - (((Model.Parameters)this._metalearner._parms)._fold_column == null ? 0 : 1);
        }
    }

    public static class StackedEnsembleParameters
    extends Model.Parameters {
        public Key<Model>[] _base_models = new Key[0];
        public boolean _keep_levelone_frame = false;
        public boolean _keep_base_model_predictions = false;
        public int _metalearner_nfolds;
        public Model.Parameters.FoldAssignmentScheme _metalearner_fold_assignment;
        public String _metalearner_fold_column;
        public Key<Frame> _blending;
        public MetalearnerTransform _metalearner_transform = MetalearnerTransform.NONE;
        public Metalearner.Algorithm _metalearner_algorithm = Metalearner.Algorithm.AUTO;
        public String _metalearner_params = new String();
        public Model.Parameters _metalearner_parameters;
        public long _score_training_samples = 10000L;

        @Override
        public String algoName() {
            return "StackedEnsemble";
        }

        @Override
        public String fullName() {
            return "Stacked Ensemble";
        }

        @Override
        public String javaName() {
            return StackedEnsembleModel.class.getName();
        }

        @Override
        public long progressUnits() {
            return 1L;
        }

        public void initMetalearnerParams() {
            this.initMetalearnerParams(this._metalearner_algorithm);
        }

        public void initMetalearnerParams(Metalearner.Algorithm algo) {
            this._metalearner_algorithm = algo;
            this._metalearner_parameters = Metalearners.createParameters(algo.name());
        }

        public final Frame blending() {
            return this._blending == null ? null : this._blending.get();
        }

        @Override
        public String[] getNonPredictors() {
            HashSet<String> nonPredictors = new HashSet<String>();
            nonPredictors.addAll(Arrays.asList(super.getNonPredictors()));
            if (null != this._metalearner_fold_column) {
                nonPredictors.add(this._metalearner_fold_column);
            }
            return nonPredictors.toArray(new String[0]);
        }

        @Override
        public DistributionFamily getDistributionFamily() {
            if (this._metalearner_parameters != null) {
                return this._metalearner_parameters.getDistributionFamily();
            }
            return super.getDistributionFamily();
        }

        @Override
        public void setDistributionFamily(DistributionFamily distributionFamily) {
            assert (this._metalearner_parameters != null);
            this._metalearner_parameters.setDistributionFamily(distributionFamily);
        }

        public static enum MetalearnerTransform {
            NONE,
            Logit;


            public Frame transform(StackedEnsembleModel model, Frame frame, Key<Frame> destKey) {
                if (this == Logit) {
                    return ((MRTask)new MRTask(){

                        @Override
                        public void map(Chunk[] cs, NewChunk[] ncs) {
                            LinkFunction logitLink = LinkFunctionFactory.getLinkFunction(LinkFunctionType.logit);
                            for (int c = 0; c < cs.length; ++c) {
                                for (int i = 0; i < cs[c]._len; ++i) {
                                    double p = Math.min(0.999999999, Math.max(cs[c].atd(i), 1.0E-9));
                                    ncs[c].addNum(logitLink.link(p));
                                }
                            }
                        }
                    }.doAll(frame.numCols(), (byte)3, frame)).outputFrame(destKey, frame._names, null);
                }
                throw new RuntimeException();
            }
        }
    }

    public static enum StackingStrategy {
        cross_validation,
        blending;

    }
}

