/*
 * Decompiled with CFR 0.152.
 */
package hex.gam.GamSplines;

import java.util.ArrayList;
import java.util.stream.IntStream;
import water.util.ArrayUtils;

public class NBSplinesUtils {
    public static double[] polynomialProduct(double[] coeff1, double[] coeff2) {
        int firstLen = coeff1.length;
        int secondLen = coeff2.length;
        int combinedLen = firstLen * secondLen;
        int[] firstOrder = IntStream.rangeClosed(0, firstLen - 1).toArray();
        int[] secondOrder = IntStream.rangeClosed(0, secondLen - 1).toArray();
        int highestOrder = firstLen + secondLen - 2;
        double[] combinedCoefficients = new double[highestOrder + 1];
        ArrayList<Double> combinedC = new ArrayList<Double>();
        ArrayList<Integer> combinedOrder = new ArrayList<Integer>();
        for (int firstIndex = 0; firstIndex < firstLen; ++firstIndex) {
            for (int secondIndex = 0; secondIndex < secondLen; ++secondIndex) {
                double tempValue = coeff1[firstIndex] * coeff2[secondIndex];
                combinedC.add(tempValue);
                int tempOrder = firstOrder[firstIndex] + secondOrder[secondIndex];
                combinedOrder.add(tempOrder);
            }
        }
        for (int index = 0; index < combinedLen; ++index) {
            int n = (Integer)combinedOrder.get(index);
            combinedCoefficients[n] = combinedCoefficients[n] + (Double)combinedC.get(index);
        }
        return combinedCoefficients;
    }

    public static void combineParentCoef(double[] parentCoeff, double parentConst, double[][] currCoeff) {
        int numBasis = currCoeff.length;
        double[] copyParentCoef = (double[])parentCoeff.clone();
        ArrayUtils.mult(copyParentCoef, parentConst);
        for (int index = 0; index < numBasis; ++index) {
            if (currCoeff[index] == null) continue;
            currCoeff[index] = NBSplinesUtils.polynomialProduct(copyParentCoef, currCoeff[index]);
        }
    }

    public static void sumCoeffs(double[][] leftCoeffs, double[][] riteCoeffs, double[][] currCoeffs) {
        int knotInt = leftCoeffs.length;
        for (int index = 0; index < knotInt; ++index) {
            double[] leftCoef1 = leftCoeffs[index];
            double[] riteCoef1 = riteCoeffs[index];
            if (leftCoef1 == null && riteCoef1 == null) continue;
            currCoeffs[index] = leftCoef1 != null && riteCoef1 != null ? NBSplinesUtils.addCoeffs(leftCoef1, riteCoef1) : (leftCoef1 != null ? (double[])leftCoef1.clone() : (double[])riteCoef1.clone());
        }
    }

    public static double[] addCoeffs(double[] leftCoef, double[] riteCoef) {
        int leftLen = leftCoef.length;
        int riteLen = riteCoef.length;
        int coeffLen = Math.max(leftLen, riteLen);
        double[] sumCoeffs = new double[coeffLen];
        for (int index = 0; index < coeffLen; ++index) {
            double val = 0.0;
            if (index < leftLen) {
                val += leftCoef[index];
            }
            if (index < riteLen) {
                val += riteCoef[index];
            }
            sumCoeffs[index] = val;
        }
        return sumCoeffs;
    }

    public static double integratePolynomial(double[] knotsWithDuplicates, double[][] coeffProduct) {
        double sumValue = 0.0;
        int numBasis = coeffProduct.length;
        for (int index = 0; index < numBasis; ++index) {
            if (coeffProduct[index] == null) continue;
            int orderSize = coeffProduct[index].length;
            double firstKnot = knotsWithDuplicates[index];
            double secondKnot = knotsWithDuplicates[index + 1];
            double[] coeffs = coeffProduct[index];
            double tempSum = 0.0;
            for (int orderIndex = 0; orderIndex < orderSize; ++orderIndex) {
                tempSum += coeffs[orderIndex] / (double)(orderIndex + 1) * (Math.pow(secondKnot, orderIndex + 1) - Math.pow(firstKnot, orderIndex + 1));
            }
            sumValue += tempSum;
        }
        return sumValue;
    }
}

