/*
 * Decompiled with CFR 0.152.
 */
package hex.gam.MatrixFrameUtils;

import hex.ModelMetrics;
import hex.VarImp;
import hex.gam.GAMModel;
import hex.glm.GLMModel;
import water.util.ArrayUtils;
import water.util.Log;
import water.util.TwoDimTable;

public class GAMModelUtils {
    public static void copyGLMCoeffs(GLMModel glm, GAMModel model, GAMModel.GAMParameters parms, int nclass) {
        boolean multiClass = parms._family == GLMModel.GLMParameters.Family.multinomial || parms._family == GLMModel.GLMParameters.Family.ordinal;
        int totCoefNumsNoCenter = (multiClass ? glm.coefficients().size() / nclass : glm.coefficients().size()) + GAMModelUtils.gamNoCenterCoeffLength(parms);
        ((GAMModel.GAMModelOutput)model._output)._coefficient_names_no_centering = new String[totCoefNumsNoCenter];
        int gamNumStart = GAMModelUtils.copyGLMCoeffNames2GAMCoeffNames(model, glm);
        GAMModelUtils.copyGLMCoeffs2GAMCoeffs(model, glm, parms._family, gamNumStart, nclass);
        int glmCoeffLen = ((GLMModel.GLMOutput)glm._output)._coefficient_names.length;
        ((GAMModel.GAMModelOutput)model._output)._coefficient_names = new String[glmCoeffLen];
        System.arraycopy(((GLMModel.GLMOutput)glm._output)._coefficient_names, 0, ((GAMModel.GAMModelOutput)model._output)._coefficient_names, 0, glmCoeffLen);
        if (multiClass) {
            double[][] model_beta_multinomial = ((GLMModel.GLMOutput)glm._output).get_global_beta_multinomial();
            double[][] standardized_model_beta_multinomial = ((GLMModel.GLMOutput)glm._output).getNormBetaMultinomial();
            ((GAMModel.GAMModelOutput)model._output)._model_beta_multinomial = new double[nclass][glmCoeffLen];
            ((GAMModel.GAMModelOutput)model._output)._standardized_model_beta_multinomial = new double[nclass][glmCoeffLen];
            for (int classInd = 0; classInd < nclass; ++classInd) {
                System.arraycopy(model_beta_multinomial[classInd], 0, ((GAMModel.GAMModelOutput)model._output)._model_beta_multinomial[classInd], 0, glmCoeffLen);
                System.arraycopy(standardized_model_beta_multinomial[classInd], 0, ((GAMModel.GAMModelOutput)model._output)._standardized_model_beta_multinomial[classInd], 0, glmCoeffLen);
            }
        } else {
            ((GAMModel.GAMModelOutput)model._output)._model_beta = new double[glmCoeffLen];
            ((GAMModel.GAMModelOutput)model._output)._standardized_model_beta = new double[glmCoeffLen];
            System.arraycopy(((GLMModel.GLMOutput)glm._output).beta(), 0, ((GAMModel.GAMModelOutput)model._output)._model_beta, 0, glmCoeffLen);
            System.arraycopy(((GLMModel.GLMOutput)glm._output).getNormBeta(), 0, ((GAMModel.GAMModelOutput)model._output)._standardized_model_beta, 0, glmCoeffLen);
        }
    }

    public static int gamNoCenterCoeffLength(GAMModel.GAMParameters parms) {
        int tpCount = 0;
        int numGam = parms._gam_columns.length;
        int gamifiedColCount = 0;
        for (int index = 0; index < numGam; ++index) {
            if (parms._bs_sorted[index] == 0 || parms._bs_sorted[index] == 2) {
                ++gamifiedColCount;
                continue;
            }
            gamifiedColCount += 1 + parms._M[tpCount++];
        }
        return gamifiedColCount;
    }

    public static void copyGLMtoGAMModel(GAMModel model, GLMModel glmModel, GAMModel.GAMParameters parms, boolean validNotNull) {
        ((GAMModel.GAMModelOutput)model._output)._glm_best_lamda_value = ((GLMModel.GLMOutput)glmModel._output).bestSubmodel().lambda_value;
        ((GAMModel.GAMModelOutput)model._output)._glm_training_metrics = ((GLMModel.GLMOutput)glmModel._output)._training_metrics;
        if (validNotNull) {
            ((GAMModel.GAMModelOutput)model._output)._glm_validation_metrics = ((GLMModel.GLMOutput)glmModel._output)._validation_metrics;
        }
        ((GAMModel.GAMModelOutput)model._output)._glm_model_summary = GAMModelUtils.copyTwoDimTable(((GLMModel.GLMOutput)glmModel._output)._model_summary, "glm model summary");
        ((GAMModel.GAMModelOutput)model._output)._glm_scoring_history = GAMModelUtils.copyTwoDimTable(((GLMModel.GLMOutput)glmModel._output)._scoring_history, "glm scoring history");
        if (parms._family == GLMModel.GLMParameters.Family.multinomial || parms._family == GLMModel.GLMParameters.Family.ordinal) {
            ((GAMModel.GAMModelOutput)model._output)._coefficients_table = GAMModelUtils.genCoefficientTableMultinomial(new String[]{"Coefficients", "Standardized Coefficients"}, ((GAMModel.GAMModelOutput)model._output)._model_beta_multinomial, ((GAMModel.GAMModelOutput)model._output)._standardized_model_beta_multinomial, ((GAMModel.GAMModelOutput)model._output)._coefficient_names, "GAM Coefficients");
            ((GAMModel.GAMModelOutput)model._output)._coefficients_table_no_centering = GAMModelUtils.genCoefficientTableMultinomial(new String[]{"coefficients no centering", "standardized coefficients no centering"}, ((GAMModel.GAMModelOutput)model._output)._model_beta_multinomial_no_centering, ((GAMModel.GAMModelOutput)model._output)._standardized_model_beta_multinomial_no_centering, ((GAMModel.GAMModelOutput)model._output)._coefficient_names_no_centering, "GAM Coefficients No Centering");
            ((GAMModel.GAMModelOutput)model._output)._standardized_coefficient_magnitudes = model.genCoefficientMagTableMultinomial(new String[]{"coefficients", "signs"}, ((GAMModel.GAMModelOutput)model._output)._standardized_model_beta_multinomial, ((GAMModel.GAMModelOutput)model._output)._coefficient_names, "standardized coefficients magnitude");
        } else {
            ((GAMModel.GAMModelOutput)model._output)._coefficients_table = GAMModelUtils.genCoefficientTable(new String[]{"coefficients", "standardized coefficients"}, ((GAMModel.GAMModelOutput)model._output)._model_beta, ((GAMModel.GAMModelOutput)model._output)._standardized_model_beta, ((GAMModel.GAMModelOutput)model._output)._coefficient_names, "GAM Coefficients");
            ((GAMModel.GAMModelOutput)model._output)._coefficients_table_no_centering = GAMModelUtils.genCoefficientTable(new String[]{"coefficients no centering", "standardized coefficients no centering"}, ((GAMModel.GAMModelOutput)model._output)._model_beta_no_centering, ((GAMModel.GAMModelOutput)model._output)._standardized_model_beta_no_centering, ((GAMModel.GAMModelOutput)model._output)._coefficient_names_no_centering, "GAM Coefficients No Centering");
            ((GAMModel.GAMModelOutput)model._output)._standardized_coefficient_magnitudes = model.genCoefficientMagTable(new String[]{"coefficients", "signs"}, ((GAMModel.GAMModelOutput)model._output)._standardized_model_beta, ((GAMModel.GAMModelOutput)model._output)._coefficient_names, "standardized coefficients magnitude");
        }
        if (parms._compute_p_values) {
            ((GAMModel.GAMModelOutput)model._output)._glm_zvalues = (double[])((GLMModel.GLMOutput)glmModel._output).zValues().clone();
            ((GAMModel.GAMModelOutput)model._output)._glm_pvalues = (double[])((GLMModel.GLMOutput)glmModel._output).pValues().clone();
            ((GAMModel.GAMModelOutput)model._output)._glm_stdErr = (double[])((GLMModel.GLMOutput)glmModel._output).stdErr().clone();
            ((GAMModel.GAMModelOutput)model._output)._glm_vcov = (double[][])((GLMModel.GLMOutput)glmModel._output).vcov().clone();
        }
        ((GAMModel.GAMModelOutput)model._output)._glm_dispersion = ((GLMModel.GLMOutput)glmModel._output).dispersion();
        model._nobs = glmModel._nobs;
        model._nullDOF = glmModel._nullDOF;
        model._ymu = new double[glmModel._ymu.length];
        model._rank = ((GLMModel.GLMOutput)glmModel._output).bestSubmodel().rank();
        model._ymu = new double[glmModel._ymu.length];
        System.arraycopy(glmModel._ymu, 0, model._ymu, 0, glmModel._ymu.length);
        if (model.evalAutoParamsEnabled && ((GAMModel.GAMParameters)model._parms)._solver == GLMModel.GLMParameters.Solver.AUTO) {
            ((GAMModel.GAMParameters)model._parms)._solver = ((GLMModel.GLMParameters)glmModel._parms)._solver;
        }
        ((GAMModel.GAMModelOutput)model._output)._varimp = new VarImp(((GLMModel.GLMOutput)glmModel._output)._varimp._varimp, ((GLMModel.GLMOutput)glmModel._output)._varimp._names);
        ((GAMModel.GAMModelOutput)model._output)._variable_importances = ModelMetrics.calcVarImp(((GAMModel.GAMModelOutput)model._output)._varimp);
    }

    public static TwoDimTable copyTwoDimTable(TwoDimTable table, String tableHeader) {
        String[] rowHeaders = table.getRowHeaders();
        String[] colTypes = table.getColTypes();
        int tableSize = rowHeaders.length;
        int colSize = colTypes.length;
        TwoDimTable tableCopy = new TwoDimTable(tableHeader, "", rowHeaders, table.getColHeaders(), colTypes, table.getColFormats(), "names");
        for (int rowIndex = 0; rowIndex < tableSize; ++rowIndex) {
            for (int colIndex = 0; colIndex < colSize; ++colIndex) {
                tableCopy.set(rowIndex, colIndex, table.get(rowIndex, colIndex));
            }
        }
        return tableCopy;
    }

    public static TwoDimTable genCoefficientTable(String[] colHeaders, double[] coefficients, double[] coefficientsStand, String[] coefficientNames, String tableHeader) {
        String[] colTypes = new String[]{"double", "double"};
        String[] colFormat = new String[]{"%5f", "%5f"};
        int nCoeff = coefficients.length;
        String[] coeffNames = new String[nCoeff];
        System.arraycopy(coefficientNames, 0, coeffNames, 0, nCoeff);
        Log.info("genCoefficientMagTable", String.format("coemffNames length: %d.  coefficients length: %d, coeffSigns length: %d", coeffNames.length, coefficients.length, coefficientsStand.length));
        TwoDimTable table = new TwoDimTable(tableHeader, "", coeffNames, colHeaders, colTypes, colFormat, "names");
        GAMModelUtils.fillUpCoeffs(coefficients, coefficientsStand, table, 0);
        return table;
    }

    public static TwoDimTable genCoefficientTableMultinomial(String[] colHeaders, double[][] coefficients, double[][] coefficients_stand, String[] coefficientNames, String tableHeader) {
        String[] colTypes = new String[]{"double", "double"};
        String[] colFormat = new String[]{"%5f", "%5f"};
        int nCoeff = coefficients[0].length;
        int nclass = coefficients.length;
        int totCoeff = nCoeff * nclass;
        String[] coeffNames = new String[totCoeff];
        int coeffCounter = 0;
        for (int classInd = 0; classInd < nclass; ++classInd) {
            for (int ind = 0; ind < nCoeff; ++ind) {
                coeffNames[coeffCounter++] = coefficientNames[ind] + "_class_" + classInd;
            }
        }
        TwoDimTable table = new TwoDimTable(tableHeader, "", coeffNames, colHeaders, colTypes, colFormat, "names");
        for (int classInd = 0; classInd < nclass; ++classInd) {
            GAMModelUtils.fillUpCoeffs(coefficients[classInd], coefficients_stand[classInd], table, classInd * nCoeff);
        }
        return table;
    }

    public static void fillUpCoeffs(double[] coeffValues, double[] coeffValuesStand, TwoDimTable tdt, int rowStart) {
        int arrLength = coeffValues.length + rowStart;
        int arrCounter = 0;
        for (int i = rowStart; i < arrLength; ++i) {
            tdt.set(i, 0, coeffValues[arrCounter]);
            tdt.set(i, 1, coeffValuesStand[arrCounter]);
            ++arrCounter;
        }
    }

    public static int copyGLMCoeffNames2GAMCoeffNames(GAMModel model, GLMModel glm) {
        int gamNumColStart;
        int numGamCols = model._gamColNamesNoCentering.length;
        String[] glmColNames = ((GLMModel.GLMOutput)glm._output).coefficientNames();
        int lastGLMCoeffIndex = glmColNames.length - 1;
        int lastGAMCoeffIndex = lastGLMCoeffIndex + GAMModelUtils.gamNoCenterCoeffLength((GAMModel.GAMParameters)model._parms);
        int gamLengthCopied = gamNumColStart = ArrayUtils.find(glmColNames, model._gamColNames[0][0]);
        System.arraycopy(glmColNames, 0, ((GAMModel.GAMModelOutput)model._output)._coefficient_names_no_centering, 0, gamLengthCopied);
        for (int gamColInd = 0; gamColInd < numGamCols; ++gamColInd) {
            System.arraycopy(model._gamColNamesNoCentering[gamColInd], 0, ((GAMModel.GAMModelOutput)model._output)._coefficient_names_no_centering, gamLengthCopied, model._gamColNamesNoCentering[gamColInd].length);
            gamLengthCopied += model._gamColNamesNoCentering[gamColInd].length;
        }
        ((GAMModel.GAMModelOutput)model._output)._coefficient_names_no_centering[lastGAMCoeffIndex] = glmColNames[lastGLMCoeffIndex];
        return gamNumColStart;
    }

    public static void copyGLMCoeffs2GAMCoeffs(GAMModel model, GLMModel glm, GLMModel.GLMParameters.Family family, int gamNumStart, int nclass) {
        int numCoeffPerClass = ((GAMModel.GAMModelOutput)model._output)._coefficient_names_no_centering.length;
        if (family.equals((Object)GLMModel.GLMParameters.Family.multinomial) || family.equals((Object)GLMModel.GLMParameters.Family.ordinal)) {
            double[][] model_beta_multinomial = ((GLMModel.GLMOutput)glm._output).get_global_beta_multinomial();
            double[][] standardized_model_beta_multinomial = ((GLMModel.GLMOutput)glm._output).getNormBetaMultinomial();
            ((GAMModel.GAMModelOutput)model._output)._model_beta_multinomial_no_centering = new double[nclass][];
            ((GAMModel.GAMModelOutput)model._output)._standardized_model_beta_multinomial_no_centering = new double[nclass][];
            for (int classInd = 0; classInd < nclass; ++classInd) {
                ((GAMModel.GAMModelOutput)model._output)._model_beta_multinomial_no_centering[classInd] = GAMModelUtils.convertCenterBeta2Beta(((GAMModel.GAMModelOutput)model._output)._zTranspose, gamNumStart, model_beta_multinomial[classInd], numCoeffPerClass);
                ((GAMModel.GAMModelOutput)model._output)._standardized_model_beta_multinomial_no_centering[classInd] = GAMModelUtils.convertCenterBeta2Beta(((GAMModel.GAMModelOutput)model._output)._zTranspose, gamNumStart, standardized_model_beta_multinomial[classInd], numCoeffPerClass);
            }
        } else {
            ((GAMModel.GAMModelOutput)model._output)._model_beta_no_centering = GAMModelUtils.convertCenterBeta2Beta(((GAMModel.GAMModelOutput)model._output)._zTranspose, gamNumStart, glm.beta(), numCoeffPerClass);
            ((GAMModel.GAMModelOutput)model._output)._standardized_model_beta_no_centering = GAMModelUtils.convertCenterBeta2Beta(((GAMModel.GAMModelOutput)model._output)._zTranspose, gamNumStart, ((GLMModel.GLMOutput)glm._output).getNormBeta(), numCoeffPerClass);
        }
    }

    public static double[] convertCenterBeta2Beta(double[][][] ztranspose, int gamNumStart, double[] centerBeta, int betaSize) {
        double[] originalBeta = new double[betaSize];
        if (ztranspose != null) {
            int numGamCols = ztranspose.length;
            int gamColStart = gamNumStart;
            int origGamColStart = gamNumStart;
            System.arraycopy(centerBeta, 0, originalBeta, 0, gamColStart);
            for (int colInd = 0; colInd < numGamCols; ++colInd) {
                double[] tempCbeta = new double[ztranspose[colInd].length];
                System.arraycopy(centerBeta, gamColStart, tempCbeta, 0, tempCbeta.length);
                double[] tempBeta = ArrayUtils.multVecArr(tempCbeta, ztranspose[colInd]);
                System.arraycopy(tempBeta, 0, originalBeta, origGamColStart, tempBeta.length);
                gamColStart += tempCbeta.length;
                origGamColStart += tempBeta.length;
            }
            originalBeta[betaSize - 1] = centerBeta[centerBeta.length - 1];
        } else {
            System.arraycopy(centerBeta, 0, originalBeta, 0, betaSize);
        }
        return originalBeta;
    }
}

