/*
 * Decompiled with CFR 0.152.
 */
package hex.gam.MatrixFrameUtils;

import water.MemoryManager;

public class TriDiagonalMatrix {
    public double[] _first_diag;
    public double[] _second_diag;
    public double[] _third_diag;
    public int _size;

    public TriDiagonalMatrix(int size) {
        assert (size > 0) : "Size of BiDiagonalMatrix must be > 0 but is " + size;
        this._size = size;
        this._first_diag = MemoryManager.malloc8d(size);
        this._second_diag = MemoryManager.malloc8d(size);
        this._third_diag = MemoryManager.malloc8d(size);
    }

    public TriDiagonalMatrix(double[] hj) {
        this(hj.length - 1);
        int diagSize = this._size;
        for (int index = 0; index < diagSize; ++index) {
            double oneOhj = 1.0 / hj[index];
            double oneOhjP1 = 1.0 / hj[index + 1];
            this._first_diag[index] = oneOhj;
            this._second_diag[index] = -oneOhj - oneOhjP1;
            this._third_diag[index] = oneOhjP1;
        }
    }
}

