/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.deeplearning;

import java.io.Serializable;

public class ActivationUtils {
    public static double maxArray(double[] input) {
        assert (input != null && input.length > 0) : "Your array is empty.";
        double temp = input[0];
        for (int index = 0; index < input.length; ++index) {
            temp = temp < input[index] ? input[index] : temp;
        }
        return temp;
    }

    public static double[] applyDropout(double[] input, double drop_out_ratio, int nodeSize) {
        if (drop_out_ratio > 0.0) {
            double multFact = 1.0 - drop_out_ratio;
            int index = 0;
            while (index < nodeSize) {
                int n = index++;
                input[n] = input[n] * multFact;
            }
        }
        return input;
    }

    public static class TanhOut
    implements ActivationFunctions {
        @Override
        public double[] eval(double[] input, double drop_out_ratio, int maxOutk) {
            int nodeSize = input.length;
            double[] output = new double[nodeSize];
            for (int index = 0; index < nodeSize; ++index) {
                output[index] = 1.0 - 2.0 / (1.0 + Math.exp(2.0 * input[index]));
            }
            return output;
        }
    }

    public static class TanhDropoutOut
    extends TanhOut {
        @Override
        public double[] eval(double[] input, double drop_out_ratio, int maxOutk) {
            int nodeSize = input.length;
            double[] output = super.eval(input, drop_out_ratio, maxOutk);
            ActivationUtils.applyDropout(output, drop_out_ratio, input.length);
            return output;
        }
    }

    public static class MaxoutOut
    implements ActivationFunctions {
        @Override
        public double[] eval(double[] input, double drop_out_ratio, int maxOutk) {
            int nodeSize = input.length / maxOutk;
            double[] output = new double[nodeSize];
            for (int index = 0; index < nodeSize; ++index) {
                int countInd = index * maxOutk;
                double temp = input[countInd];
                for (int k = 0; k < maxOutk; ++k) {
                    temp = temp > input[countInd += k] ? temp : input[countInd];
                }
                output[index] = temp;
            }
            return output;
        }
    }

    public static class MaxoutDropoutOut
    extends MaxoutOut {
        @Override
        public double[] eval(double[] input, double drop_out_ratio, int maxOutk) {
            double[] output = super.eval(input, drop_out_ratio, maxOutk);
            ActivationUtils.applyDropout(output, drop_out_ratio, output.length);
            return output;
        }
    }

    public static class RectifierDropoutOut
    extends RectifierOut {
        @Override
        public double[] eval(double[] input, double drop_out_ratio, int maxOutk) {
            double[] output = super.eval(input, drop_out_ratio, maxOutk);
            ActivationUtils.applyDropout(output, drop_out_ratio, input.length);
            return output;
        }
    }

    public static class RectifierOut
    implements ActivationFunctions {
        @Override
        public double[] eval(double[] input, double drop_out_ratio, int maxOutk) {
            int nodeSize = input.length;
            double[] output = new double[nodeSize];
            for (int index = 0; index < nodeSize; ++index) {
                output[index] = 0.5 * (input[index] + Math.abs(input[index]));
            }
            return output;
        }
    }

    public static class ExpRectifierOut
    implements ActivationFunctions {
        @Override
        public double[] eval(double[] input, double drop_out_ratio, int maxOutk) {
            int nodeSize = input.length;
            double[] output = new double[nodeSize];
            for (int index = 0; index < nodeSize; ++index) {
                output[index] = input[index] >= 0.0 ? input[index] : Math.exp(input[index]) - 1.0;
            }
            return output;
        }
    }

    public static class ExpRectifierDropoutOut
    extends ExpRectifierOut {
        @Override
        public double[] eval(double[] input, double drop_out_ratio, int maxOutk) {
            double[] output = super.eval(input, drop_out_ratio, maxOutk);
            ActivationUtils.applyDropout(output, drop_out_ratio, input.length);
            return output;
        }
    }

    public static class SoftmaxOut
    implements ActivationFunctions {
        @Override
        public double[] eval(double[] input, double drop_out_ratio, int maxOutk) {
            int index;
            int nodeSize = input.length;
            double[] output = new double[nodeSize];
            double scaling = 0.0;
            double max = ActivationUtils.maxArray(input);
            for (index = 0; index < nodeSize; ++index) {
                output[index] = Math.exp(input[index] - max);
                scaling += output[index];
            }
            index = 0;
            while (index < nodeSize) {
                int n = index++;
                output[n] = output[n] / scaling;
            }
            return output;
        }
    }

    public static class LinearOut
    implements ActivationFunctions {
        @Override
        public double[] eval(double[] input, double drop_out_ratio, int maxOutk) {
            return input;
        }
    }

    public static interface ActivationFunctions
    extends Serializable {
        public double[] eval(double[] var1, double var2, int var4);
    }
}

