/*
 * Decompiled with CFR 0.152.
 */
package hex.pca.mtj;

import hex.pca.PCAInterface;
import hex.util.EigenPair;
import hex.util.LinearAlgebraUtils;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.NotConvergedException;
import no.uib.cipr.matrix.SymmDenseEVD;
import no.uib.cipr.matrix.UpperSymmDenseMatrix;
import water.util.ArrayUtils;

public class PCA_MTJ_EVD_SymmMatrix
implements PCAInterface {
    private UpperSymmDenseMatrix symmGramMatrix;
    private SymmDenseEVD symmDenseEVD;
    private double[][] eigenvectors;
    private double[] eigenvalues;

    public PCA_MTJ_EVD_SymmMatrix(double[][] gramMatrix) {
        this.symmGramMatrix = new UpperSymmDenseMatrix(new DenseMatrix(gramMatrix));
        this.runEVD();
    }

    @Override
    public double[] getVariances() {
        return this.eigenvalues;
    }

    @Override
    public double[][] getPrincipalComponents() {
        return this.eigenvectors;
    }

    private void runEVD() {
        int gramDimension = this.symmGramMatrix.numRows();
        try {
            this.symmDenseEVD = SymmDenseEVD.factorize(this.symmGramMatrix);
        }
        catch (NotConvergedException e) {
            throw new RuntimeException(e);
        }
        this.eigenvalues = this.symmDenseEVD.getEigenvalues();
        double[] Vt_1D = this.symmDenseEVD.getEigenvectors().getData();
        this.eigenvectors = LinearAlgebraUtils.reshape1DArray(Vt_1D, gramDimension, gramDimension);
        EigenPair[] eigenPairs = LinearAlgebraUtils.createReverseSortedEigenpairs(this.eigenvalues, this.eigenvectors);
        this.eigenvalues = LinearAlgebraUtils.extractEigenvaluesFromEigenpairs(eigenPairs);
        this.eigenvectors = ArrayUtils.transpose(LinearAlgebraUtils.extractEigenvectorsFromEigenpairs(eigenPairs));
    }
}

