/*
 * Decompiled with CFR 0.152.
 */
package hex.psvm;

import hex.genmodel.algos.psvm.KernelParameters;
import hex.genmodel.utils.ByteBufferWrapper;
import hex.psvm.BulkSupportVectorScorer;
import org.apache.commons.math3.util.FastMath;
import water.fvec.Chunk;

class GaussianScorerParsed
implements BulkSupportVectorScorer {
    private final double _gamma;
    private final double[] _alphas;
    private final double[][] _nums;
    private final int[][] _cats;

    GaussianScorerParsed(KernelParameters parms, byte[] svs, int svsCount) {
        this(parms._gamma, svs, svsCount);
    }

    private GaussianScorerParsed(double gamma, byte[] svs, int svsCount) {
        this._gamma = gamma;
        this._alphas = new double[svsCount];
        this._nums = new double[svsCount][];
        this._cats = new int[svsCount][];
        ByteBufferWrapper bb = new ByteBufferWrapper(svs);
        for (int i = 0; i < svsCount; ++i) {
            int j;
            this._alphas[i] = bb.get8d();
            this._cats[i] = new int[bb.get4()];
            for (j = 0; j < this._cats[i].length; ++j) {
                this._cats[i][j] = bb.get4();
            }
            this._nums[i] = new double[bb.get4()];
            for (j = 0; j < this._nums[i].length; ++j) {
                this._nums[i][j] = bb.get8d();
            }
        }
    }

    @Override
    public double[] bulkScore0(Chunk[] cs) {
        double[] result = new double[cs[0]._len];
        double[] norms = new double[cs[0]._len];
        for (int s = 0; s < this._alphas.length; ++s) {
            int i;
            for (i = 0; i < this._cats[s].length; ++i) {
                int svCat = this._cats[s][i];
                for (int j = 0; j < norms.length; ++j) {
                    int n = j;
                    norms[n] = norms[n] + ((int)cs[i].at8(j) == svCat ? 0.0 : 2.0);
                }
            }
            for (i = 0; i < this._nums[s].length; ++i) {
                double svNum = this._nums[s][i];
                int j = 0;
                while (j < norms.length) {
                    double v = cs[i + this._cats[s].length].atd(j) - svNum;
                    int n = j++;
                    norms[n] = norms[n] + v * v;
                }
            }
            for (int j = 0; j < result.length; ++j) {
                int n = j;
                result[n] = result[n] + this._alphas[s] * FastMath.exp(-this._gamma * norms[j]);
                norms[j] = 0.0;
            }
        }
        return result;
    }
}

