/*
 * Decompiled with CFR 0.152.
 */
package hex.rulefit;

import hex.Model;
import hex.MultiModelMojoWriter;
import hex.rulefit.Condition;
import hex.rulefit.Rule;
import hex.rulefit.RuleEnsemble;
import hex.rulefit.RuleFitModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RuleFitMojoWriter
extends MultiModelMojoWriter<RuleFitModel, RuleFitModel.RuleFitParameters, RuleFitModel.RuleFitOutput> {
    public RuleFitMojoWriter() {
    }

    public RuleFitMojoWriter(RuleFitModel model) {
        super(model);
    }

    @Override
    public String mojoVersion() {
        return "1.00";
    }

    @Override
    protected List<Model> getSubModels() {
        if (((RuleFitModel)this.model).glmModel != null) {
            return Collections.singletonList(((RuleFitModel)this.model).glmModel);
        }
        return Collections.emptyList();
    }

    @Override
    protected void writeParentModelData() throws IOException {
        int i;
        this.writekv("linear_model", ((RuleFitModel.RuleFitOutput)((RuleFitModel)this.model)._output).glmModelKey);
        if (!((RuleFitModel.RuleFitParameters)((RuleFitModel)this.model)._parms)._model_type.equals((Object)RuleFitModel.ModelType.LINEAR)) {
            this.writeOrderedRuleEnsemble(((RuleFitModel)this.model).ruleEnsemble, ((RuleFitModel.RuleFitParameters)((RuleFitModel)this.model)._parms)._max_rule_length - ((RuleFitModel.RuleFitParameters)((RuleFitModel)this.model)._parms)._min_rule_length + 1, ((RuleFitModel.RuleFitParameters)((RuleFitModel)this.model)._parms)._rule_generation_ntrees, ((RuleFitModel.RuleFitOutput)((RuleFitModel)this.model)._output).classNames());
        }
        if (((RuleFitModel.RuleFitParameters)((RuleFitModel)this.model)._parms)._model_type.equals((Object)RuleFitModel.ModelType.LINEAR)) {
            this.writekv("model_type", 0);
        } else if (((RuleFitModel.RuleFitParameters)((RuleFitModel)this.model)._parms)._model_type.equals((Object)RuleFitModel.ModelType.RULES_AND_LINEAR)) {
            this.writekv("model_type", 1);
        } else {
            this.writekv("model_type", 2);
        }
        this.writekv("type", ((RuleFitModel.RuleFitOutput)((RuleFitModel)this.model)._output).glmModelKey);
        this.writekv("depth", ((RuleFitModel.RuleFitParameters)((RuleFitModel)this.model)._parms)._max_rule_length - ((RuleFitModel.RuleFitParameters)((RuleFitModel)this.model)._parms)._min_rule_length + 1);
        this.writekv("ntrees", ((RuleFitModel.RuleFitParameters)((RuleFitModel)this.model)._parms)._rule_generation_ntrees);
        this.writekv("data_from_rules_codes_len", ((RuleFitModel.RuleFitOutput)((RuleFitModel)this.model)._output)._dataFromRulesCodes.length);
        for (i = 0; i < ((RuleFitModel.RuleFitOutput)((RuleFitModel)this.model)._output)._dataFromRulesCodes.length; ++i) {
            this.writekv("data_from_rules_codes_" + i, ((RuleFitModel.RuleFitOutput)((RuleFitModel)this.model)._output)._dataFromRulesCodes[i]);
        }
        if (((RuleFitModel.RuleFitParameters)((RuleFitModel)this.model)._parms)._weights_column != null) {
            this.writekv("weights_column", ((RuleFitModel.RuleFitParameters)((RuleFitModel)this.model)._parms)._weights_column);
        }
        this.writekv("linear_names_len", ((RuleFitModel.RuleFitOutput)((RuleFitModel)this.model)._output)._linear_names.length);
        for (i = 0; i < ((RuleFitModel.RuleFitOutput)((RuleFitModel)this.model)._output)._linear_names.length; ++i) {
            this.writekv("linear_names_" + i, ((RuleFitModel.RuleFitOutput)((RuleFitModel)this.model)._output)._linear_names[i]);
        }
    }

    void writeOrderedRuleEnsemble(RuleEnsemble ruleEnsemble, int depth, int ntrees, String[] classes) throws IOException {
        for (int i = 0; i < depth; ++i) {
            for (int j = 0; j < ntrees; ++j) {
                int k;
                String regex = "M" + i + "T" + j + "N\\d+";
                int nclasses = classes != null && classes.length > 2 ? classes.length : 1;
                String[] classRegex = new String[nclasses];
                ArrayList[] filteredClassRules = new ArrayList[nclasses];
                ArrayList filteredRules = new ArrayList();
                for (k = 0; k < nclasses; ++k) {
                    classRegex[k] = nclasses > 2 ? regex + "_" + classes[k] : regex;
                }
                for (k = 0; k < nclasses; ++k) {
                    for (int l = 0; l < ruleEnsemble.rules.length; ++l) {
                        if (!ruleEnsemble.rules[l].varName.matches(classRegex[k])) continue;
                        if (filteredClassRules[k] == null) {
                            filteredClassRules[k] = new ArrayList();
                        }
                        filteredClassRules[k].add(ruleEnsemble.rules[l]);
                    }
                    filteredRules.addAll(filteredClassRules[k]);
                }
                int currNumRules = filteredRules.size();
                this.writekv("num_rules_M".concat(String.valueOf(i)).concat("T").concat(String.valueOf(j)), currNumRules);
                String currIdPrefix = i + "_" + j + "_";
                for (int k2 = 0; k2 < currNumRules; ++k2) {
                    this.writeRule((Rule)filteredRules.get(k2), currIdPrefix + k2);
                }
            }
        }
    }

    void writeRule(Rule rule, String ruleId) throws IOException {
        int numConditions = rule.conditions.length;
        this.writekv("num_conditions_rule_id_" + ruleId, numConditions);
        for (int i = 0; i < numConditions; ++i) {
            this.writeCondition(rule.conditions[i], i, ruleId);
        }
        this.writekv("prediction_value_rule_id_" + ruleId, rule.predictionValue);
        this.writekv("language_rule_rule_id_" + ruleId, rule.languageRule);
        this.writekv("coefficient_rule_id_" + ruleId, rule.coefficient);
        this.writekv("var_name_rule_id_" + ruleId, rule.varName);
        this.writekv("support_rule_id_" + ruleId, rule.support);
    }

    void writeCondition(Condition condition, int conditionId, String ruleId) throws IOException {
        String conditionIdentifier = conditionId + "_" + ruleId;
        this.writekv("feature_index_" + conditionIdentifier, condition.featureIndex);
        if (Condition.Type.Categorical.equals((Object)condition.type)) {
            this.writekv("type_" + conditionIdentifier, 0);
            int languageCatTresholdLength = condition.languageCatTreshold.length;
            this.writekv("language_cat_treshold_length_" + conditionIdentifier, languageCatTresholdLength);
            for (int i = 0; i < languageCatTresholdLength; ++i) {
                this.writekv("language_cat_treshold_" + i + "_" + conditionIdentifier, condition.languageCatTreshold[i]);
            }
            int catTresholdLength = condition.catTreshold.length;
            this.writekv("cat_treshold_length_" + conditionIdentifier, catTresholdLength);
            for (int i = 0; i < catTresholdLength; ++i) {
                this.writekv("cat_treshold_length_" + i + "_" + conditionIdentifier, condition.catTreshold[i]);
            }
        } else {
            this.writekv("type_" + conditionIdentifier, 1);
            this.writekv("num_treshold" + conditionIdentifier, condition.numTreshold);
        }
        if (Condition.Operator.LessThan.equals((Object)condition.operator)) {
            this.writekv("operator_" + conditionIdentifier, 0);
        } else if (Condition.Operator.GreaterThanOrEqual.equals((Object)condition.operator)) {
            this.writekv("operator_" + conditionIdentifier, 1);
        } else {
            this.writekv("operator_" + conditionIdentifier, 2);
        }
        this.writekv("feature_name_" + conditionIdentifier, condition.featureName);
        this.writekv("nas_included_" + conditionIdentifier, condition.NAsIncluded);
        this.writekv("language_condition" + conditionIdentifier, condition.languageCondition);
    }
}

