/*
 * Decompiled with CFR 0.152.
 */
package hex.rulefit;

import hex.rulefit.Rule;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class RuleFitUtils {
    public static String[] getPathNames(int modelId, int numCols, String[] names) {
        String[] pathNames = new String[numCols];
        for (int i = 0; i < numCols; ++i) {
            pathNames[i] = "tree_" + modelId + "." + names[i];
        }
        return pathNames;
    }

    public static String[] getLinearNames(int numCols, String[] names) {
        String[] pathNames = new String[numCols];
        for (int i = 0; i < numCols; ++i) {
            pathNames[i] = "linear." + names[i];
        }
        return pathNames;
    }

    static Rule[] deduplicateRules(Rule[] rules, boolean remove_duplicates) {
        if (remove_duplicates) {
            List<Rule> list = Arrays.asList(rules);
            List<Rule> transform = list.stream().filter(rule -> rule.conditions != null).collect(Collectors.groupingBy(rule -> rule.languageRule)).entrySet().stream().map(e -> ((List)e.getValue()).stream().reduce((r1, r2) -> new Rule(r1.conditions, r1.predictionValue, r1.varName + ", " + r2.varName, r1.coefficient + r2.coefficient, r1.support))).map(f -> (Rule)f.get()).collect(Collectors.toList());
            transform.addAll(list.stream().filter(rule -> rule.conditions == null).collect(Collectors.toList()));
            return transform.toArray(new Rule[0]);
        }
        return rules;
    }

    static Rule[] sortRules(Rule[] rules) {
        Comparator<Rule> ruleAbsCoefficientComparator = Comparator.comparingDouble(Rule::getAbsCoefficient).reversed();
        Arrays.sort(rules, ruleAbsCoefficientComparator);
        return rules;
    }

    static String readRuleId(String ruleId) {
        if (ruleId.contains(",")) {
            return ruleId.split(",")[0];
        }
        return ruleId;
    }
}

