/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.CMetricScoringTask;
import hex.Model;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.genmodel.GenModel;
import hex.genmodel.utils.DistributionFamily;
import hex.tree.SharedTree;
import hex.tree.SharedTreeModel;
import hex.tree.gbm.GBMModel;
import org.apache.log4j.Logger;
import water.Iced;
import water.Key;
import water.fvec.C0DChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.udf.CFuncRef;

public class Score
extends CMetricScoringTask<Score> {
    private static final Logger LOG = Logger.getLogger(Score.class);
    final SharedTree _bldr;
    final boolean _is_train;
    final boolean _oob;
    final Key<Vec> _kresp;
    final ModelCategory _mcat;
    final boolean _computeGainsLift;
    final ScoreIncInfo _sii;
    final Frame _preds;
    final ScoreExtension _ext;
    ModelMetrics.MetricBuilder _mb;

    public Score(SharedTree bldr, boolean is_train, boolean oob, Vec kresp, ModelCategory mcat, boolean computeGainsLift, Frame preds, CFuncRef customMetricFunc) {
        this(bldr, is_train, null, oob, kresp, mcat, computeGainsLift, preds, customMetricFunc);
    }

    public Score(SharedTree bldr, ScoreIncInfo sii, boolean oob, Vec kresp, ModelCategory mcat, boolean computeGainsLift, Frame preds, CFuncRef customMetricFunc) {
        this(bldr, false, sii, oob, kresp, mcat, computeGainsLift, preds, customMetricFunc);
    }

    private Score(SharedTree bldr, boolean is_train, ScoreIncInfo sii, boolean oob, Vec kresp, ModelCategory mcat, boolean computeGainsLift, Frame preds, CFuncRef customMetricFunc) {
        super(customMetricFunc);
        this._bldr = bldr;
        this._is_train = is_train;
        this._sii = sii;
        this._oob = oob;
        this._kresp = kresp != null ? kresp._key : null;
        this._mcat = mcat;
        this._computeGainsLift = computeGainsLift;
        Frame frame = this._preds = computeGainsLift ? preds : null;
        assert (this._kresp != null || !this._bldr.isSupervised());
        assert (!this._is_train || this._sii == null);
        this._ext = this._bldr.makeScoreExtension();
    }

    @Override
    public void map(Chunk[] allchks) {
        Chunk offsetChunk;
        Chunk[] chks = this.getScoringChunks(allchks);
        Chunk ys = this._bldr.isSupervised() ? this._bldr.chk_resp(chks) : (this._bldr.isResponseOptional() && this._kresp != null ? this._kresp.get().chunkForChunkIdx(chks[0].cidx()) : new C0DChunk(0.0, chks[0]._len));
        Object m = this._bldr._model;
        Chunk weightsChunk = ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)m)._output).hasWeights() ? chks[((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)m)._output).weightsIdx()] : null;
        Chunk chunk = offsetChunk = ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)m)._output).hasOffset() ? chks[((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)m)._output).offsetIdx()] : null;
        String[] domain = ((SharedTreeModel.SharedTreeParameters)((SharedTreeModel)m)._parms)._distribution == DistributionFamily.quasibinomial ? ((GBMModel.GBMOutput)((GBMModel)m)._output)._quasibinomialDomains : (this._kresp != null ? this._kresp.get().domain() : null);
        int nclass = this._bldr.nclasses();
        this._mb = ((SharedTreeModel)m).makeMetricBuilder(domain);
        int oobColIdx = this._bldr.idx_oobt();
        double[] cdists = this._mb._work;
        double[] tmp = (double[])(this._is_train && this._bldr._ntrees > 0 ? null : new double[this._bldr._ncols]);
        int[] responseComplements = this._ext == null ? new int[]{} : this._ext.getResponseComplements((SharedTreeModel<?, ?, ?>)m);
        float[] val = new float[1 + responseComplements.length];
        for (int row = 0; row < ys._len; ++row) {
            int i;
            double offset;
            double weight;
            if (ys.isNA(row) || this._oob && chks[oobColIdx].atd(row) == 0.0) continue;
            double d = weight = weightsChunk != null ? weightsChunk.atd(row) : 1.0;
            if (weight == 0.0) continue;
            double d2 = offset = offsetChunk != null ? offsetChunk.atd(row) : 0.0;
            if (this._is_train) {
                this._bldr.score2(chks, weight, offset, cdists, row);
            } else if (this._sii != null) {
                ((SharedTreeModel)m).score0Incremental(this._sii, chks, offset, row, tmp, cdists);
            } else {
                ((Model)m).score0(chks, offset, row, tmp, cdists);
            }
            if (this._is_train && this._bldr._ntrees == 0) {
                for (i = 0; i < tmp.length; ++i) {
                    tmp[i] = chks[i].atd(row);
                }
            }
            if (this._ext != null) {
                cdists[0] = this._ext.getPrediction(cdists);
            } else if (nclass > 2) {
                cdists[0] = GenModel.getPredictionMultinomial(cdists, ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)m)._output)._priorClassDist, tmp);
            } else if (nclass == 2) {
                cdists[0] = -1.0;
            }
            val[0] = (float)ys.atd(row);
            if (responseComplements.length > 0) {
                for (i = 0; i < responseComplements.length; ++i) {
                    val[1 + i] = (float)chks[responseComplements[i]].atd(row);
                }
            }
            this._mb.perRow(cdists, val, weight, offset, (Model)m);
            if (this._preds != null) {
                this._mb.cachePrediction(cdists, allchks, row, chks.length, (Model)m);
            }
            this.customMetricPerRow(cdists, val, weight, offset, (Model)m);
        }
    }

    private Chunk[] getScoringChunks(Chunk[] allChunks) {
        if (this._preds == null) {
            return allChunks;
        }
        Chunk[] chks = new Chunk[allChunks.length - this._preds.numCols()];
        System.arraycopy(allChunks, 0, chks, 0, chks.length);
        return chks;
    }

    @Override
    protected boolean modifiesVolatileVecs() {
        return this._sii != null || this._preds != null;
    }

    @Override
    public void reduce(Score t) {
        super.reduce(t);
        this._mb.reduce(t._mb);
    }

    @Override
    protected void postGlobal() {
        super.postGlobal();
        if (this._mb != null) {
            this._mb.postGlobal(this.getComputedCustomMetric());
        }
    }

    ModelMetrics scoreAndMakeModelMetrics(SharedTreeModel model, Frame fr, Frame adaptedFr, boolean buildTreeOneNode) {
        Frame input = this._preds != null ? new Frame(adaptedFr).add(this._preds) : adaptedFr;
        return ((Score)this.doAll(input, buildTreeOneNode)).makeModelMetrics(model, fr, adaptedFr, this._preds);
    }

    private ModelMetrics makeModelMetrics(SharedTreeModel model, Frame fr, Frame adaptedFr, Frame preds) {
        ModelMetrics mm;
        if (model._output.nclasses() == 2 && this._computeGainsLift || this._ext != null) {
            assert (preds != null) : "Predictions were pre-created";
            mm = this._mb.makeModelMetrics(model, fr, adaptedFr, preds);
        } else {
            boolean calculatePreds;
            boolean bl = calculatePreds = preds == null && model.isDistributionHuber();
            if (calculatePreds) {
                LOG.warn("Going to calculate predictions from scratch. This can be expensive for large models! See PUBDEV-4992");
                preds = model.score(fr);
            }
            mm = this._mb.makeModelMetrics(model, fr, null, preds);
            if (calculatePreds && preds != null) {
                preds.remove();
            }
        }
        return mm;
    }

    static Frame makePredictionCache(SharedTreeModel model, Vec templateVec, String[] domain) {
        ModelMetrics.MetricBuilder mb = model.makeMetricBuilder(domain);
        return mb.makePredictionCache(model, templateVec);
    }

    public static abstract class ScoreExtension
    extends Iced<ScoreExtension> {
        protected abstract double getPrediction(double[] var1);

        protected abstract int[] getResponseComplements(SharedTreeModel<?, ?, ?> var1);
    }

    public static class ScoreIncInfo
    extends Iced<ScoreIncInfo> {
        public final int _startTree;
        public final int _workspaceColIdx;
        public final int _workspaceColCnt;
        public final int _predsAryOffset;

        public ScoreIncInfo(int startTree, int workspaceColIdx, int workspaceColCnt, int predsAryOffset) {
            this._startTree = startTree;
            this._workspaceColIdx = workspaceColIdx;
            this._workspaceColCnt = workspaceColCnt;
            this._predsAryOffset = predsAryOffset;
        }
    }
}

