/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.Model;
import hex.genmodel.algos.tree.SharedTreeGraph;
import hex.genmodel.algos.tree.SharedTreeGraphConverter;
import hex.genmodel.algos.tree.SharedTreeNode;
import hex.genmodel.algos.tree.SharedTreeSubgraph;
import hex.schemas.TreeV3;
import hex.tree.PathResult;
import hex.tree.SharedTreeModel;
import hex.tree.TreeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import water.MemoryManager;
import water.api.Handler;

public class TreeHandler
extends Handler {
    private static final int NO_CHILD = -1;

    public TreeV3 getTree(int version, TreeV3 args) {
        SharedTreeSubgraph sharedTreeSubgraph;
        if (args.tree_number < 0) {
            throw new IllegalArgumentException("Invalid tree number: " + args.tree_number + ". Tree number must be >= 0.");
        }
        Object possibleModel = args.model.key().get();
        if (possibleModel == null) {
            throw new IllegalArgumentException("Given model does not exist: " + args.model.key().toString());
        }
        if (!(possibleModel instanceof SharedTreeModel) && !(possibleModel instanceof SharedTreeGraphConverter)) {
            throw new IllegalArgumentException("Given model is not tree-based.");
        }
        if (possibleModel instanceof SharedTreeGraphConverter) {
            SharedTreeGraphConverter treeBackedModel = (SharedTreeGraphConverter)possibleModel;
            SharedTreeGraph sharedTreeGraph = treeBackedModel.convert(args.tree_number, args.tree_class);
            assert (sharedTreeGraph.subgraphArray.size() == 1);
            sharedTreeSubgraph = sharedTreeGraph.subgraphArray.get(0);
            if (!((Model.Output)((Model)possibleModel)._output).isClassifier()) {
                args.tree_class = null;
            }
        } else {
            SharedTreeModel model = (SharedTreeModel)possibleModel;
            SharedTreeModel.SharedTreeOutput sharedTreeOutput = (SharedTreeModel.SharedTreeOutput)model._output;
            int treeClass = TreeUtils.getResponseLevelIndex(args.tree_class, sharedTreeOutput);
            sharedTreeSubgraph = model.getSharedTreeSubgraph(args.tree_number, treeClass);
            args.tree_class = sharedTreeOutput.isClassifier() ? sharedTreeOutput.classNames()[treeClass] : null;
        }
        TreeProperties treeProperties = TreeHandler.convertSharedTreeSubgraph(sharedTreeSubgraph, args.plain_language_rules);
        args.left_children = treeProperties._leftChildren;
        args.right_children = treeProperties._rightChildren;
        args.descriptions = treeProperties._descriptions;
        args.root_node_id = sharedTreeSubgraph.rootNode.getNodeNumber();
        args.thresholds = treeProperties._thresholds;
        args.features = treeProperties._features;
        args.nas = treeProperties._nas;
        args.levels = treeProperties.levels;
        args.predictions = treeProperties._predictions;
        args.tree_decision_path = treeProperties._treeDecisionPath;
        args.decision_paths = treeProperties._decisionPaths;
        return args;
    }

    private static String getLanguageRepresentation(SharedTreeSubgraph sharedTreeSubgraph) {
        return TreeHandler.getNodeRepresentation(sharedTreeSubgraph.rootNode, new StringBuilder(), 0).toString();
    }

    private static StringBuilder getNodeRepresentation(SharedTreeNode node, StringBuilder languageRepresentation, int padding) {
        if (node.getRightChild() != null) {
            languageRepresentation.append((CharSequence)TreeHandler.getConditionLine(node, padding));
            languageRepresentation.append((CharSequence)TreeHandler.getNewPaddedLine(padding));
            languageRepresentation = TreeHandler.getNodeRepresentation(node.getRightChild(), languageRepresentation, padding + 1);
            languageRepresentation.append((CharSequence)TreeHandler.getNewPaddedLine(padding));
            languageRepresentation.append((CharSequence)TreeHandler.getElseLine(node));
            languageRepresentation.append((CharSequence)TreeHandler.getNewPaddedLine(padding));
            languageRepresentation = TreeHandler.getNodeRepresentation(node.getLeftChild(), languageRepresentation, padding + 1);
            languageRepresentation.append((CharSequence)TreeHandler.getNewPaddedLine(padding));
            languageRepresentation.append("}");
        } else {
            languageRepresentation.append((CharSequence)TreeHandler.getNewPaddedLine(padding));
            if (Float.compare(node.getPredValue(), Float.NaN) != 0) {
                languageRepresentation.append("Predicted value: " + node.getPredValue());
            } else {
                languageRepresentation.append("Predicted value: NaN");
            }
            languageRepresentation.append((CharSequence)TreeHandler.getNewPaddedLine(padding));
        }
        return languageRepresentation;
    }

    private static StringBuilder getNewPaddedLine(int padding) {
        StringBuilder line = new StringBuilder("\n");
        for (int i = 0; i < padding; ++i) {
            line.append("\t");
        }
        return line;
    }

    private static StringBuilder getElseLine(SharedTreeNode node) {
        StringBuilder elseLine = new StringBuilder();
        if (node.getDomainValues() == null) {
            elseLine.append("} else {");
        } else {
            SharedTreeNode leftChild = node.getLeftChild();
            elseLine.append("} else if ( ").append(node.getColName()).append(" is in [ ");
            BitSet inclusiveLevelsSet = leftChild.getInclusiveLevels();
            if (inclusiveLevelsSet != null) {
                String stringToParseInclusiveLevelsFrom = inclusiveLevelsSet.toString();
                int inclusiveLevelsLength = inclusiveLevelsSet.toString().length();
                if (inclusiveLevelsLength > 2) {
                    String[] inclusiveLevels;
                    stringToParseInclusiveLevelsFrom = stringToParseInclusiveLevelsFrom.substring(1, inclusiveLevelsLength - 1);
                    for (String index : inclusiveLevels = stringToParseInclusiveLevelsFrom.split(",")) {
                        elseLine.append(node.getDomainValues()[Integer.parseInt(index.trim())] + " ");
                    }
                } else {
                    elseLine.append("Missing set of levels for underlying node");
                }
            }
            elseLine.append("]) {");
        }
        return elseLine;
    }

    private static StringBuilder getConditionLine(SharedTreeNode node, int padding) {
        StringBuilder conditionLine = new StringBuilder();
        if (padding != 0) {
            conditionLine.append((CharSequence)TreeHandler.getNewPaddedLine(padding));
        }
        if (node.getDomainValues() == null) {
            if (Float.compare(node.getSplitValue(), Float.NaN) == 0) {
                conditionLine.append("If ( " + node.getColName() + " is NaN ) {");
            } else {
                conditionLine.append("If ( " + node.getColName() + " >= " + node.getSplitValue());
                if ("RIGHT".equals(TreeHandler.getNaDirection(node))) {
                    conditionLine.append(" or ").append(node.getColName()).append(" is NaN ) {");
                } else {
                    conditionLine.append(" ) {");
                }
            }
        } else {
            conditionLine.append("If ( " + node.getColName() + " is in [ ");
            SharedTreeNode rightChild = node.getRightChild();
            String stringToParseInclusiveLevelsFrom = rightChild.getInclusiveLevels().toString();
            int inclusiveLevelsLength = rightChild.getInclusiveLevels().toString().length();
            if (inclusiveLevelsLength > 2) {
                stringToParseInclusiveLevelsFrom = stringToParseInclusiveLevelsFrom.substring(1, inclusiveLevelsLength - 1);
                String[] inclusiveLevels = stringToParseInclusiveLevelsFrom.split(",");
                Arrays.stream(inclusiveLevels).map(String::trim).map(Integer::parseInt).forEach(index -> conditionLine.append(node.getDomainValues()[index] + " "));
            } else {
                conditionLine.append("Missing set of levels for underlying node");
            }
            conditionLine.append("]) {");
        }
        return conditionLine;
    }

    static TreeProperties convertSharedTreeSubgraph(SharedTreeSubgraph sharedTreeSubgraph, PlainLanguageRules plainLanguageRules) {
        Objects.requireNonNull(sharedTreeSubgraph);
        TreeProperties treeprops = new TreeProperties();
        treeprops._leftChildren = MemoryManager.malloc4(sharedTreeSubgraph.nodesArray.size());
        treeprops._rightChildren = MemoryManager.malloc4(sharedTreeSubgraph.nodesArray.size());
        treeprops._descriptions = new String[sharedTreeSubgraph.nodesArray.size()];
        treeprops._thresholds = MemoryManager.malloc4f(sharedTreeSubgraph.nodesArray.size());
        treeprops._features = new String[sharedTreeSubgraph.nodesArray.size()];
        treeprops._nas = new String[sharedTreeSubgraph.nodesArray.size()];
        treeprops._predictions = MemoryManager.malloc4f(sharedTreeSubgraph.nodesArray.size());
        treeprops._leafNodeAssignments = new String[sharedTreeSubgraph.nodesArray.size()];
        treeprops._decisionPaths = new String[sharedTreeSubgraph.nodesArray.size()];
        TreeProperties.access$002(treeprops, MemoryManager.malloc4(sharedTreeSubgraph.nodesArray.size()));
        TreeProperties.access$102(treeprops, MemoryManager.malloc4(sharedTreeSubgraph.nodesArray.size()));
        treeprops._rightChildren[0] = sharedTreeSubgraph.rootNode.getRightChild() != null ? sharedTreeSubgraph.rootNode.getRightChild().getNodeNumber() : -1;
        treeprops._leftChildren[0] = sharedTreeSubgraph.rootNode.getLeftChild() != null ? sharedTreeSubgraph.rootNode.getLeftChild().getNodeNumber() : -1;
        treeprops._thresholds[0] = sharedTreeSubgraph.rootNode.getSplitValue();
        treeprops._features[0] = sharedTreeSubgraph.rootNode.getColName();
        treeprops._nas[0] = TreeHandler.getNaDirection(sharedTreeSubgraph.rootNode);
        treeprops.levels = new int[sharedTreeSubgraph.nodesArray.size()][];
        if (plainLanguageRules.equals((Object)PlainLanguageRules.AUTO)) {
            PlainLanguageRules plainLanguageRules2 = plainLanguageRules = sharedTreeSubgraph.nodesArray.size() < 256 ? PlainLanguageRules.TRUE : PlainLanguageRules.FALSE;
        }
        if (plainLanguageRules.equals((Object)PlainLanguageRules.TRUE)) {
            treeprops._treeDecisionPath = TreeHandler.getLanguageRepresentation(sharedTreeSubgraph);
            treeprops._decisionPaths[0] = "Predicted value: " + sharedTreeSubgraph.rootNode.getPredValue();
            ((TreeProperties)treeprops)._leftChildrenNormalized[0] = sharedTreeSubgraph.rootNode.getLeftChild() != null ? sharedTreeSubgraph.rootNode.getLeftChild().getNodeNumber() : -1;
            ((TreeProperties)treeprops)._rightChildrenNormalized[0] = sharedTreeSubgraph.rootNode.getRightChild() != null ? sharedTreeSubgraph.rootNode.getRightChild().getNodeNumber() : -1;
        }
        TreeProperties.access$202(treeprops, new String[sharedTreeSubgraph.nodesArray.size()][]);
        ((TreeProperties)treeprops)._domainValues[0] = sharedTreeSubgraph.rootNode.getDomainValues();
        ArrayList<SharedTreeNode> nodesToTraverse = new ArrayList<SharedTreeNode>();
        nodesToTraverse.add(sharedTreeSubgraph.rootNode);
        TreeHandler.append(treeprops._rightChildren, treeprops._leftChildren, treeprops._descriptions, treeprops._thresholds, treeprops._features, treeprops._nas, treeprops.levels, treeprops._predictions, nodesToTraverse, -1, false, treeprops._domainValues);
        if (plainLanguageRules.equals((Object)PlainLanguageRules.TRUE)) {
            TreeHandler.fillLanguagePathRepresentation(treeprops, sharedTreeSubgraph.rootNode);
        }
        return treeprops;
    }

    private static void append(int[] rightChildren, int[] leftChildren, String[] nodesDescriptions, float[] thresholds, String[] splitColumns, String[] naHandlings, int[][] levels, float[] predictions, List<SharedTreeNode> nodesToTraverse, int pointer, boolean visitedRoot, String[][] domainValues) {
        if (nodesToTraverse.isEmpty()) {
            return;
        }
        ArrayList<SharedTreeNode> discoveredNodes = new ArrayList<SharedTreeNode>();
        for (SharedTreeNode node : nodesToTraverse) {
            ++pointer;
            SharedTreeNode leftChild = node.getLeftChild();
            SharedTreeNode rightChild = node.getRightChild();
            if (visitedRoot) {
                TreeHandler.fillnodeDescriptions(node, nodesDescriptions, thresholds, splitColumns, levels, predictions, naHandlings, pointer, domainValues);
            } else {
                StringBuilder rootDescriptionBuilder = new StringBuilder();
                rootDescriptionBuilder.append("*** WARNING: This property is deprecated! *** ");
                rootDescriptionBuilder.append("Root node has id ");
                rootDescriptionBuilder.append(node.getNodeNumber());
                rootDescriptionBuilder.append(" and splits on column '");
                rootDescriptionBuilder.append(node.getColName());
                rootDescriptionBuilder.append("'. ");
                TreeHandler.fillNodeSplitTowardsChildren(rootDescriptionBuilder, node);
                nodesDescriptions[pointer] = rootDescriptionBuilder.toString();
                visitedRoot = true;
            }
            if (leftChild != null) {
                discoveredNodes.add(leftChild);
                leftChildren[pointer] = leftChild.getNodeNumber();
            } else {
                leftChildren[pointer] = -1;
            }
            if (rightChild != null) {
                discoveredNodes.add(rightChild);
                rightChildren[pointer] = rightChild.getNodeNumber();
                continue;
            }
            rightChildren[pointer] = -1;
        }
        TreeHandler.append(rightChildren, leftChildren, nodesDescriptions, thresholds, splitColumns, naHandlings, levels, predictions, discoveredNodes, pointer, true, domainValues);
    }

    private static List<Integer> extractInternalIds(TreeProperties properties) {
        int nodeId = 0;
        ArrayList<Integer> nodeIds = new ArrayList<Integer>();
        nodeIds.add(nodeId);
        for (int i = 0; i < properties._leftChildren.length; ++i) {
            if (properties._leftChildren[i] != -1) {
                nodeIds.add(properties._leftChildren[i]);
                ((TreeProperties)properties)._leftChildrenNormalized[i] = ++nodeId;
            } else {
                ((TreeProperties)properties)._leftChildrenNormalized[i] = -1;
            }
            if (properties._rightChildren[i] != -1) {
                nodeIds.add(properties._rightChildren[i]);
                ((TreeProperties)properties)._rightChildrenNormalized[i] = ++nodeId;
                continue;
            }
            ((TreeProperties)properties)._rightChildrenNormalized[i] = -1;
        }
        return nodeIds;
    }

    static String getCondition(SharedTreeNode node, String from) {
        StringBuilder sb = new StringBuilder();
        if (node.getDomainValues() != null) {
            sb.append("If (");
            sb.append(node.getColName());
            sb.append(" is in [");
            BitSet inclusiveLevels = from.equals("R") ? node.getLeftChild().getInclusiveLevels() : node.getRightChild().getInclusiveLevels();
            if (inclusiveLevels != null) {
                String stringToParseInclusiveLevelsFrom = inclusiveLevels.toString();
                int inclusiveLevelsLength = stringToParseInclusiveLevelsFrom.length();
                if (inclusiveLevelsLength > 2) {
                    String[] inclusiveLevelsStr;
                    stringToParseInclusiveLevelsFrom = stringToParseInclusiveLevelsFrom.substring(1, inclusiveLevelsLength - 1);
                    for (String level : inclusiveLevelsStr = stringToParseInclusiveLevelsFrom.split(",")) {
                        sb.append(node.getDomainValues()[Integer.parseInt(level.replaceAll("\\s", ""))]).append(" ");
                    }
                }
            } else {
                sb.append(" ");
            }
            sb.append("]) -> ");
        } else if (Float.compare(node.getSplitValue(), Float.NaN) == 0) {
            String sign = "R".equals(from) ? " is not " : " is ";
            sb.append("If ( ").append(node.getColName()).append(sign).append("NaN )");
        } else {
            String sign;
            boolean useNan = false;
            String nanString = " or " + node.getColName() + " is NaN";
            if ("R".equals(from)) {
                sign = " < ";
                if (node.getLeftChild().isInclusiveNa()) {
                    useNan = true;
                }
            } else {
                sign = " >= ";
                if (node.getRightChild().isInclusiveNa()) {
                    useNan = true;
                }
            }
            sb.append("If ( ").append(node.getColName()).append(sign).append(node.getSplitValue());
            if (useNan) {
                sb.append(nanString);
            }
            sb.append(" ) -> ");
        }
        return sb.toString();
    }

    private static List<PathResult> findPaths(SharedTreeNode node) {
        PathResult newResult;
        int i;
        if (node == null) {
            return new ArrayList<PathResult>();
        }
        ArrayList<PathResult> result = new ArrayList<PathResult>();
        List<PathResult> leftSubtree = TreeHandler.findPaths(node.getLeftChild());
        List<PathResult> rightSubtree = TreeHandler.findPaths(node.getRightChild());
        for (i = 0; i < leftSubtree.size(); ++i) {
            PathResult leftResult;
            newResult = leftResult = leftSubtree.get(i);
            newResult.path.insert(0, TreeHandler.getCondition(node, "R"));
            result.add(newResult);
        }
        for (i = 0; i < rightSubtree.size(); ++i) {
            PathResult rightResult;
            newResult = rightResult = rightSubtree.get(i);
            newResult.path.insert(0, TreeHandler.getCondition(node, "L"));
            result.add(newResult);
        }
        if (result.size() == 0) {
            result.add(new PathResult(node.getNodeNumber()));
            ((PathResult)result.get((int)0)).path.append("Prediction: ").append(node.getPredValue());
        }
        return result;
    }

    private static void fillLanguagePathRepresentation(TreeProperties properties, SharedTreeNode root) {
        List<Integer> nodeIds = TreeHandler.extractInternalIds(properties);
        List<PathResult> paths = TreeHandler.findPaths(root);
        for (PathResult path : paths) {
            properties._decisionPaths[nodeIds.indexOf((Object)Integer.valueOf((int)path.nodeId))] = path.path.toString();
        }
    }

    private static void fillnodeDescriptions(SharedTreeNode node, String[] nodeDescriptions, float[] thresholds, String[] splitColumns, int[][] levels, float[] predictions, String[] naHandlings, int pointer, String[][] domainValues) {
        StringBuilder nodeDescriptionBuilder = new StringBuilder();
        int[] nodeLevels = node.getParent().isBitset() ? TreeHandler.extractNodeLevels(node) : null;
        nodeDescriptionBuilder.append("*** WARNING: This property is deprecated! *** ");
        nodeDescriptionBuilder.append("Node has id ");
        nodeDescriptionBuilder.append(node.getNodeNumber());
        if (node.getColName() != null && node.isLeaf()) {
            nodeDescriptionBuilder.append(" and splits on column '");
            nodeDescriptionBuilder.append(node.getColName());
            nodeDescriptionBuilder.append("'. ");
        } else {
            nodeDescriptionBuilder.append(" and is a terminal node. ");
        }
        TreeHandler.fillNodeSplitTowardsChildren(nodeDescriptionBuilder, node);
        if (!Float.isNaN(node.getParent().getSplitValue())) {
            nodeDescriptionBuilder.append(" Parent node split threshold is ");
            nodeDescriptionBuilder.append(node.getParent().getSplitValue());
            nodeDescriptionBuilder.append(". Prediction: ");
            nodeDescriptionBuilder.append(node.getPredValue());
            nodeDescriptionBuilder.append(".");
        } else if (node.getParent().isBitset()) {
            nodeLevels = TreeHandler.extractNodeLevels(node);
            nodeDescriptionBuilder.append(" Parent node split on column [");
            nodeDescriptionBuilder.append(node.getParent().getColName());
            if (nodeLevels != null) {
                nodeDescriptionBuilder.append("]. Inherited categorical levels from parent split: ");
                for (int nodeLevelsindex = 0; nodeLevelsindex < nodeLevels.length; ++nodeLevelsindex) {
                    nodeDescriptionBuilder.append(node.getParent().getDomainValues()[nodeLevels[nodeLevelsindex]]);
                    if (nodeLevelsindex == nodeLevels.length - 1) continue;
                    nodeDescriptionBuilder.append(",");
                }
            } else {
                nodeDescriptionBuilder.append("]. No categoricals levels inherited from parent.");
            }
        } else {
            nodeDescriptionBuilder.append("Split value is NA.");
        }
        nodeDescriptions[pointer] = nodeDescriptionBuilder.toString();
        splitColumns[pointer] = node.getColName();
        naHandlings[pointer] = TreeHandler.getNaDirection(node);
        levels[pointer] = nodeLevels;
        predictions[pointer] = node.getPredValue();
        thresholds[pointer] = node.getSplitValue();
        domainValues[pointer] = node.getDomainValues();
    }

    private static void fillNodeSplitTowardsChildren(StringBuilder nodeDescriptionBuilder, SharedTreeNode node) {
        if (!Float.isNaN(node.getSplitValue())) {
            nodeDescriptionBuilder.append("Split threshold is ");
            if (node.getLeftChild() != null) {
                nodeDescriptionBuilder.append(" < ");
                nodeDescriptionBuilder.append(node.getSplitValue());
                nodeDescriptionBuilder.append(" to the left node (");
                nodeDescriptionBuilder.append(node.getLeftChild().getNodeNumber());
                nodeDescriptionBuilder.append(")");
            }
            if (node.getLeftChild() != null) {
                if (node.getLeftChild() != null) {
                    nodeDescriptionBuilder.append(", ");
                }
                nodeDescriptionBuilder.append(" >= ");
                nodeDescriptionBuilder.append(node.getSplitValue());
                nodeDescriptionBuilder.append(" to the right node (");
                nodeDescriptionBuilder.append(node.getRightChild().getNodeNumber());
                nodeDescriptionBuilder.append(")");
            }
            nodeDescriptionBuilder.append(".");
        } else if (node.isBitset()) {
            TreeHandler.fillNodeCategoricalSplitDescription(nodeDescriptionBuilder, node);
        }
    }

    private static int[] extractNodeLevels(SharedTreeNode node) {
        BitSet childInclusiveLevels = node.getInclusiveLevels();
        int cardinality = childInclusiveLevels.cardinality();
        if (cardinality > 0) {
            int[] nodeLevels = MemoryManager.malloc4(cardinality);
            int bitsignCounter = 0;
            int i = childInclusiveLevels.nextSetBit(0);
            while (i >= 0) {
                nodeLevels[bitsignCounter] = i;
                ++bitsignCounter;
                i = childInclusiveLevels.nextSetBit(i + 1);
            }
            return nodeLevels;
        }
        return null;
    }

    private static void fillNodeCategoricalSplitDescription(StringBuilder nodeDescriptionBuilder, SharedTreeNode node) {
        int nodeLevelsindex;
        SharedTreeNode leftChild = node.getLeftChild();
        SharedTreeNode rightChild = node.getRightChild();
        int[] leftChildLevels = TreeHandler.extractNodeLevels(leftChild);
        int[] rightChildLevels = TreeHandler.extractNodeLevels(rightChild);
        if (leftChild != null) {
            nodeDescriptionBuilder.append(" Left child node (");
            nodeDescriptionBuilder.append(leftChild.getNodeNumber());
            nodeDescriptionBuilder.append(") inherits categorical levels: ");
            if (leftChildLevels != null) {
                for (nodeLevelsindex = 0; nodeLevelsindex < leftChildLevels.length; ++nodeLevelsindex) {
                    nodeDescriptionBuilder.append(node.getDomainValues()[leftChildLevels[nodeLevelsindex]]);
                    if (nodeLevelsindex == leftChildLevels.length - 1) continue;
                    nodeDescriptionBuilder.append(",");
                }
            }
        }
        if (rightChild != null) {
            nodeDescriptionBuilder.append(". Right child node (");
            nodeDescriptionBuilder.append(rightChild.getNodeNumber());
            nodeDescriptionBuilder.append(") inherits categorical levels: ");
            if (rightChildLevels != null) {
                for (nodeLevelsindex = 0; nodeLevelsindex < rightChildLevels.length; ++nodeLevelsindex) {
                    nodeDescriptionBuilder.append(node.getDomainValues()[rightChildLevels[nodeLevelsindex]]);
                    if (nodeLevelsindex == rightChildLevels.length - 1) continue;
                    nodeDescriptionBuilder.append(",");
                }
            }
        }
        nodeDescriptionBuilder.append(". ");
    }

    private static String getNaDirection(SharedTreeNode node) {
        boolean rightNa;
        boolean leftNa = node.getLeftChild() != null && node.getLeftChild().isInclusiveNa();
        boolean bl = rightNa = node.getRightChild() != null && node.getRightChild().isInclusiveNa();
        assert (rightNa ^ leftNa || !rightNa && !leftNa);
        if (leftNa) {
            return "LEFT";
        }
        if (rightNa) {
            return "RIGHT";
        }
        return null;
    }

    public static class TreeProperties {
        public int[] _leftChildren;
        public int[] _rightChildren;
        public String[] _descriptions;
        public float[] _thresholds;
        public String[] _features;
        public int[][] levels;
        public String[] _nas;
        public float[] _predictions;
        public String _treeDecisionPath;
        public String[] _leafNodeAssignments;
        public String[] _decisionPaths;
        private int[] _leftChildrenNormalized;
        private int[] _rightChildrenNormalized;
        private String[][] _domainValues;

        static /* synthetic */ int[] access$002(TreeProperties x0, int[] x1) {
            x0._leftChildrenNormalized = x1;
            return x1;
        }

        static /* synthetic */ int[] access$102(TreeProperties x0, int[] x1) {
            x0._rightChildrenNormalized = x1;
            return x1;
        }

        static /* synthetic */ String[][] access$202(TreeProperties x0, String[][] x1) {
            x0._domainValues = x1;
            return x1;
        }
    }

    public static enum PlainLanguageRules {
        AUTO,
        TRUE,
        FALSE;

    }
}

