/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.isoforextended;

import hex.Model;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.genmodel.algos.isoforextended.ExtendedIsolationForestMojoModel;
import hex.tree.isofor.ModelMetricsAnomaly;
import hex.tree.isoforextended.ExtendedIsolationForest;
import hex.tree.isoforextended.ExtendedIsolationForestMojoWriter;
import hex.tree.isoforextended.isolationtree.CompressedIsolationTree;
import org.apache.log4j.Logger;
import water.AutoBuffer;
import water.DKV;
import water.Futures;
import water.Key;
import water.Keyed;
import water.fvec.Frame;

public class ExtendedIsolationForestModel
extends Model<ExtendedIsolationForestModel, ExtendedIsolationForestParameters, ExtendedIsolationForestOutput> {
    private static final Logger LOG = Logger.getLogger(ExtendedIsolationForestModel.class);

    public ExtendedIsolationForestModel(Key<ExtendedIsolationForestModel> selfKey, ExtendedIsolationForestParameters parms, ExtendedIsolationForestOutput output) {
        super(selfKey, parms, output);
    }

    @Override
    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        return new ModelMetricsAnomaly.MetricBuilderAnomaly("Extended Isolation Forest Metrics", false);
    }

    @Override
    protected String[] makeScoringNames() {
        return new String[]{"anomaly_score", "mean_length"};
    }

    @Override
    protected String[][] makeScoringDomains(Frame adaptFrm, boolean computeMetrics, String[] names) {
        assert (names.length == 2);
        return new String[2][];
    }

    @Override
    protected double[] score0(double[] data, double[] preds) {
        assert (((ExtendedIsolationForestOutput)this._output)._iTreeKeys != null) : "Output has no trees, check if trees are properly set to the output.";
        double pathLength = 0.0;
        for (Key<CompressedIsolationTree> iTreeKey : ((ExtendedIsolationForestOutput)this._output)._iTreeKeys) {
            CompressedIsolationTree iTree = (CompressedIsolationTree)DKV.getGet(iTreeKey);
            double iTreeScore = iTree.computePathLength(data);
            pathLength += iTreeScore;
            LOG.trace("iTreeScore " + iTreeScore);
        }
        LOG.trace("Path length " + (pathLength /= (double)((ExtendedIsolationForestOutput)this._output)._ntrees));
        double anomalyScore = ExtendedIsolationForestMojoModel.anomalyScore(pathLength, ((ExtendedIsolationForestOutput)this._output)._sample_size);
        LOG.trace("Anomaly score " + anomalyScore);
        preds[0] = anomalyScore;
        preds[1] = pathLength;
        return preds;
    }

    @Override
    protected Futures remove_impl(Futures fs, boolean cascade) {
        for (Key<CompressedIsolationTree> iTreeKey : ((ExtendedIsolationForestOutput)this._output)._iTreeKeys) {
            Keyed.remove(iTreeKey, fs, true);
        }
        return super.remove_impl(fs, cascade);
    }

    @Override
    protected AutoBuffer writeAll_impl(AutoBuffer ab) {
        for (Key<CompressedIsolationTree> iTreeKey : ((ExtendedIsolationForestOutput)this._output)._iTreeKeys) {
            ab.putKey(iTreeKey);
        }
        return super.writeAll_impl(ab);
    }

    @Override
    protected Keyed readAll_impl(AutoBuffer ab, Futures fs) {
        for (Key<CompressedIsolationTree> iTreeKey : ((ExtendedIsolationForestOutput)this._output)._iTreeKeys) {
            ab.getKey(iTreeKey, fs);
        }
        return super.readAll_impl(ab, fs);
    }

    @Override
    public ExtendedIsolationForestMojoWriter getMojo() {
        return new ExtendedIsolationForestMojoWriter(this);
    }

    public static class ExtendedIsolationForestOutput
    extends Model.Output {
        public int _ntrees;
        public long _sample_size;
        public Key<CompressedIsolationTree>[] _iTreeKeys;

        public ExtendedIsolationForestOutput(ExtendedIsolationForest eif) {
            super(eif);
            this._ntrees = ((ExtendedIsolationForestParameters)eif._parms)._ntrees;
            this._sample_size = ((ExtendedIsolationForestParameters)eif._parms)._sample_size;
        }

        @Override
        public ModelCategory getModelCategory() {
            return ModelCategory.AnomalyDetection;
        }
    }

    public static class ExtendedIsolationForestParameters
    extends Model.Parameters {
        public int _ntrees = 100;
        public int _extension_level = 0;
        public int _sample_size = 256;

        @Override
        public String algoName() {
            return "ExtendedIsolationForest";
        }

        @Override
        public String fullName() {
            return "Extended Isolation Forest";
        }

        @Override
        public String javaName() {
            return ExtendedIsolationForestModel.class.getName();
        }

        @Override
        public long progressUnits() {
            return this._ntrees;
        }
    }
}

