/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.cleaners;

import java.text.Normalizer;
import no.priv.garshol.duke.Cleaner;

public class LowerCaseNormalizeCleaner
implements Cleaner {
    private boolean strip_accents = true;

    public void setStripAccents(boolean strip_accents) {
        this.strip_accents = strip_accents;
    }

    @Override
    public String clean(String value) {
        if (this.strip_accents) {
            value = Normalizer.normalize(value, Normalizer.Form.NFD);
        }
        char[] tmp = new char[value.length()];
        int pos = 0;
        boolean prevws = false;
        for (int ix = 0; ix < tmp.length; ++ix) {
            char ch = value.charAt(ix);
            if (ch == '\u030a' && (value.charAt(ix - 1) == 'a' || value.charAt(ix - 1) == 'A')) {
                prevws = false;
                tmp[pos - 1] = 229;
                continue;
            }
            if (ch >= '\u0300' && ch <= '\u036f' || ch >= '\u1dc0' && ch <= '\u1dff' || ch >= '\u20d0' && ch <= '\u20ff' || ch >= '\ufe20' && ch <= '\ufe2f') continue;
            if (ch != ' ' && ch != '\t' && ch != '\n' && ch != '\r') {
                if (prevws && pos != 0) {
                    tmp[pos++] = 32;
                }
                tmp[pos++] = Character.toLowerCase(ch);
                prevws = false;
                continue;
            }
            prevws = true;
        }
        return new String(tmp, 0, pos);
    }
}

