/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.databases;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import no.priv.garshol.duke.Record;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;

public class DocumentRecord
implements Record {
    private int docno;
    private Document doc;

    public DocumentRecord(int docno, Document doc) {
        this.docno = docno;
        this.doc = doc;
    }

    @Override
    public Collection<String> getProperties() {
        HashSet<String> props = new HashSet<String>();
        for (IndexableField f : this.doc.getFields()) {
            props.add(f.name());
        }
        return props;
    }

    @Override
    public String getValue(String prop) {
        return this.doc.get(prop);
    }

    @Override
    public Collection<String> getValues(String prop) {
        IndexableField[] fields = this.doc.getFields(prop);
        if (fields.length == 1) {
            return Collections.singleton(fields[0].stringValue());
        }
        ArrayList<String> values = new ArrayList<String>(fields.length);
        for (int ix = 0; ix < fields.length; ++ix) {
            values.add(fields[ix].stringValue());
        }
        return values;
    }

    @Override
    public void merge(Record other) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "[DocumentRecord " + this.docno + " " + this.doc + "]";
    }

    public int hashCode() {
        return this.docno;
    }

    public boolean equals(Object other) {
        if (!(other instanceof DocumentRecord)) {
            return false;
        }
        return ((DocumentRecord)other).docno == this.docno;
    }
}

