/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import no.priv.garshol.duke.DukeConfigException;
import no.priv.garshol.duke.DukeException;
import no.priv.garshol.duke.utils.StringUtils;

public class ObjectUtils {
    public static Object getEnumConstantByName(Class klass, String name) {
        name = name.toUpperCase();
        T[] c = klass.getEnumConstants();
        for (int ix = 0; ix < c.length; ++ix) {
            if (!c[ix].toString().equals(name)) continue;
            return c[ix];
        }
        throw new DukeConfigException("No such " + klass + ": '" + name + "'");
    }

    public static void setBeanProperty(Object object, String prop, String value, Map<String, Object> objects) {
        prop = ObjectUtils.makePropertyName(prop);
        try {
            boolean found = false;
            Method[] methods = object.getClass().getMethods();
            for (int ix = 0; ix < methods.length && !found; ++ix) {
                if (!methods[ix].getName().equals(prop) || methods[ix].getParameterTypes().length != 1) continue;
                Class<?> type = methods[ix].getParameterTypes()[0];
                methods[ix].invoke(object, ObjectUtils.convertToType(value, type, objects));
                found = true;
            }
            if (!found) {
                throw new DukeConfigException("Couldn't find method '" + prop + "' in " + "class " + object.getClass());
            }
        }
        catch (IllegalArgumentException e) {
            throw new DukeConfigException("Couldn't set bean property " + prop + " on object of class " + object.getClass() + ": " + e);
        }
        catch (IllegalAccessException e) {
            throw new DukeException(e);
        }
        catch (InvocationTargetException e) {
            throw new DukeConfigException("Couldn't set bean property " + prop + " on object of class " + object.getClass() + ": " + e);
        }
    }

    public static String makePropertyName(String name) {
        char[] buf = new char[name.length() + 3];
        int pos = 0;
        buf[pos++] = 115;
        buf[pos++] = 101;
        buf[pos++] = 116;
        for (int ix = 0; ix < name.length(); ++ix) {
            char ch = name.charAt(ix);
            if (ix == 0) {
                ch = Character.toUpperCase(ch);
            } else if (ch == '-') {
                if (++ix == name.length()) break;
                ch = Character.toUpperCase(name.charAt(ix));
            }
            buf[pos++] = ch;
        }
        return new String(buf, 0, pos);
    }

    private static Object convertToType(String value, Class type, Map<String, Object> objects) {
        if (type == String.class) {
            return value;
        }
        if (type == Integer.TYPE) {
            return Integer.parseInt(value);
        }
        if (type == Boolean.TYPE) {
            return Boolean.parseBoolean(value);
        }
        if (type == Double.TYPE) {
            return Double.parseDouble(value);
        }
        if (type == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (type == Character.TYPE) {
            if (value.length() != 1) {
                throw new DukeConfigException("String '" + value + "' is not a character");
            }
            return new Character(value.charAt(0));
        }
        if (type.isEnum()) {
            return ObjectUtils.getEnumConstantByName(type, value);
        }
        if (type.equals(Collection.class)) {
            ArrayList<Object> coll = new ArrayList<Object>();
            String[] values = StringUtils.split(value);
            for (int ix = 0; ix < values.length; ++ix) {
                Object object = objects.get(values[ix]);
                if (object == null) {
                    object = values[ix];
                }
                coll.add(object);
            }
            return coll;
        }
        Object object = objects.get(value);
        if (object != null) {
            return object;
        }
        return value;
    }

    public static Object instantiate(String klassname) {
        try {
            Class<?> klass = Class.forName(klassname);
            return klass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

