/*
 * Decompiled with CFR 0.152.
 */
package water;

import water.DKV;
import water.DTask;
import water.Futures;
import water.H2O;
import water.Key;
import water.RPC;
import water.Value;

public abstract class Atomic<T extends Atomic>
extends DTask<T> {
    protected Key _key;

    public Atomic() {
        super((byte)120);
    }

    public Atomic(H2O.H2OCountedCompleter completer) {
        super(completer, (byte)120);
    }

    protected abstract Value atomic(Value var1);

    protected void onSuccess(Value old) {
    }

    public final Atomic<T> invoke(Key key) {
        RPC<Atomic<T>> rpc = this.fork(key);
        return rpc == null ? this : (Atomic)rpc.get();
    }

    public final RPC<Atomic<T>> fork(Key key) {
        this._key = key;
        if (key.home()) {
            this.compute2();
            return null;
        }
        return RPC.call(key.home_node(), this);
    }

    @Override
    public final void compute2() {
        assert (this._key.home()) : "Atomic on wrong node; SELF=" + H2O.SELF + ", key_home=" + this._key.home_node() + ", key_is_home=" + this._key.home() + ", class=" + this.getClass();
        Futures fs = new Futures();
        Value val1 = DKV.get(this._key);
        while (true) {
            Value val2;
            if ((val2 = this.atomic(val1)) == null) {
                if (val1 == null) break;
                val1.blockTillNoReaders();
                break;
            }
            assert (val1 != val2);
            Value res = DKV.DputIfMatch(this._key, val2, val1, fs);
            if (res == val1) {
                fs.blockForPending();
                this.onSuccess(val1);
                break;
            }
            val1 = res;
        }
        this._key = null;
        this.tryComplete();
    }
}

