/*
 * Decompiled with CFR 0.152.
 */
package water;

import water.AutoBuffer;
import water.H2O;
import water.HeartBeat;
import water.Paxos;
import water.UDP;

class UDPHeartbeat
extends UDP {
    UDPHeartbeat() {
    }

    @Override
    AutoBuffer call(AutoBuffer ab) {
        if (ab._h2o != H2O.SELF) {
            HeartBeat hb = (HeartBeat)new HeartBeat().read(ab);
            if (hb._cloud_name_hash != H2O.SELF._heartbeat._cloud_name_hash) {
                return ab;
            }
            assert (ab._h2o != null);
            ab._h2o.setHeartBeat(hb);
            Paxos.doHeartbeat(ab._h2o);
        }
        return ab;
    }

    static void build_and_multicast(H2O cloud, HeartBeat hb) {
        assert (hb._cloud_hash != 0 || hb._client);
        H2O.SELF._heartbeat = hb;
        hb.write(new AutoBuffer(H2O.SELF, UDP.udp.heartbeat._prior).putUdp(UDP.udp.heartbeat)).close();
    }
}

