/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.fvec.Chunk;
import water.fvec.ChunkVisitor;

public class C1Chunk
extends Chunk {
    protected static final int _OFF = 0;
    protected static final int _NA = 255;

    C1Chunk(byte[] bs) {
        this._mem = bs;
        this._start = -1L;
        this.set_len(this._mem.length);
    }

    @Override
    protected final long at8_impl(int i) {
        long res = 0xFF & this._mem[i + 0];
        if (res == 255L) {
            throw new IllegalArgumentException("at8_abs but value is missing");
        }
        return res;
    }

    @Override
    protected final double atd_impl(int i) {
        long res = 0xFF & this._mem[i + 0];
        return res == 255L ? Double.NaN : (double)res;
    }

    @Override
    protected final boolean isNA_impl(int i) {
        return (0xFF & this._mem[i + 0]) == 255;
    }

    @Override
    boolean set_impl(int i, long l) {
        if (0L > l || l >= 255L) {
            return false;
        }
        this._mem[i + 0] = (byte)l;
        return true;
    }

    @Override
    boolean set_impl(int i, double d) {
        return false;
    }

    @Override
    boolean set_impl(int i, float f) {
        return false;
    }

    @Override
    boolean setNA_impl(int idx) {
        this._mem[idx + 0] = -1;
        return true;
    }

    @Override
    public void initFromBytes() {
        this._start = -1L;
        this._cidx = -1;
        this.set_len(this._mem.length);
    }

    private final void processRow(int r, ChunkVisitor v) {
        int i = 0xFF & this._mem[r + 0];
        if (i == 255) {
            v.addNAs(1);
        } else {
            v.addValue(i);
        }
    }

    @Override
    public <T extends ChunkVisitor> T processRows(T v, int from, int to) {
        for (int i = from; i < to; ++i) {
            this.processRow(i, v);
        }
        return v;
    }

    @Override
    public <T extends ChunkVisitor> T processRows(T v, int[] ids) {
        for (int i : ids) {
            this.processRow(i, v);
        }
        return v;
    }

    @Override
    public int[] getIntegers(int[] vals, int from, int to, int NA) {
        for (int i = from; i < to; ++i) {
            int x = 0xFF & this._mem[i];
            vals[i - from] = x == 255 ? NA : x;
        }
        return vals;
    }

    @Override
    public double[] getDoubles(double[] vals, int from, int to, double NA) {
        for (int i = from; i < to; ++i) {
            int x = 0xFF & this._mem[i];
            vals[i - from] = x == 255 ? NA : (double)x;
        }
        return vals;
    }

    @Override
    public double[] getDoubles(double[] vals, int[] ids) {
        int k = 0;
        for (int i : ids) {
            int x = 0xFF & this._mem[i];
            vals[k++] = x == 255 ? Double.NaN : (double)x;
        }
        return vals;
    }

    @Override
    public boolean hasFloat() {
        return false;
    }
}

