/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.fvec.CSChunk;
import water.fvec.ChunkVisitor;
import water.util.PrettyPrint;

public final class C1SChunk
extends CSChunk {
    C1SChunk(byte[] bs, long bias, int scale) {
        super(bs, bias, scale, 0);
        if (scale < 0) {
            double div = PrettyPrint.pow10(1L, -scale);
            for (int i = 0; i < this._len; ++i) {
                int x = 0xFF & this._mem[16 + i];
                if (x == 255 || this.getD(x, 255, Double.NaN) == (double)((long)x + bias) / div) continue;
                this.setDecimal();
                break;
            }
        }
    }

    @Override
    protected final long at8_impl(int i) {
        int x = 0xFF & this._mem[16 + i];
        if (x == 255) {
            throw new IllegalArgumentException("at8_abs but value is missing");
        }
        return this.get8(x);
    }

    @Override
    protected final double atd_impl(int i) {
        return this.getD(0xFF & this._mem[16 + i], 255);
    }

    @Override
    protected final boolean isNA_impl(int i) {
        return (0xFF & this._mem[i + 16]) == 255;
    }

    @Override
    boolean setNA_impl(int idx) {
        this._mem[idx + 16] = -1;
        return true;
    }

    @Override
    protected boolean set_impl(int i, double x) {
        if (Double.isNaN(x)) {
            return this.setNA_impl(i);
        }
        int y = this.getScaledValue(x, 255);
        byte b = (byte)y;
        if (this.getD(0xFF & b, 255, Double.NaN) != x) {
            return false;
        }
        this._mem[16 + i] = b;
        assert (!this.isNA_impl(i));
        return true;
    }

    @Override
    public double[] getDoubles(double[] vals, int from, int to, double NA) {
        for (int i = from; i < to; ++i) {
            vals[i - from] = this.getD(0xFF & this._mem[16 + i], 255, NA);
        }
        return vals;
    }

    @Override
    public double[] getDoubles(double[] vals, int[] ids) {
        int j = 0;
        for (int i : ids) {
            vals[j++] = this.getD(0xFF & this._mem[16 + i], 255);
        }
        return vals;
    }

    private <T extends ChunkVisitor> void processRow(T v, int i, long bias, int exp) {
        long x = 0xFF & this._mem[16 + i];
        if (x == 255L) {
            v.addNAs(1);
        } else {
            v.addValue(x + bias, exp);
        }
    }

    @Override
    protected <T extends ChunkVisitor> T processRows2(T v, int from, int to, long bias, int exp) {
        for (int i = from; i < to; ++i) {
            this.processRow(v, i, bias, exp);
        }
        return v;
    }

    @Override
    protected <T extends ChunkVisitor> T processRows2(T v, int from, int to) {
        for (int i = from; i < to; ++i) {
            v.addValue(this.getD(0xFF & this._mem[16 + i], 255));
        }
        return v;
    }

    @Override
    protected <T extends ChunkVisitor> T processRows2(T v, int[] ids, long bias, int exp) {
        for (int i : ids) {
            this.processRow(v, i, bias, exp);
        }
        return v;
    }

    @Override
    protected <T extends ChunkVisitor> T processRows2(T v, int[] ids) {
        for (int i : ids) {
            v.addValue(this.getD(0xFF & this._mem[16 + i], 255));
        }
        return v;
    }
}

