/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.H2O;
import water.fvec.CXIChunk;
import water.fvec.Chunk;
import water.fvec.ChunkVisitor;
import water.util.UnsafeUtils;

public class CXFChunk
extends CXIChunk {
    protected CXFChunk(byte[] mem) {
        super(mem);
    }

    private double getVal(int x) {
        switch (this._elem_sz) {
            case 8: {
                return UnsafeUtils.get4f(this._mem, x + 4);
            }
            case 12: {
                return UnsafeUtils.get8d(this._mem, x + 4);
            }
        }
        throw H2O.unimpl();
    }

    @Override
    public long at8_impl(int idx) {
        int x = this.findOffset(idx);
        if (x < 0) {
            if (this._isNA) {
                throw new RuntimeException("at4 but the value is missing!");
            }
            return 0L;
        }
        double val = this.getVal(x);
        if (Double.isNaN(val)) {
            throw new RuntimeException("at4 but the value is missing!");
        }
        return (long)val;
    }

    @Override
    public double atd_impl(int idx) {
        int x = this.findOffset(idx);
        if (x < 0) {
            return this._isNA ? Double.NaN : 0.0;
        }
        return this.getVal(x);
    }

    @Override
    public Chunk deepCopy() {
        return new CXFChunk((byte[])this._mem.clone());
    }

    @Override
    public <T extends ChunkVisitor> T processRows(T v, int from, int to) {
        int id;
        int x;
        int prevId = from - 1;
        int n = x = from == 0 ? 8 : this.findOffset(from);
        if (x < 0) {
            x = -x - 1;
        }
        while (x < this._mem.length && (id = this.getId(x)) < to) {
            if (this._isNA) {
                v.addNAs(id - prevId - 1);
            } else {
                v.addZeros(id - prevId - 1);
            }
            v.addValue(this.getVal(x));
            prevId = id;
            x += this._elem_sz;
        }
        if (this._isNA) {
            v.addNAs(to - prevId - 1);
        } else {
            v.addZeros(to - prevId - 1);
        }
        return v;
    }

    @Override
    public <T extends ChunkVisitor> T processRows(T v, int[] ids) {
        int x = 8;
        int zeros = 0;
        for (int k = 0; k < ids.length; ++k) {
            int idk = ids[k];
            assert (ids[k] >= 0 && (k == 0 || ids[k] > ids[k - 1]));
            int idx = ids[ids.length - 1] + 1;
            while (x < this._mem.length && (idx = this.getId(x)) < idk) {
                x += this._elem_sz;
            }
            if (x == this._mem.length) {
                zeros += ids.length - k;
                break;
            }
            if (idx == idk) {
                if (this._isNA) {
                    v.addNAs(zeros);
                } else {
                    v.addZeros(zeros);
                }
                v.addValue(this.getVal(x));
                zeros = 0;
                x += this._elem_sz;
                continue;
            }
            ++zeros;
        }
        if (zeros > 0) {
            if (this._isNA) {
                v.addNAs(zeros);
            } else {
                v.addZeros(zeros);
            }
        }
        return v;
    }

    @Override
    public boolean hasFloat() {
        return true;
    }
}

