/*
 * Decompiled with CFR 0.152.
 */
package water.fvec.persist;

import java.net.URI;
import jsr166y.CountedCompleter;
import water.AutoBuffer;
import water.DKV;
import water.Freezable;
import water.Futures;
import water.H2O;
import water.Iced;
import water.Job;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.TypeMap;
import water.Value;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.fvec.persist.PersistUtils;
import water.util.FileUtils;

public class FramePersist {
    private final Frame frame;

    public FramePersist(Frame frame) {
        this.frame = frame;
    }

    private static URI getMetaUri(Key key, String dest) {
        return FileUtils.getURI(dest + "/" + key);
    }

    private static URI getDataUri(String metaUri, int cidx) {
        return FileUtils.getURI(metaUri + "_n" + H2O.SELF.index() + "_c" + cidx);
    }

    private SaveFrameDriver setupDriver(String uri, boolean overwrite) {
        URI metaUri = FramePersist.getMetaUri(this.frame._key, PersistUtils.sanitizeUri(uri));
        if (PersistUtils.exists(metaUri) && !overwrite) {
            throw new IllegalArgumentException("File already exists at " + metaUri);
        }
        FrameMeta frameMeta = new FrameMeta(this.frame);
        PersistUtils.write(metaUri, ab -> ab.put(frameMeta));
        Job<Frame> job = new Job<Frame>(this.frame._key, "water.fvec.Frame", "Save frame");
        return new SaveFrameDriver(job, this.frame, metaUri);
    }

    public Job<Frame> saveTo(String uri, boolean overwrite) {
        SaveFrameDriver driver = this.setupDriver(uri, overwrite);
        return driver.job.start(driver, this.frame.anyVec().nChunks());
    }

    public String[] saveToAndWait(String uri, boolean overwrite) {
        SaveFrameDriver driver = this.setupDriver(uri, overwrite);
        driver.job.start(driver, this.frame.anyVec().nChunks());
        driver.job.get();
        String[] allWrittenFiles = new String[driver.task.writtenFiles.length + 1];
        allWrittenFiles[0] = driver.metaUri.toString();
        System.arraycopy(driver.task.writtenFiles, 0, allWrittenFiles, 1, driver.task.writtenFiles.length);
        return allWrittenFiles;
    }

    public static Job<Frame> loadFrom(Key<Frame> key, String uri) {
        URI metaUri = FramePersist.getMetaUri(key, PersistUtils.sanitizeUri(uri));
        FrameMeta meta = PersistUtils.read(metaUri, AutoBuffer::get);
        if (meta.numNodes != H2O.CLOUD.size()) {
            throw new IllegalArgumentException("To load this frame a cluster with " + meta.numNodes + " nodes is needed.");
        }
        Job<Frame> job = new Job<Frame>(meta.key, "water.fvec.Frame", "Load frame");
        return job.start(new LoadFrameDriver(job, metaUri.toString(), meta), meta.espc.length - 1);
    }

    static {
        TypeMap.onIce(FrameMeta.class.getName());
    }

    static class LoadChunksTask
    extends MRTask<LoadChunksTask> {
        private final Job<Frame> job;
        private final String metaUri;
        private final Key[] vecKeys;

        LoadChunksTask(Job<Frame> job, String metaUri, Key[] vecKeys) {
            this.job = job;
            this.metaUri = metaUri;
            this.vecKeys = vecKeys;
        }

        @Override
        public void map(Chunk c) {
            PersistUtils.read(FramePersist.getDataUri(this.metaUri, c.cidx()), ab -> this.readChunks(ab, c.cidx()));
            this.job.update(1L);
        }

        private int readChunks(AutoBuffer autoBuffer, int cidx) {
            for (Key k : this.vecKeys) {
                Key chunkKey = Vec.chunkKey(k, cidx);
                Chunk chunk = (Chunk)autoBuffer.get();
                DKV.put(chunkKey, new Value(chunkKey, (Freezable)chunk));
            }
            return this.vecKeys.length;
        }
    }

    public static class LoadFrameDriver
    extends H2O.H2OCountedCompleter<LoadFrameDriver> {
        private final Job<Frame> job;
        private final String metaUri;
        private final FrameMeta meta;

        public LoadFrameDriver(Job<Frame> job, String metaUri, FrameMeta meta) {
            this.job = job;
            this.metaUri = metaUri;
            this.meta = meta;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void compute2() {
            Keyed con = null;
            Key[] vecKeys = new Vec.VectorGroup().addVecs(this.meta.vecs.length);
            try {
                long nrow = this.meta.espc[this.meta.espc.length - 1];
                int nchunk = this.meta.espc.length - 1;
                con = Vec.makeConN(nrow, nchunk);
                ((LoadChunksTask)new LoadChunksTask(this.job, this.metaUri, vecKeys).doAll(new Vec[]{con})).join();
            }
            finally {
                if (con != null) {
                    con.remove();
                }
            }
            int rowLayout = Vec.ESPC.rowLayout(vecKeys[0], this.meta.espc);
            Futures fs = new Futures();
            for (int i = 0; i < this.meta.vecs.length; ++i) {
                Vec v = this.meta.vecs[i];
                v._rowLayout = rowLayout;
                v._key = vecKeys[i];
                DKV.put(v, fs);
            }
            fs.blockForPending();
            Frame frame = new Frame(this.meta.key, this.meta.names, this.meta.vecs);
            DKV.put(frame);
            this.tryComplete();
        }
    }

    static class SaveChunksTask
    extends MRTask<SaveChunksTask> {
        private final Job<Frame> job;
        private final String metaUri;
        public String[] writtenFiles;

        SaveChunksTask(Job<Frame> job, Frame frame, String metaUri) {
            this.job = job;
            this.metaUri = metaUri;
            this.writtenFiles = new String[frame.anyVec().nChunks()];
        }

        @Override
        public void map(Chunk[] cs) {
            URI dataUri = FramePersist.getDataUri(this.metaUri, cs[0].cidx());
            this.writtenFiles[cs[0].cidx()] = dataUri.toString();
            PersistUtils.write(dataUri, ab -> this.writeChunks(ab, cs));
            this.job.update(1L);
        }

        private void writeChunks(AutoBuffer autoBuffer, Chunk[] chunks) {
            for (Chunk c : chunks) {
                autoBuffer.put(c);
            }
        }

        @Override
        public void reduce(SaveChunksTask mrt) {
            for (int i = 0; i < this.writtenFiles.length; ++i) {
                if (mrt.writtenFiles[i] == null) continue;
                assert (this.writtenFiles[i] == null || this.writtenFiles[i].equals(mrt.writtenFiles[i])) : "When merging written files expecting " + this.writtenFiles[i] + " to be null or equal to " + mrt.writtenFiles[i];
                this.writtenFiles[i] = mrt.writtenFiles[i];
            }
        }
    }

    public static class SaveFrameDriver
    extends H2O.H2OCountedCompleter<LoadFrameDriver> {
        private final Job<Frame> job;
        private final Frame frame;
        public final URI metaUri;
        public final SaveChunksTask task;

        public SaveFrameDriver(Job<Frame> job, Frame frame, URI metaUri) {
            this.job = job;
            this.frame = frame;
            this.metaUri = metaUri;
            this.task = new SaveChunksTask(job, frame, metaUri.toString());
        }

        @Override
        public void compute2() {
            this.frame.read_lock(this.job._key);
            ((SaveChunksTask)this.task.doAll(this.frame)).join();
            this.tryComplete();
        }

        @Override
        public void onCompletion(CountedCompleter caller) {
            this.frame.unlock(this.job);
        }

        @Override
        public boolean onExceptionalCompletion(Throwable t, CountedCompleter caller) {
            this.frame.unlock(this.job);
            return super.onExceptionalCompletion(t, caller);
        }
    }

    private static class FrameMeta
    extends Iced<FrameMeta> {
        Key<Frame> key;
        String[] names;
        Vec[] vecs;
        long[] espc;
        int numNodes;

        FrameMeta(Frame f) {
            this.key = f._key;
            this.names = f.names();
            this.vecs = f.vecs();
            this.espc = f.anyVec().espc();
            this.numNodes = H2O.CLOUD.size();
        }
    }
}

