/*
 * Decompiled with CFR 0.152.
 */
package water.fvec.task;

import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Vec;
import water.util.IcedDouble;
import water.util.IcedHashSet;

public class UniqTask
extends MRTask<UniqTask> {
    private IcedHashSet<IcedDouble> _uniq;
    private boolean _na;

    @Override
    public void map(Chunk[] c) {
        this._uniq = new IcedHashSet();
        double prev = Double.NaN;
        for (int i = 0; i < c[0]._len; ++i) {
            double val = c[0].atd(i);
            if (Double.isNaN(val)) {
                this._na = true;
                continue;
            }
            if (val == prev) continue;
            prev = val;
            this._uniq.addIfAbsent(new IcedDouble(val));
        }
    }

    @Override
    public void reduce(UniqTask t) {
        IcedHashSet<IcedDouble> l = this._uniq;
        IcedHashSet<IcedDouble> r = t._uniq;
        if (l.size() < r.size()) {
            l = r;
            r = this._uniq;
        }
        for (IcedDouble rg : r) {
            l.addIfAbsent(rg);
        }
        this._uniq = l;
        this._na = this._na || t._na;
        t._uniq = null;
    }

    public double[] toArray() {
        int size = this._uniq.size();
        double[] res = new double[size + (this._na ? 1 : 0)];
        int i = 0;
        if (this._na) {
            res[i++] = Double.NaN;
        }
        for (IcedDouble d : this._uniq) {
            res[i++] = d._val;
        }
        assert (i == res.length);
        return res;
    }

    public Vec toVec() {
        final double[] uniq = this.toArray();
        Vec v = Vec.makeZero((long)uniq.length, this._fr.vec(0).get_type());
        new MRTask(){

            @Override
            public void map(Chunk c) {
                int start = (int)c.start();
                for (int i = 0; i < c._len; ++i) {
                    c.set(i, uniq[i + start]);
                }
            }
        }.doAll(v);
        return v;
    }
}

