/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.mungers;

import java.util.Arrays;
import water.Iced;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.Env;
import water.rapids.ast.AstParameter;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.ast.params.AstNum;
import water.rapids.ast.params.AstNumList;
import water.rapids.vals.ValFrame;

public class AstRankWithinGroupBy
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"frame", "groupby_cols", "sort_cols", "sort_orders", "new_colname", "sort_cols_order"};
    }

    @Override
    public String str() {
        return "rank_within_groupby";
    }

    @Override
    public int nargs() {
        return 7;
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        int[] groupbycols = ((AstParameter)asts[2]).columns(fr.names());
        int[] sortcols = ((AstParameter)asts[3]).columns(fr.names());
        int[] sortAsc = asts[4] instanceof AstNumList ? ((AstNumList)asts[4]).expand4() : new int[]{(int)((AstNum)asts[4]).getNum()};
        String newcolname = asts[5].str();
        Boolean sortColsOrder = ((AstNum)asts[6]).getNum() == 1.0;
        assert (sortAsc.length == sortcols.length);
        SortnGrouby sortgroupbyrank = new SortnGrouby(fr, groupbycols, sortcols, sortAsc, newcolname);
        sortgroupbyrank.doAll(sortgroupbyrank._groupedSortedOut);
        RankGroups rankgroups = (RankGroups)new RankGroups(sortgroupbyrank._groupedSortedOut, groupbycols, sortcols, sortgroupbyrank._chunkFirstG, sortgroupbyrank._chunkLastG, sortgroupbyrank._newRankCol).doAll(sortgroupbyrank._groupedSortedOut);
        if (sortColsOrder.booleanValue()) {
            return new ValFrame(rankgroups._finalResult.sort(sortcols, sortAsc));
        }
        return new ValFrame(rankgroups._finalResult);
    }

    public boolean foundNAs(Chunk[] chunks, int rind, int[] sortCols, int sortLen) {
        for (int colInd = 0; colInd < sortLen; ++colInd) {
            if (!Double.isNaN(chunks[sortCols[colInd]].atd(rind))) continue;
            return true;
        }
        return false;
    }

    public class GInfoPC
    extends Iced {
        public final double[] _gs;
        int _hash;
        long _val;

        public GInfoPC(int ncols, long val) {
            this._gs = new double[ncols];
            this._val = val;
        }

        public GInfoPC fill(int row, Chunk[] chks, int[] cols) {
            for (int c = 0; c < cols.length; ++c) {
                this._gs[c] = chks[cols[c]].atd(row);
            }
            this._val = 1L;
            this._hash = this.hash();
            return this;
        }

        public GInfoPC fill(double[] cols, long val) {
            for (int c = 0; c < cols.length; ++c) {
                this._gs[c] = cols[c];
            }
            this._val = val;
            this._hash = this.hash();
            return this;
        }

        protected int hash() {
            long h = 0L;
            for (double d : this._gs) {
                h += Double.doubleToRawLongBits(d);
            }
            h ^= h >>> 20 ^ h >>> 12;
            h ^= h >>> 7 ^ h >>> 4;
            return (int)((h ^ h >> 32) & Integer.MAX_VALUE);
        }

        public boolean equals(Object o) {
            return o instanceof GInfoPC && Arrays.equals(this._gs, ((GInfoPC)o)._gs);
        }

        public int hashCode() {
            return this._hash;
        }

        public String toString() {
            return Arrays.toString(this._gs);
        }
    }

    public class SortnGrouby
    extends MRTask<SortnGrouby> {
        final int[] _sortCols;
        final int[] _groupbyCols;
        final int[] _sortOrders;
        final String _newColname;
        Frame _groupedSortedOut;
        GInfoPC[] _chunkFirstG;
        GInfoPC[] _chunkLastG;
        final int _groupbyLen;
        final int _sortLen;
        final int _newRankCol;
        final int _numChunks;

        private SortnGrouby(Frame original, int[] groupbycols, int[] sortCols, int[] sortasc, String newcolname) {
            this._sortCols = sortCols;
            this._groupbyCols = groupbycols;
            this._groupbyLen = this._groupbyCols.length;
            this._sortLen = sortCols.length;
            this._sortOrders = sortasc;
            this._newColname = newcolname;
            int[] allSorts = new int[this._groupbyLen + this._sortLen];
            int[] allSortDirs = new int[allSorts.length];
            System.arraycopy(this._groupbyCols, 0, allSorts, 0, this._groupbyLen);
            System.arraycopy(this._sortCols, 0, allSorts, this._groupbyLen, this._sortLen);
            Arrays.fill(allSortDirs, 1);
            System.arraycopy(this._sortOrders, 0, allSortDirs, this._groupbyLen, this._sortLen);
            this._groupedSortedOut = original.sort(allSorts, allSortDirs);
            Vec newrank = original.anyVec().makeCon(Double.NaN);
            this._groupedSortedOut.add(this._newColname, newrank);
            this._numChunks = this._groupedSortedOut.vec(0).nChunks();
            this._chunkFirstG = new GInfoPC[this._numChunks];
            this._chunkLastG = new GInfoPC[this._numChunks];
            this._newRankCol = this._groupedSortedOut.numCols() - 1;
        }

        @Override
        public void map(Chunk[] chunks) {
            int rind;
            int cidx = chunks[0].cidx();
            int chunkLen = chunks[0].len();
            GInfoPC gWork = new GInfoPC(this._groupbyLen, 1L);
            int nextGRind = 0;
            for (rind = 0; rind < chunkLen; ++rind) {
                if (AstRankWithinGroupBy.this.foundNAs(chunks, rind, this._sortCols, this._sortLen)) continue;
                chunks[this._newRankCol].set(rind, 0L);
                gWork.fill(rind, chunks, this._groupbyCols);
                if (this._chunkFirstG[cidx] == null) {
                    this._chunkFirstG[cidx] = new GInfoPC(this._groupbyLen, 1L);
                    this._chunkFirstG[cidx].fill(gWork._gs, 1L);
                    continue;
                }
                if (this._chunkFirstG[cidx].equals(gWork)) {
                    ++this._chunkFirstG[cidx]._val;
                    continue;
                }
                nextGRind = rind;
                break;
            }
            if (nextGRind == 0) {
                if (this._chunkFirstG[cidx] != null) {
                    this._chunkLastG[cidx] = new GInfoPC(this._groupbyLen, this._chunkFirstG[cidx]._val);
                    this._chunkLastG[cidx].fill(this._chunkFirstG[cidx]._gs, this._chunkFirstG[cidx]._val);
                }
            } else {
                for (int rowIndex = chunks[0]._len - 1; rowIndex >= rind; --rowIndex) {
                    if (AstRankWithinGroupBy.this.foundNAs(chunks, rowIndex, this._sortCols, this._sortLen)) continue;
                    chunks[this._newRankCol].set(rowIndex, 0L);
                    gWork.fill(rowIndex, chunks, this._groupbyCols);
                    if (this._chunkLastG[cidx] == null) {
                        this._chunkLastG[cidx] = new GInfoPC(this._groupbyLen, 1L);
                        this._chunkLastG[cidx].fill(gWork._gs, 1L);
                        continue;
                    }
                    if (!this._chunkLastG[cidx].equals(gWork)) break;
                    ++this._chunkLastG[cidx]._val;
                }
            }
        }

        @Override
        public void reduce(SortnGrouby git) {
            this.copyGroupInfo(this._chunkFirstG, git._chunkFirstG);
            this.copyGroupInfo(this._chunkLastG, git._chunkLastG);
        }

        public void copyGroupInfo(GInfoPC[] currentChunk, GInfoPC[] otherChunk) {
            int numChunks = currentChunk.length;
            for (int ind = 0; ind < numChunks; ++ind) {
                if (currentChunk[ind] != null || otherChunk[ind] == null) continue;
                currentChunk[ind] = new GInfoPC(this._groupbyLen, 1L);
                currentChunk[ind].fill(otherChunk[ind]._gs, otherChunk[ind]._val);
            }
        }

        @Override
        public void postGlobal() {
            for (int cInd = 1; cInd < this._numChunks; ++cInd) {
                if (this._chunkLastG[cInd - 1] == null || this._chunkFirstG[cInd] == null) continue;
                GInfoPC gNext = this._chunkFirstG[cInd];
                GInfoPC gPrevious = this._chunkLastG[cInd - 1];
                if (gNext.equals(gPrevious)) {
                    gNext._val += gPrevious._val;
                    GInfoPC gLast = this._chunkLastG[cInd];
                    if (!gLast.equals(gNext)) continue;
                    gLast._val += gPrevious._val;
                    continue;
                }
                gNext._val = 0L;
            }
            this._chunkFirstG[0]._val = 0L;
        }
    }

    public class RankGroups
    extends MRTask<RankGroups> {
        final int _newRankCol;
        final int _groupbyLen;
        final int[] _sortCols;
        final int _sortLen;
        final int[] _groupbyCols;
        final GInfoPC[] _chunkFirstG;
        final GInfoPC[] _chunkLastG;
        Frame _finalResult;

        private RankGroups(Frame inputFrame, int[] groupbycols, int[] sortCols, GInfoPC[] chunkFirstG, GInfoPC[] chunkLastG, int newRankCol) {
            this._newRankCol = newRankCol;
            this._groupbyCols = groupbycols;
            this._groupbyLen = groupbycols.length;
            this._sortCols = sortCols;
            this._sortLen = sortCols.length;
            this._chunkFirstG = chunkFirstG;
            this._chunkLastG = chunkLastG;
            this._finalResult = inputFrame;
        }

        @Override
        public void map(Chunk[] chunks) {
            int cidx = chunks[0].cidx();
            long rankOffset = this.setStartRank(cidx);
            GInfoPC previousKey = this._chunkFirstG[cidx] == null ? new GInfoPC(this._groupbyLen, 1L) : this._chunkFirstG[cidx];
            GInfoPC rowKey = new GInfoPC(this._groupbyLen, 1L);
            for (int rind = 0; rind < chunks[0]._len; ++rind) {
                if (Double.isNaN(chunks[this._newRankCol].atd(rind)) && AstRankWithinGroupBy.this.foundNAs(chunks, rind, this._sortCols, this._sortLen)) continue;
                rowKey.fill(rind, chunks, this._groupbyCols);
                if (previousKey.equals(rowKey)) {
                    ++rankOffset;
                } else {
                    previousKey.fill(rowKey._gs, 1L);
                    rankOffset = 1L;
                }
                chunks[this._newRankCol].set(rind, rankOffset);
            }
        }

        public long setStartRank(int cidx) {
            if (this._chunkFirstG[cidx] != null) {
                return this._chunkFirstG[cidx]._val;
            }
            return 0L;
        }
    }
}

