/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.mungers;

import java.util.Arrays;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;

public class AstSetLevel
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary", "level"};
    }

    @Override
    public int nargs() {
        return 3;
    }

    @Override
    public String str() {
        return "setLevel";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        if (fr.numCols() != 1) {
            throw new IllegalArgumentException("`setLevel` works on a single column at a time.");
        }
        String[] doms = (String[])fr.anyVec().domain().clone();
        if (doms == null) {
            throw new IllegalArgumentException("Cannot set the level on a non-factor column!");
        }
        String lvl = asts[2].exec(env).getStr();
        final int idx = Arrays.asList(doms).indexOf(lvl);
        if (idx == -1) {
            throw new IllegalArgumentException("Did not find level `" + lvl + "` in the column.");
        }
        Frame fr2 = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk c, NewChunk nc) {
                for (int i = 0; i < c._len; ++i) {
                    nc.addNum(idx);
                }
            }
        }.doAll(new byte[]{3}, fr.anyVec())).outputFrame(null, fr.names(), fr.domains());
        return new ValFrame(fr2);
    }
}

