/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.time;

import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.parser.ParseTime;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;

public class AstAsDate
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"time", "format"};
    }

    @Override
    public int nargs() {
        return 3;
    }

    @Override
    public String str() {
        return "as.Date";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        boolean isStr;
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        Vec vec = fr.vecs()[0];
        if (fr.vecs().length != 1 || !vec.isCategorical() && !vec.isString()) {
            throw new IllegalArgumentException("as.Date requires a single column of factors or strings");
        }
        final String format = asts[2].exec(env).getStr();
        if (format.isEmpty()) {
            throw new IllegalArgumentException("as.Date requires a non-empty format string");
        }
        final String[] dom = vec.domain();
        boolean bl = isStr = dom == null && vec.isString();
        assert (isStr || dom != null) : "as.Date error: domain is null, but vec is not String";
        Frame fr2 = ((MRTask)new MRTask(){
            private transient DateTimeFormatter _fmt;

            @Override
            public void setupLocal() {
                this._fmt = ParseTime.forStrptimePattern(format).withZone(ParseTime.getTimezone());
            }

            @Override
            public void map(Chunk c, NewChunk nc) {
                BufferedString tmpStr = new BufferedString();
                for (int i = 0; i < c._len; ++i) {
                    if (!c.isNA(i)) {
                        String date = isStr ? c.atStr(tmpStr, i).toString() : dom[(int)c.at8(i)];
                        nc.addNum(DateTime.parse(date, this._fmt).getMillis(), 0);
                        continue;
                    }
                    nc.addNA();
                }
            }
        }.doAll(1, (byte)3, fr)).outputFrame(fr._names, null);
        return new ValFrame(fr2);
    }
}

