/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.transforms;

import hex.genmodel.GenMunger;
import water.H2O;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.rapids.transforms.Transform;
import water.util.ArrayUtils;

public class H2OScaler
extends Transform<H2OScaler> {
    double[] means;
    double[] sdevs;

    H2OScaler(String name, String ast, boolean inplace, String[] newNames) {
        super(name, ast, inplace, newNames);
    }

    @Override
    public Transform<H2OScaler> fit(Frame f) {
        this.means = new double[f.numCols()];
        this.sdevs = new double[f.numCols()];
        for (int i = 0; i < f.numCols(); ++i) {
            this.means[i] = f.vec(i).mean();
            this.sdevs[i] = f.vec(i).sigma();
        }
        return this;
    }

    @Override
    protected Frame transformImpl(Frame f) {
        final double[] fmeans = this.means;
        final double[] fmults = ArrayUtils.invert(this.sdevs);
        return ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] cs, NewChunk[] ncs) {
                double[] in = new double[cs.length];
                for (int row = 0; row < cs[0]._len; ++row) {
                    int col;
                    for (col = 0; col < cs.length; ++col) {
                        in[col] = cs[col].atd(row);
                    }
                    GenMunger.scaleInPlace(fmeans, fmults, in);
                    for (col = 0; col < ncs.length; ++col) {
                        ncs[col].addNum(in[col]);
                    }
                }
            }
        }.doAll(f.numCols(), (byte)3, f)).outputFrame(f.names(), f.domains());
    }

    @Override
    Frame inverseTransform(Frame f) {
        throw H2O.unimpl();
    }

    @Override
    public String genClassImpl() {
        throw H2O.unimpl();
    }
}

