/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import water.H2O;
import water.Iced;
import water.util.Log;
import water.util.ProfileCollectorTask;

public class JProfile
extends Iced {
    public final String node_name;
    public final long timestamp;
    public final int depth;
    public ProfileSummary[] nodes;

    public JProfile(int d) {
        this.depth = d;
        this.node_name = H2O.getIpPortString();
        this.timestamp = System.currentTimeMillis();
    }

    public JProfile execImpl(boolean print) {
        int i;
        ProfileCollectorTask.NodeProfile[] profiles = ((ProfileCollectorTask)new ProfileCollectorTask((int)this.depth).doAllNodes())._result;
        this.nodes = new ProfileSummary[H2O.CLOUD.size()];
        for (i = 0; i < this.nodes.length; ++i) {
            assert (profiles[i] != null);
            this.nodes[i] = new ProfileSummary(H2O.CLOUD._memary[i].toString(), profiles[i]);
        }
        if (!print) {
            return this;
        }
        for (i = 0; i < this.nodes.length; ++i) {
            Log.info(this.nodes[i].name);
            for (int j = 0; j < this.nodes[i].profile.counts.length; ++j) {
                Log.info(this.nodes[i].profile.counts[j]);
                Log.info(this.nodes[i].profile.stacktraces[j]);
            }
        }
        return this;
    }

    public static class ProfileSummary
    extends Iced {
        public final String name;
        public final ProfileCollectorTask.NodeProfile profile;

        public ProfileSummary(String name, ProfileCollectorTask.NodeProfile profile) {
            this.name = name;
            this.profile = profile;
        }
    }
}

