/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.glrm;

import hex.genmodel.ModelMojoReader;
import hex.genmodel.algos.glrm.GlrmInitialization;
import hex.genmodel.algos.glrm.GlrmLoss;
import hex.genmodel.algos.glrm.GlrmMojoModel;
import hex.genmodel.algos.glrm.GlrmRegularizer;
import java.io.IOException;
import java.nio.ByteBuffer;

public class GlrmMojoReader
extends ModelMojoReader<GlrmMojoModel> {
    @Override
    public String getModelName() {
        return "Generalized Low Rank Model";
    }

    @Override
    protected void readModelData() throws IOException {
        ((GlrmMojoModel)this._model)._ncolA = (Integer)this.readkv("ncolA");
        ((GlrmMojoModel)this._model)._ncolY = (Integer)this.readkv("ncolY");
        ((GlrmMojoModel)this._model)._nrowY = (Integer)this.readkv("nrowY");
        ((GlrmMojoModel)this._model)._ncolX = (Integer)this.readkv("ncolX");
        ((GlrmMojoModel)this._model)._regx = GlrmRegularizer.valueOf((String)this.readkv("regularizationX"));
        ((GlrmMojoModel)this._model)._gammax = (Double)this.readkv("gammaX");
        ((GlrmMojoModel)this._model)._init = GlrmInitialization.valueOf((String)this.readkv("initialization"));
        ((GlrmMojoModel)this._model)._ncats = (Integer)this.readkv("num_categories");
        ((GlrmMojoModel)this._model)._nnums = (Integer)this.readkv("num_numeric");
        ((GlrmMojoModel)this._model)._normSub = (double[])this.readkv("norm_sub");
        ((GlrmMojoModel)this._model)._normMul = (double[])this.readkv("norm_mul");
        ((GlrmMojoModel)this._model)._permutation = (int[])this.readkv("cols_permutation");
        ((GlrmMojoModel)this._model)._losses = new GlrmLoss[((GlrmMojoModel)this._model)._ncolA];
        int li = 0;
        for (String line : this.readtext("losses")) {
            ((GlrmMojoModel)this._model)._losses[li++] = GlrmLoss.valueOf(line);
        }
        ((GlrmMojoModel)this._model)._numLevels = (int[])this.readkv("num_levels_per_category");
        ((GlrmMojoModel)this._model)._archetypes = new double[((GlrmMojoModel)this._model)._nrowY][];
        ByteBuffer bb = ByteBuffer.wrap(this.readblob("archetypes"));
        for (int i = 0; i < ((GlrmMojoModel)this._model)._nrowY; ++i) {
            double[] row = new double[((GlrmMojoModel)this._model)._ncolY];
            ((GlrmMojoModel)this._model)._archetypes[i] = row;
            for (int j = 0; j < ((GlrmMojoModel)this._model)._ncolY; ++j) {
                row[j] = bb.getDouble();
            }
        }
    }

    @Override
    protected GlrmMojoModel makeModel(String[] columns, String[][] domains, String responseColumn) {
        return new GlrmMojoModel(columns, domains, responseColumn);
    }
}

