/*
 * Decompiled with CFR 0.152.
 */
package ml.dmlc.xgboost4j.java;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import ml.dmlc.xgboost4j.java.Platform;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NativeLibrary {
    private static final Log logger = LogFactory.getLog(NativeLibrary.class);
    public static CompilationFlags[] EMPTY_COMPILATION_FLAGS = new CompilationFlags[0];
    private final String name;
    private final ClassLoader classLoader;
    private final Platform platform;
    private final CompilationFlags[] flags;
    private boolean loaded = false;

    static NativeLibrary nativeLibrary(String name, CompilationFlags[] flags) {
        return new NativeLibrary(name, flags);
    }

    static NativeLibrary nativeLibrary(String name, CompilationFlags[] flags, ClassLoader classLoader) {
        return new NativeLibrary(name, flags, classLoader);
    }

    private NativeLibrary(String name, CompilationFlags[] flags) {
        this(name, flags, NativeLibrary.class.getClassLoader());
    }

    private NativeLibrary(String name, CompilationFlags[] flags, ClassLoader classLoader) {
        this.name = name;
        this.classLoader = classLoader;
        this.platform = Platform.geOSType();
        this.flags = flags;
    }

    synchronized boolean load() throws IOException {
        if (!this.loaded) {
            this.doLoad();
            this.loaded = true;
        }
        return this.loaded;
    }

    private void doLoad() throws IOException {
        String libName = this.getName();
        try {
            System.loadLibrary(libName);
        }
        catch (UnsatisfiedLinkError e) {
            try {
                this.extractAndLoad(this.getPlatformLibraryPath(), this.getSimpleLibraryPath());
            }
            catch (IOException ioe) {
                logger.warn("Failed to load library from both native path and jar!");
                throw ioe;
            }
        }
    }

    private String getPlatformLibraryPath() {
        return String.format("%s/%s/%s", this.getResourcePrefix(), this.platform.getPlatform(), this.platform.getPlatformLibName(this.getName()));
    }

    private String getSimpleLibraryPath() {
        return String.format("%s/%s", this.getResourcePrefix(), this.platform.getPlatformLibName(this.getName()));
    }

    private String getResourcePrefix() {
        return "lib";
    }

    private ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private void extractAndLoad(String ... libPaths) throws IOException {
        Throwable lastException = null;
        for (String libPath : libPaths) {
            try {
                lastException = null;
                File temp = NativeLibrary.extract(libPath, this.getClassLoader());
                System.load(temp.getAbsolutePath());
                logger.info("Loaded library from " + libPath + " (" + temp.getAbsolutePath() + ")");
                break;
            }
            catch (IOException | UnsatisfiedLinkError e) {
                logger.warn("Cannot load library from path " + libPath);
                lastException = e;
            }
        }
        if (lastException != null) {
            throw new IOException(lastException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File extract(String libPath, ClassLoader classLoader) throws IOException, IllegalArgumentException {
        String filename = libPath.substring(libPath.lastIndexOf(47) + 1);
        int lastDotIdx = filename.lastIndexOf(46);
        String prefix = "";
        String suffix = null;
        if (lastDotIdx >= 0 && lastDotIdx < filename.length() - 1) {
            prefix = filename.substring(0, lastDotIdx);
            suffix = filename.substring(lastDotIdx);
        }
        File temp = File.createTempFile(prefix, suffix);
        temp.deleteOnExit();
        InputStream is = classLoader.getResourceAsStream(libPath);
        if (is == null) {
            throw new FileNotFoundException("File " + libPath + " was not found inside JAR.");
        }
        try {
            Files.copy(is, temp.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            is.close();
        }
        return temp;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasCompilationFlag(CompilationFlags flag) {
        for (CompilationFlags f : this.getCompilationFlags()) {
            if (flag != f) continue;
            return true;
        }
        return false;
    }

    public CompilationFlags[] getCompilationFlags() {
        return this.flags;
    }

    public String toString() {
        return String.format("%s (%s)", this.getName(), this.getPlatformLibraryPath());
    }

    public static enum CompilationFlags {
        WITH_GPU,
        WITH_OMP;

    }
}

