/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.xgboost;

import biz.k11i.xgboost.Predictor;
import biz.k11i.xgboost.gbm.GradBooster;
import hex.genmodel.GenModel;
import hex.genmodel.MojoModel;
import hex.genmodel.algos.tree.SharedTreeGraph;
import hex.genmodel.algos.xgboost.XGBoostMojoModel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import ml.dmlc.xgboost4j.java.Booster;
import ml.dmlc.xgboost4j.java.BoosterHelper;
import ml.dmlc.xgboost4j.java.DMatrix;
import ml.dmlc.xgboost4j.java.XGBoostError;

public final class XGBoostNativeMojoModel
extends XGBoostMojoModel {
    private Booster _booster;

    public XGBoostNativeMojoModel(byte[] boosterBytes, String[] columns, String[][] domains, String responseColumn) {
        super(columns, domains, responseColumn);
        this._booster = XGBoostNativeMojoModel.makeBooster(boosterBytes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Booster makeBooster(byte[] boosterBytes) {
        try (ByteArrayInputStream is = new ByteArrayInputStream(boosterBytes);){
            Booster booster = BoosterHelper.loadModel(is);
            return booster;
        }
        catch (Exception xgBoostError) {
            throw new IllegalStateException("Unable to load XGBooster", xgBoostError);
        }
    }

    public final double[] score0(double[] doubles, double offset, double[] preds) {
        if (offset != 0.0 && this._mojo_version == 1.0) {
            throw new UnsupportedOperationException("Unsupported: offset != 0");
        }
        return XGBoostNativeMojoModel.score0(doubles, offset, preds, this._boosterType, this._ntrees, this._booster, this._nums, this._cats, this._catOffsets, this._useAllFactorLevels, this._nclasses, this._priorClassDistrib, this._defaultThreshold, this._sparse, this._hasOffset);
    }

    public static double[] score0(double[] doubles, double offset, double[] preds, String _boosterType, int _ntrees, Booster _booster, int _nums, int _cats, int[] _catOffsets, boolean _useAllFactorLevels, int nclasses, double[] _priorClassDistrib, double _defaultThreshold, boolean _sparse, boolean _hasOffset) {
        float[] out;
        int cats = _catOffsets == null ? 0 : _catOffsets[_cats];
        float[] floats = new float[_nums + cats];
        GenModel.setInput((double[])doubles, (float[])floats, (int)_nums, (int)_cats, (int[])_catOffsets, null, null, (boolean)_useAllFactorLevels, (boolean)_sparse);
        DMatrix dmat = null;
        try {
            dmat = new DMatrix(floats, 1, floats.length, _sparse ? 0.0f : Float.NaN);
            if (_hasOffset) {
                dmat.setBaseMargin(new float[]{(float)offset});
            } else if (offset != 0.0) {
                throw new UnsupportedOperationException("Unsupported: offset != 0");
            }
            final DMatrix row = dmat;
            final int treeLimit = "dart".equals(_boosterType) ? _ntrees : 0;
            BoosterHelper.BoosterOp<float[]> predictOp = new BoosterHelper.BoosterOp<float[]>(){

                @Override
                public float[] apply(Booster booster) throws XGBoostError {
                    return booster.predict(row, false, treeLimit)[0];
                }
            };
            out = BoosterHelper.doWithLocalRabit(predictOp, _booster);
        }
        catch (XGBoostError xgBoostError) {
            try {
                throw new IllegalStateException("Failed XGBoost prediction.", xgBoostError);
            }
            catch (Throwable throwable) {
                BoosterHelper.dispose(dmat);
                throw throwable;
            }
        }
        BoosterHelper.dispose(dmat);
        return XGBoostNativeMojoModel.toPreds(doubles, out, preds, nclasses, _priorClassDistrib, _defaultThreshold);
    }

    @Override
    public void close() {
        BoosterHelper.dispose(this._booster);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getBoosterDump(final boolean withStats, final String format) {
        String[] stringArray;
        Path featureMapFile;
        if (this._featureMap != null && !this._featureMap.isEmpty()) {
            try {
                featureMapFile = Files.createTempFile("featureMap", ".txt", new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to write a temporary file with featureMap");
            }
        } else {
            featureMapFile = null;
        }
        try {
            if (featureMapFile != null) {
                Files.write(featureMapFile, Collections.singletonList(this._featureMap), Charset.defaultCharset(), StandardOpenOption.WRITE);
            }
            BoosterHelper.BoosterOp<String[]> dumpOp = new BoosterHelper.BoosterOp<String[]>(){

                @Override
                public String[] apply(Booster booster) throws XGBoostError {
                    String featureMap = featureMapFile != null ? featureMapFile.toFile().getAbsolutePath() : null;
                    return booster.getModelDump(featureMap, withStats, format);
                }
            };
            stringArray = BoosterHelper.doWithLocalRabit(dumpOp, this._booster);
            if (featureMapFile == null) return stringArray;
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException("Failed to write feature map file", e);
                catch (XGBoostError e2) {
                    throw new IllegalStateException("Failed to dump model", e2);
                }
            }
            catch (Throwable throwable) {
                if (featureMapFile == null) throw throwable;
                try {
                    Files.deleteIfExists(featureMapFile);
                    throw throwable;
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                throw throwable;
            }
        }
        try {
            Files.deleteIfExists(featureMapFile);
            return stringArray;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return stringArray;
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2 || !"--dump".equals(args[0])) {
            XGBoostNativeMojoModel.usage();
            System.exit(1);
        }
        String mojoFile = args[1];
        boolean withStats = args.length > 2 && Boolean.parseBoolean(args[2]);
        String format = args.length > 3 ? args[3] : "text";
        XGBoostNativeMojoModel mojoModel = (XGBoostNativeMojoModel)MojoModel.load((String)mojoFile);
        for (String dumpLine : mojoModel.getBoosterDump(withStats, format)) {
            System.out.println(dumpLine);
        }
    }

    private static void usage() {
        System.out.println("java -cp h2o-genmodel.jar " + XGBoostNativeMojoModel.class.getCanonicalName() + " --dump <mojo> [withStats?] [format]");
    }

    public SharedTreeGraph convert(int treeNumber, String treeClass) {
        GradBooster booster = null;
        try {
            booster = new Predictor((InputStream)new ByteArrayInputStream(this._booster.toByteArray())).getBooster();
        }
        catch (IOException | XGBoostError e) {
            e.printStackTrace();
        }
        return this.computeGraph(booster, treeNumber);
    }
}

