/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.xgboost;

import com.google.gson.JsonObject;
import hex.genmodel.ModelMojoReader;
import hex.genmodel.MojoReaderBackend;
import hex.genmodel.algos.xgboost.XGBoostJavaMojoModel;
import hex.genmodel.algos.xgboost.XGBoostModelAttributes;
import hex.genmodel.algos.xgboost.XGBoostMojoModel;
import hex.genmodel.attributes.ModelJsonReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class XGBoostMojoReader
extends ModelMojoReader<XGBoostMojoModel> {
    public String getModelName() {
        return "XGBoost";
    }

    protected void readModelData() throws IOException {
        String calibMethod;
        ((XGBoostMojoModel)this._model)._boosterType = (String)this.readkv("booster");
        ((XGBoostMojoModel)this._model)._ntrees = (Integer)this.readkv("ntrees", 0);
        ((XGBoostMojoModel)this._model)._nums = (Integer)this.readkv("nums");
        ((XGBoostMojoModel)this._model)._cats = (Integer)this.readkv("cats");
        ((XGBoostMojoModel)this._model)._catOffsets = (int[])this.readkv("cat_offsets");
        ((XGBoostMojoModel)this._model)._useAllFactorLevels = (Boolean)this.readkv("use_all_factor_levels");
        ((XGBoostMojoModel)this._model)._sparse = (Boolean)this.readkv("sparse");
        if (this.exists("feature_map")) {
            ((XGBoostMojoModel)this._model)._featureMap = new String(this.readblob("feature_map"), StandardCharsets.UTF_8);
        }
        if ((calibMethod = (String)this.readkv("calib_method")) != null) {
            if (!"platt".equals(calibMethod)) {
                throw new IllegalStateException("Unknown calibration method: " + calibMethod);
            }
            ((XGBoostMojoModel)this._model)._calib_glm_beta = (double[])this.readkv("calib_glm_beta", new double[0]);
        }
        ((XGBoostMojoModel)this._model)._hasOffset = (Boolean)this.readkv("has_offset", false);
        ((XGBoostMojoModel)this._model).postReadInit();
    }

    protected XGBoostMojoModel makeModel(String[] columns, String[][] domains, String responseColumn) {
        byte[] boosterBytes;
        try {
            boosterBytes = this.readblob("boosterBytes");
        }
        catch (IOException e) {
            throw new IllegalStateException("MOJO is corrupted: cannot read the serialized Booster", e);
        }
        return new XGBoostJavaMojoModel(boosterBytes, columns, domains, responseColumn);
    }

    public String mojoVersion() {
        return "1.10";
    }

    protected XGBoostModelAttributes readModelSpecificAttributes() {
        JsonObject modelJson = ModelJsonReader.parseModelJson((MojoReaderBackend)this._reader);
        if (modelJson != null) {
            return new XGBoostModelAttributes(modelJson, this._model);
        }
        return null;
    }
}

