/*
 * Decompiled with CFR 0.152.
 */
package water.parser;

import org.joda.time.DateTimeZone;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import water.Key;
import water.Scope;
import water.TestUtil;
import water.fvec.Frame;
import water.parser.ParseTime;

public class ParseTestORCCSV
extends TestUtil {
    private String[] csvFiles = new String[]{"smalldata/parser/orc/orc2csv/testTimeStamp.csv", "smalldata/parser/orc/orc2csv/testDate1900.csv", "smalldata/parser/orc/orc2csv/testDate2038.csv"};
    private String[] orcFiles = new String[]{"smalldata/parser/orc/testTimeStamp.orc", "smalldata/parser/orc/TestOrcFile.testDate1900.orc", "smalldata/parser/orc/TestOrcFile.testDate2038.orc"};

    @BeforeClass
    public static void _preconditionJavaVersion() {
        Assume.assumeTrue((String)"Java6 is not supported", (!System.getProperty("java.version", "NA").startsWith("1.6") ? 1 : 0) != 0);
    }

    @BeforeClass
    public static void setup() {
        TestUtil.stall_till_cloudsize((int)5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParseOrcCsvFiles() {
        Scope.enter();
        DateTimeZone currTimeZn = ParseTime.getTimezone();
        if (currTimeZn.getID().matches("America/Los_Angeles")) {
            try {
                for (int f_index = 0; f_index < this.csvFiles.length; ++f_index) {
                    Frame csv_frame = this.parse_test_file(this.csvFiles[f_index], "\\N", 0, null);
                    Frame orc_frame = this.parse_test_file(this.orcFiles[f_index], null, 0, null);
                    Scope.track((Frame[])new Frame[]{csv_frame});
                    Scope.track((Frame[])new Frame[]{orc_frame});
                    Assert.assertTrue((String)("Fails: " + this.csvFiles[f_index] + " != " + this.orcFiles[f_index]), (boolean)TestUtil.isBitIdentical((Frame)orc_frame, (Frame)csv_frame));
                }
            }
            finally {
                Scope.exit((Key[])new Key[0]);
            }
        }
    }
}

