/*
 * Decompiled with CFR 0.152.
 */
package water.parser;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.TreeSet;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import water.Job;
import water.Key;
import water.TestUtil;
import water.api.schemas3.ParseSetupV3;
import water.fvec.Frame;
import water.fvec.NFSFileVec;
import water.fvec.Vec;
import water.parser.OrcTestUtils;
import water.parser.ParseDataset;
import water.parser.ParseSetup;
import water.parser.ParseWriter;
import water.parser.orc.OrcParserProvider;
import water.util.ArrayUtils;
import water.util.FileUtils;
import water.util.Log;

public class ParseTestOrc
extends TestUtil {
    int totalFilesTested = 0;
    int numberWrong = 0;
    private String[] allOrcFiles = new String[]{"smalldata/parser/orc/TestOrcFile.columnProjection.orc", "smalldata/parser/orc/bigint_single_col.orc", "smalldata/parser/orc/TestOrcFile.emptyFile.orc", "smalldata/parser/orc/bool_single_col.orc", "smalldata/parser/orc/demo-11-zlib.orc", "smalldata/parser/orc/TestOrcFile.testDate1900.orc", "smalldata/parser/orc/demo-12-zlib.orc", "smalldata/parser/orc/TestOrcFile.testDate2038.orc", "smalldata/parser/orc/double_single_col.orc", "smalldata/parser/orc/TestOrcFile.testMemoryManagementV11.orc", "smalldata/parser/orc/float_single_col.orc", "smalldata/parser/orc/TestOrcFile.testMemoryManagementV12.orc", "smalldata/parser/orc/int_single_col.orc", "smalldata/parser/orc/TestOrcFile.testPredicatePushdown.orc", "smalldata/parser/orc/nulls-at-end-snappy.orc", "smalldata/parser/orc/TestOrcFile.testSnappy.orc", "smalldata/parser/orc/orc_split_elim.orc", "smalldata/parser/orc/TestOrcFile.testStringAndBinaryStatistics.orc", "smalldata/parser/orc/TestOrcFile.testStripeLevelStats.orc", "smalldata/parser/orc/smallint_single_col.orc", "smalldata/parser/orc/string_single_col.orc", "smalldata/parser/orc/tinyint_single_col.orc", "smalldata/parser/orc/TestOrcFile.testWithoutIndex.orc"};

    @BeforeClass
    public static void setup() {
        TestUtil.stall_till_cloudsize((int)1);
    }

    @BeforeClass
    public static void _preconditionJavaVersion() {
        Assume.assumeTrue((String)"Java6 is not supported", (!System.getProperty("java.version", "NA").startsWith("1.6") ? 1 : 0) != 0);
    }

    @Test
    public void testTypeOverrides() {
        NFSFileVec nfs = ParseTestOrc.makeNfsFileVec((String)"smalldata/parser/orc/orc_split_elim.orc");
        Key outputKey = Key.make((String)"orc_Test");
        ParseSetup pstp = new ParseSetup(new ParseSetupV3());
        pstp._parse_type = new OrcParserProvider.OrcParserInfo();
        ParseSetup ps = ParseSetup.guessSetup((Key[])new Key[]{nfs._key}, (ParseSetup)pstp);
        Assert.assertEquals((Object)ps._parse_type.name(), (Object)"ORC");
        ps._column_types[0] = 0;
        ps._column_types[1] = 4;
        ps._column_types[2] = 2;
        ParseSetup ps2 = ParseSetup.guessSetup((Key[])new Key[]{nfs._key}, (ParseSetup)ps);
        String errs = Arrays.deepToString(ps2.errs());
        Assert.assertEquals((long)1L, (long)ps2.errs().length);
        Assert.assertTrue((boolean)(ps2.errs()[0] instanceof ParseWriter.UnsupportedTypeOverride));
        System.out.println("types: " + Arrays.toString(ArrayUtils.select((String[])Vec.TYPE_STR, (byte[])ps2._column_types)));
        Key k = Key.make();
        Job j = ParseDataset.forkParseDataset((Key)k, (Key[])new Key[]{nfs._key}, (ParseSetup)ps, (boolean)true)._job;
        Frame fr = (Frame)j.get();
        String warns = Arrays.toString(j.warns());
        Assert.assertEquals((Object)errs, (Object)warns);
        Assert.assertArrayEquals((Object[])new String[]{"bar", "cat", "dog", "eat", "foo", "zebra"}, (Object[])fr.vec(1).domain());
        Assert.assertTrue((boolean)fr.vec(0).isBad());
        fr.delete();
    }

    @Test
    public void testParseAllOrcs() {
        TreeSet<String> failedFiles = new TreeSet<String>();
        for (String fileName : this.allOrcFiles) {
            Log.info((Object[])new Object[]{"Orc Parser parsing " + fileName});
            File f = FileUtils.locateFile((String)fileName);
            if (f != null && f.exists()) {
                try {
                    this.numberWrong += OrcTestUtils.compareOrcAndH2OFrame(fileName, f, failedFiles);
                    ++this.totalFilesTested;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    failedFiles.add(fileName);
                    ++this.numberWrong;
                }
                continue;
            }
            Log.warn((Object[])new Object[]{"The following file was not found: " + fileName});
            failedFiles.add(fileName);
            ++this.numberWrong;
        }
        if (this.numberWrong > 0) {
            Log.warn((Object[])new Object[]{"There are errors in your test."});
            Assert.assertEquals((String)("Number of orc files failed to parse is: " + this.numberWrong + ", failed files = " + ((Object)failedFiles).toString()), (long)0L, (long)this.numberWrong);
        } else {
            Log.info((Object[])new Object[]{"Parser test passed!  Number of files parsed is " + this.totalFilesTested});
        }
    }
}

