/*
 * Decompiled with CFR 0.152.
 */
package water.parser;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.ql.io.orc.StripeInformation;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Ignore;
import water.TestUtil;
import water.fvec.Frame;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.parser.orc.OrcUtil;
import water.util.Log;

@Ignore(value="Support for ORC tests, but no actual tests here")
public class OrcTestUtils {
    private static double EPSILON = 1.0E-9;
    private static long ERRORMARGIN = 1000L;
    static final int DAY_TO_MS = 86400000;
    static final int ADD_OFFSET = 28800000;
    static final int HOUR_OFFSET = 3600000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int compareOrcAndH2OFrame(String fileName, File f, Set<String> failedFiles) throws IOException {
        Frame h2oFrame = null;
        try {
            Configuration conf = new Configuration();
            Path p = new Path(f.toString());
            Reader orcFileReader = OrcFile.createReader((Path)p, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf));
            h2oFrame = TestUtil.parse_test_file((String)f.toString());
            int n = OrcTestUtils.compareH2OFrame(fileName, failedFiles, h2oFrame, orcFileReader);
            return n;
        }
        finally {
            if (h2oFrame != null) {
                h2oFrame.delete();
            }
        }
    }

    static int compareH2OFrame(String fileName, Set<String> failedFiles, Frame h2oFrame, Reader orcReader) {
        StructObjectInspector insp = (StructObjectInspector)orcReader.getObjectInspector();
        List allColInfo = insp.getAllStructFieldRefs();
        int allColNumber = allColInfo.size();
        boolean[] toInclude = new boolean[allColNumber + 1];
        int colNumber = 0;
        int index1 = 0;
        for (StructField oneField : allColInfo) {
            String colType = oneField.getFieldObjectInspector().getTypeName();
            if (colType.toLowerCase().contains("decimal")) {
                colType = "decimal";
            }
            if (OrcUtil.isSupportedSchema((String)colType)) {
                toInclude[index1 + 1] = true;
                ++colNumber;
            }
            ++index1;
        }
        Assert.assertEquals((String)"Number of columns need to be the same: ", (long)colNumber, (long)h2oFrame.numCols());
        Object[] colNames = new String[colNumber];
        String[] colTypes = new String[colNumber];
        int colIndex = 0;
        for (int index = 0; index < allColNumber; ++index) {
            String typeName = ((StructField)allColInfo.get(index)).getFieldObjectInspector().getTypeName();
            if (typeName.toLowerCase().contains("decimal")) {
                typeName = "decimal";
            }
            if (!OrcUtil.isSupportedSchema((String)typeName)) continue;
            colNames[colIndex] = ((StructField)allColInfo.get(index)).getFieldName();
            colTypes[colIndex] = typeName;
            ++colIndex;
        }
        Assert.assertArrayEquals((String)"Column names need to be the same: ", (Object[])colNames, (Object[])h2oFrame._names);
        int failed = OrcTestUtils.compareFrameContents(fileName, failedFiles, h2oFrame, orcReader, colTypes, (String[])colNames, toInclude);
        Long totalRowNumber = orcReader.getNumberOfRows();
        Assert.assertEquals((String)"Number of rows need to be the same: ", (Object)totalRowNumber, (Object)h2oFrame.numRows());
        return failed;
    }

    static int compareFrameContents(String fileName, Set<String> failedFiles, Frame h2oFrame, Reader orcReader, String[] colTypes, String[] colNames, boolean[] toInclude) {
        List stripesInfo = orcReader.getStripes();
        int wrongTests = 0;
        if (stripesInfo.size() == 0) {
            Assert.assertEquals((String)"Orc file is empty.  H2O frame row number should be zero: ", (long)0L, (long)h2oFrame.numRows());
        } else {
            Long startRowIndex = 0L;
            for (StripeInformation oneStripe : stripesInfo) {
                try {
                    RecordReader perStripe = orcReader.rows(oneStripe.getOffset(), oneStripe.getDataLength(), toInclude, null, colNames);
                    VectorizedRowBatch batch = perStripe.nextBatch(null);
                    boolean done = false;
                    Long rowCounts = 0L;
                    Long rowNumber = oneStripe.getNumberOfRows();
                    while (!done) {
                        long currentBatchRow = batch.count();
                        ColumnVector[] dataVectors = batch.cols;
                        int colIndex = 0;
                        for (int cIdx = 0; cIdx < batch.numCols; ++cIdx) {
                            if (!toInclude[cIdx + 1]) continue;
                            OrcTestUtils.compare1Cloumn(dataVectors[cIdx], colTypes[colIndex].toLowerCase(), colIndex, currentBatchRow, h2oFrame.vec(colNames[colIndex]), startRowIndex);
                            ++colIndex;
                        }
                        rowCounts = rowCounts + currentBatchRow;
                        startRowIndex = startRowIndex + currentBatchRow;
                        if (rowCounts >= rowNumber) {
                            done = true;
                        }
                        if (done) continue;
                        batch = perStripe.nextBatch(batch);
                    }
                    perStripe.close();
                }
                catch (Throwable e) {
                    failedFiles.add(fileName);
                    e.printStackTrace();
                    ++wrongTests;
                }
            }
        }
        return wrongTests;
    }

    static void compare1Cloumn(ColumnVector oneColumn, String columnType, int cIdx, long currentBatchRow, Vec h2oColumn, Long startRowIndex) {
        if (columnType.contains("binary")) {
            return;
        }
        switch (columnType) {
            case "boolean": 
            case "bigint": 
            case "int": 
            case "smallint": 
            case "tinyint": {
                OrcTestUtils.CompareLongcolumn(oneColumn, oneColumn.isNull, currentBatchRow, h2oColumn, startRowIndex);
                break;
            }
            case "float": 
            case "double": {
                OrcTestUtils.compareDoublecolumn(oneColumn, oneColumn.isNull, currentBatchRow, h2oColumn, startRowIndex);
                break;
            }
            case "string": 
            case "varchar": 
            case "char": 
            case "binary": {
                OrcTestUtils.compareStringcolumn(oneColumn, oneColumn.isNull, currentBatchRow, h2oColumn, startRowIndex, columnType);
                break;
            }
            case "timestamp": 
            case "date": {
                OrcTestUtils.compareTimecolumn(oneColumn, columnType, oneColumn.isNull, currentBatchRow, h2oColumn, startRowIndex);
                break;
            }
            case "decimal": {
                OrcTestUtils.compareDecimalcolumn(oneColumn, oneColumn.isNull, currentBatchRow, h2oColumn, startRowIndex);
                break;
            }
            default: {
                Log.warn((Object[])new Object[]{"String, bigint are not tested.  H2O frame is built for them but cannot be verified."});
            }
        }
    }

    static void compareDecimalcolumn(ColumnVector oneDecimalColumn, boolean[] isNull, long currentBatchRow, Vec h2oFrame, Long startRowIndex) {
        HiveDecimalWritable[] oneColumn = ((DecimalColumnVector)oneDecimalColumn).vector;
        long frameRowIndex = startRowIndex;
        int rowIndex = 0;
        while ((long)rowIndex < currentBatchRow) {
            if (isNull[rowIndex]) {
                Assert.assertEquals((String)"Na is found: ", (Object)true, (Object)h2oFrame.isNA(frameRowIndex));
            } else {
                Assert.assertEquals((String)"Decimal elements should equal: ", (double)Double.parseDouble(oneColumn[rowIndex].toString()), (double)h2oFrame.at(frameRowIndex), (double)EPSILON);
            }
            ++frameRowIndex;
            ++rowIndex;
        }
    }

    static void compareTimecolumn(ColumnVector oneTSColumn, String columnType, boolean[] isNull, long currentBatchRow, Vec h2oFrame, Long startRowIndex) {
        long[] oneColumn = ((LongColumnVector)oneTSColumn).vector;
        long frameRowIndex = startRowIndex;
        int rowIndex = 0;
        while ((long)rowIndex < currentBatchRow) {
            if (isNull[rowIndex]) {
                Assert.assertEquals((String)"Na is found: ", (Object)true, (Object)h2oFrame.isNA(frameRowIndex));
            } else if (columnType.contains("timestamp")) {
                Assert.assertEquals((String)"Numerical elements should equal: ", (float)(oneColumn[rowIndex] / 1000000L), (float)h2oFrame.at8(frameRowIndex), (float)ERRORMARGIN);
            } else {
                Assert.assertEquals((String)"Numerical elements should equal: ", (float)OrcTestUtils.correctTimeStamp(oneColumn[rowIndex]), (float)h2oFrame.at8(frameRowIndex), (float)ERRORMARGIN);
            }
            ++frameRowIndex;
            ++rowIndex;
        }
    }

    static void compareStringcolumn(ColumnVector oneStringColumn, boolean[] isNull, long currentBatchRow, Vec h2oFrame, Long startRowIndex, String columnType) {
        byte[][] oneColumn = ((BytesColumnVector)oneStringColumn).vector;
        int[] stringLength = ((BytesColumnVector)oneStringColumn).length;
        int[] stringStart = ((BytesColumnVector)oneStringColumn).start;
        long frameRowIndex = startRowIndex;
        BufferedString tempH2o = new BufferedString();
        BufferedString tempOrc = new BufferedString();
        int rowIndex = 0;
        while ((long)rowIndex < currentBatchRow) {
            if (isNull[rowIndex]) {
                Assert.assertEquals((String)"Na is found: ", (Object)true, (Object)h2oFrame.isNA(frameRowIndex));
            } else {
                if (!oneStringColumn.isRepeating || rowIndex == 0) {
                    tempOrc.set(oneColumn[rowIndex], stringStart[rowIndex], stringLength[rowIndex]);
                }
                h2oFrame.atStr(tempH2o, frameRowIndex);
                Assert.assertEquals((String)("isRepeating = " + oneStringColumn.isRepeating + " String/char elements should equal: "), (Object)true, (Object)tempOrc.equals((Object)tempH2o));
            }
            ++frameRowIndex;
            ++rowIndex;
        }
    }

    static void compareDoublecolumn(ColumnVector oneDoubleColumn, boolean[] isNull, long currentBatchRow, Vec h2oFrame, Long startRowIndex) {
        double[] oneColumn = ((DoubleColumnVector)oneDoubleColumn).vector;
        long frameRowIndex = startRowIndex;
        int rowIndex = 0;
        while ((long)rowIndex < currentBatchRow) {
            if (isNull[rowIndex]) {
                Assert.assertEquals((String)"Na is found: ", (Object)true, (Object)h2oFrame.isNA(frameRowIndex));
            } else {
                Assert.assertEquals((String)"Numerical elements should equal: ", (double)oneColumn[rowIndex], (double)h2oFrame.at(frameRowIndex), (double)EPSILON);
            }
            ++frameRowIndex;
            ++rowIndex;
        }
    }

    static void CompareLongcolumn(ColumnVector oneLongColumn, boolean[] isNull, long currentBatchRow, Vec h2oFrame, Long startRowIndex) {
        long[] oneColumn = ((LongColumnVector)oneLongColumn).vector;
        long frameRowIndex = startRowIndex;
        int rowIndex = 0;
        while ((long)rowIndex < currentBatchRow) {
            block5: {
                block4: {
                    block3: {
                        if (!isNull[rowIndex]) break block3;
                        Assert.assertEquals((String)"Na is found: ", (Object)true, (Object)h2oFrame.isNA(frameRowIndex));
                        break block4;
                    }
                    if (h2oFrame.isNA(frameRowIndex)) break block5;
                    Assert.assertEquals((String)"Numerical elements should equal: ", (long)oneColumn[rowIndex], (long)h2oFrame.at8(frameRowIndex));
                }
                ++frameRowIndex;
            }
            ++rowIndex;
        }
    }

    static long correctTimeStamp(long daysSinceEpoch) {
        long timestamp = daysSinceEpoch * 86400000L + 28800000L;
        DateTime date = new DateTime(timestamp);
        int hour = date.hourOfDay().get();
        if (hour == 0) {
            return timestamp;
        }
        return timestamp - (long)(hour * 3600000);
    }
}

