/*
 * Decompiled with CFR 0.152.
 */
package water.parser;

import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import water.TestUtil;
import water.fvec.Frame;
import water.parser.ParseSetup;

public class ParseTestMultiFileOrc
extends TestUtil {
    private double EPSILON = 1.0E-9;
    private long ERRORMARGIN = 1000L;
    int totalFilesTested = 0;
    int numberWrong = 0;
    private String[] csvDirectories = new String[]{"smalldata/smalldata/synthetic_perfect_separation/"};
    private String[] orcDirectories = new String[]{"smalldata/parser/orc/synthetic_perfect_separation/"};

    @BeforeClass
    public static void _preconditionJavaVersion() {
        Assume.assumeTrue((String)"Java6 is not supported", (!System.getProperty("java.version", "NA").startsWith("1.6") ? 1 : 0) != 0);
    }

    @BeforeClass
    public static void setup() {
        TestUtil.stall_till_cloudsize((int)1);
    }

    @Test
    public void testParseMultiFileOrcs() {
        for (final boolean disableParallelParse : new boolean[]{false, true}) {
            TestUtil.ParseSetupTransformer pst = new TestUtil.ParseSetupTransformer(){

                public ParseSetup transformSetup(ParseSetup guessedSetup) {
                    guessedSetup.disableParallelParse = disableParallelParse;
                    return guessedSetup;
                }
            };
            for (int f_index = 0; f_index < this.csvDirectories.length; ++f_index) {
                Frame csv_frame = ParseTestMultiFileOrc.parse_test_folder((String)this.csvDirectories[f_index], (String)"\\N", (int)0, null, (TestUtil.ParseSetupTransformer)pst);
                byte[] types = csv_frame.types();
                for (int index = 0; index < types.length; ++index) {
                    if (types[index] != 0) continue;
                    types[index] = 4;
                }
                Frame orc_frame = ParseTestMultiFileOrc.parse_test_folder((String)this.orcDirectories[f_index], null, (int)0, (byte[])types, (TestUtil.ParseSetupTransformer)pst);
                Assert.assertTrue((boolean)TestUtil.isIdenticalUpToRelTolerance((Frame)csv_frame, (Frame)orc_frame, (double)1.0E-5));
                csv_frame.delete();
                orc_frame.delete();
            }
        }
    }
}

