/*
 * Decompiled with CFR 0.152.
 */
package water.persist;

import java.net.URI;
import junit.framework.TestCase;
import org.junit.BeforeClass;
import org.junit.Test;
import water.DKV;
import water.H2O;
import water.Key;
import water.MRTask;
import water.Scope;
import water.TestUtil;
import water.fvec.Chunk;
import water.fvec.FileVec;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.FileUtils;

public class PersistGcsTest
extends TestUtil {
    @BeforeClass
    public static void setup() {
        PersistGcsTest.stall_till_cloudsize((int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGcsImport() throws Exception {
        Scope.enter();
        try {
            Key remoteKey = H2O.getPM().anyURIToKey(new URI("gs://gcp-public-data-nexrad-l2/2018/01/01/KABR/NWS_NEXRAD_NXL2DPBL_KABR_20180101050000_20180101055959.tar"));
            Frame remoteFrame = (Frame)DKV.getGet((Key)remoteKey);
            FileVec remoteFileVec = (FileVec)remoteFrame.anyVec();
            Key localKey = H2O.getPM().anyURIToKey(new URI(FileUtils.getFile((String)"smalldata/nexrad/NWS_NEXRAD_NXL2DPBL_KABR_20180101050000_20180101055959.tar").getAbsolutePath()));
            FileVec localFileVec = (FileVec)DKV.getGet((Key)localKey);
            TestCase.assertEquals((long)localFileVec.length(), (long)remoteFileVec.length());
            PersistGcsTest.assertVecEquals((Vec)localFileVec, (Vec)remoteFileVec, (double)0.0);
            int chunkSize = (int)remoteFileVec.length();
            remoteFileVec.setChunkSize(remoteFrame, chunkSize);
            localFileVec.setChunkSize(chunkSize);
            long remoteXor = ((XORTask)new XORTask().doAll((Vec[])new Vec[]{remoteFileVec}))._res;
            long localXor = ((XORTask)new XORTask().doAll((Vec[])new Vec[]{localFileVec}))._res;
            TestCase.assertEquals((long)localXor, (long)remoteXor);
            remoteFrame.delete();
            localFileVec.remove();
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    private static class XORTask
    extends MRTask<XORTask> {
        long _res = 0L;

        private XORTask() {
        }

        public void map(Chunk c) {
            for (int i = 0; i < c._len; ++i) {
                this._res ^= c.at8(i);
            }
        }

        public void reduce(XORTask xort) {
            this._res ^= xort._res;
        }
    }
}

