/*
 * Decompiled with CFR 0.152.
 */
package water.persist;

import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import java.net.URI;
import java.util.Arrays;
import water.Key;
import water.api.FSIOException;

class GcsBlob {
    static final String KEY_PREFIX = "gs://";
    private static final int KEY_PREFIX_LENGTH = "gs://".length();
    private final String canonical;
    private final BlobId blobId;
    private final Key key;

    private GcsBlob(String bucket, String key) {
        this.canonical = GcsBlob.toCanonical(bucket, key);
        this.blobId = BlobId.of((String)bucket, (String)key);
        this.key = Key.make((String)this.canonical);
    }

    static GcsBlob of(String bucket, String key) {
        return new GcsBlob(bucket, key);
    }

    static GcsBlob of(String s) {
        String canonical = GcsBlob.toCanonical(s);
        String[] bk = canonical.substring(KEY_PREFIX_LENGTH).split("/", 2);
        if (bk.length == 2) {
            return GcsBlob.of(bk[0], bk[1]);
        }
        throw new FSIOException(s, "Cannot parse blob name");
    }

    static GcsBlob of(URI uri) {
        return GcsBlob.of(uri.toString());
    }

    static GcsBlob of(Key k) {
        String s = new String(k._kb[0] == 5 ? Arrays.copyOfRange(k._kb, 10, k._kb.length) : k._kb);
        return GcsBlob.of(s);
    }

    static GcsBlob of(BlobId blobId) {
        return GcsBlob.of(blobId.getBucket(), blobId.getName());
    }

    static GcsBlob of(Blob blob) {
        return GcsBlob.of(blob.getBlobId());
    }

    String getCanonical() {
        return this.canonical;
    }

    BlobId getBlobId() {
        return this.blobId;
    }

    BlobInfo getBlobInfo() {
        return BlobInfo.newBuilder((BlobId)this.blobId).build();
    }

    Key getKey() {
        return this.key;
    }

    static String toCanonical(String s) {
        if (s.startsWith(KEY_PREFIX)) {
            return s;
        }
        if (s.startsWith("/")) {
            return KEY_PREFIX + s.substring(1);
        }
        return KEY_PREFIX + s;
    }

    private static String toCanonical(String bucket, String key) {
        return KEY_PREFIX + bucket + '/' + key;
    }

    static String removePrefix(String s) {
        if (s.startsWith(KEY_PREFIX)) {
            return s.substring(KEY_PREFIX_LENGTH);
        }
        if (s.startsWith("/")) {
            return s.substring(1);
        }
        return s;
    }
}

